/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.scroll;

import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
public class RadioListElement
extends ScrollBox.ScrollElement {
    private static final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"mapfrontiers", (String)"textures/gui/radio_buttons.png");
    private static final int textureSizeX = 24;
    private static final int textureSizeY = 12;
    private final StringWidget label;
    private final int id;

    public RadioListElement(Font font, Component text, int id) {
        super(200, 16);
        this.label = new StringWidget(text, font).setColor(-6710887);
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    @Override
    protected void setX(int x) {
        super.setX(x);
        this.label.setX(x + 20);
    }

    @Override
    protected void setY(int y) {
        super.setY(y);
        this.label.setY(y + 4);
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, boolean selected, boolean focused) {
        if (this.isHovered) {
            graphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, -1607454672);
        }
        this.drawRadio(graphics, this.x + 2, this.y + 2, selected);
        this.label.render(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected ScrollBox.ScrollElement.Action mousePressed(double mouseX, double mouseY) {
        if (this.visible && this.isHovered) {
            return ScrollBox.ScrollElement.Action.Clicked;
        }
        return ScrollBox.ScrollElement.Action.None;
    }

    private void drawRadio(GuiGraphics graphics, int x, int y, boolean checked) {
        graphics.blit(RenderType::guiTextured, texture, x, y, checked ? 12.0f : 0.0f, 0.0f, 12, 12, 24, 12);
    }
}

