/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.ButtonBase;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.common.Config;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.Component;

public class SortToolbar
extends LinearLayout {
    private SortButton selected;
    private Runnable onChange;

    public SortToolbar(Font font, Runnable onChange) {
        super(0, 0, LinearLayout.Orientation.HORIZONTAL);
        this.spacing(8);
        this.onChange = onChange;
        for (Config.Sorting sort : Config.Sorting.values()) {
            int index = Config.frontierSorting.indexOf((Object)sort);
            if (index == -1) continue;
            SortButton button = (SortButton)this.addChild((LayoutElement)new SortButton(font, sort, Config.frontierSortingDirection.get(index), this::buttonPressed));
            if (index != 0) continue;
            this.selected = button;
            this.selected.setSelected(true);
        }
    }

    private void buttonPressed(Button button) {
        if (button instanceof SortButton) {
            SortButton sortButton = (SortButton)button;
            if (sortButton == this.selected) {
                sortButton.changeDirection();
                Config.frontierSortingDirection.set(0, Config.frontierSortingDirection.getFirst() == false);
            } else {
                this.selected.setSelected(false);
                int index = Config.frontierSorting.indexOf((Object)sortButton.getSorting());
                Config.frontierSorting.addFirst(Config.frontierSorting.remove(index));
                Config.frontierSortingDirection.addFirst(Config.frontierSortingDirection.remove(index));
                this.selected = sortButton;
                this.selected.setSelected(true);
            }
            ClientEventHandler.postUpdatedConfigEvent();
        }
        this.onChange.run();
    }

    @ParametersAreNonnullByDefault
    public static class SortButton
    extends ButtonBase {
        private final LinearLayout layout = LinearLayout.horizontal();
        private boolean selected = false;
        private final Config.Sorting sorting;
        private boolean direction;
        private final StringWidget label;
        private final IconButton iconButton;

        public SortButton(Font font, Config.Sorting sorting, boolean direction, Button.OnPress onPress) {
            super(0, 0, 0, 0, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
            this.sorting = sorting;
            this.direction = direction;
            this.layout.defaultCellSetting().alignVerticallyMiddle();
            Component text = Config.getTranslatedEnum(sorting);
            this.label = (StringWidget)this.layout.addChild((LayoutElement)new StringWidget(text, font, 16));
            this.iconButton = (IconButton)this.layout.addChild((LayoutElement)new IconButton(direction ? IconButton.Type.SortUp : IconButton.Type.SortDown, b -> {}));
            this.layout.arrangeElements();
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.iconButton.setAlpha(selected ? 1.0f : 0.0f);
        }

        public void changeDirection() {
            this.direction = !this.direction;
            this.iconButton.setType(this.direction ? IconButton.Type.SortUp : IconButton.Type.SortDown);
        }

        public Config.Sorting getSorting() {
            return this.sorting;
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            if (this.isHoveredOrKeyboardFocused()) {
                this.label.setColor(-1);
                this.iconButton.setFocused(true);
            } else {
                this.label.setColor(-6710887);
                this.iconButton.setFocused(false);
            }
            this.label.render(graphics, mouseX, mouseY, partialTicks);
            if (this.selected) {
                this.iconButton.render(graphics, mouseX, mouseY, partialTicks);
            }
        }

        public void setX(int x) {
            super.setX(x);
            this.layout.setX(x);
        }

        public void setY(int y) {
            super.setY(y);
            this.layout.setY(y);
        }

        public int getWidth() {
            return this.layout.getWidth();
        }

        public int getHeight() {
            return this.layout.getHeight();
        }
    }
}

