/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.util;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

@ParametersAreNonnullByDefault
public class ScreenHelper {
    public static float getScaleFactorThatFit(Minecraft minecraft, Screen screen, int minWidth, int minHeight) {
        int maxScale;
        int windowScale = minecraft.getWindow().getGuiScale();
        if (windowScale == 1 || minWidth <= screen.width && minHeight <= screen.height) {
            return 1.0f;
        }
        int baseWidth = screen.width * windowScale;
        int baseHeight = screen.height * windowScale;
        for (maxScale = windowScale; maxScale > 1 && (minWidth > baseWidth / maxScale || minHeight > baseHeight / maxScale); --maxScale) {
        }
        return (float)windowScale / (float)maxScale;
    }

    public static boolean hasControlDown() {
        if (Util.getPlatform() == Util.OS.OSX) {
            return InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)343) || InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)347);
        }
        return InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)341) || InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)345);
    }

    public static boolean hasShiftDown() {
        return InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)340) || InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)344);
    }

    private ScreenHelper() {
    }
}

