/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierCreated;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketSettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
public class PacketCreateFrontier {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"mapfrontiers", (String)"packet_create_frontier");
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketCreateFrontier> STREAM_CODEC = StreamCodec.ofMember(PacketCreateFrontier::encode, PacketCreateFrontier::new);
    private ResourceKey<Level> dimension = Level.OVERWORLD;
    private boolean personal = false;
    private List<BlockPos> vertices;
    private List<ChunkPos> chunks;

    public PacketCreateFrontier(ResourceKey<Level> dimension, boolean personal, @Nullable List<BlockPos> vertices, @Nullable List<ChunkPos> chunks) {
        this.dimension = dimension;
        this.personal = personal;
        this.vertices = vertices;
        this.chunks = chunks;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public PacketCreateFrontier(FriendlyByteBuf buf) {
        try {
            if (buf.readableBytes() > 1) {
                boolean hasChunks;
                this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)buf.readResourceLocation());
                this.personal = buf.readBoolean();
                boolean hasVertex = buf.readBoolean();
                if (hasVertex) {
                    this.vertices = new ArrayList<BlockPos>();
                    int vertexCount = buf.readInt();
                    for (int i = 0; i < vertexCount; ++i) {
                        BlockPos vertex = BlockPos.of((long)buf.readLong());
                        this.vertices.add(vertex);
                    }
                }
                if (hasChunks = buf.readBoolean()) {
                    this.chunks = new ArrayList<ChunkPos>();
                    int chunksCount = buf.readInt();
                    for (int i = 0; i < chunksCount; ++i) {
                        ChunkPos chunk = new ChunkPos(buf.readLong());
                        this.chunks.add(chunk);
                    }
                }
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketCreateFrontier: %s", t));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            buf.writeResourceLocation(this.dimension.location());
            buf.writeBoolean(this.personal);
            buf.writeBoolean(this.vertices != null);
            if (this.vertices != null) {
                buf.writeInt(this.vertices.size());
                for (BlockPos blockPos : this.vertices) {
                    buf.writeLong(blockPos.asLong());
                }
            }
            buf.writeBoolean(this.chunks != null);
            if (this.chunks != null) {
                buf.writeInt(this.chunks.size());
                for (ChunkPos chunkPos : this.chunks) {
                    buf.writeLong(chunkPos.toLong());
                }
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketCreateFrontier: %s", t));
        }
    }

    public static void handle(PacketContext<PacketCreateFrontier> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            PacketCreateFrontier message = (PacketCreateFrontier)ctx.message();
            ServerPlayer player = ctx.sender();
            if (player == null) {
                return;
            }
            MinecraftServer server = player.level().getServer();
            if (message.personal) {
                FrontierData frontier = FrontiersManager.instance.createNewPersonalFrontier(message.dimension, player, message.vertices, message.chunks);
                PacketHandler.sendToUsersWithAccess(new PacketFrontierCreated(frontier, player.getId()), frontier, server);
                return;
            }
            if (FrontiersManager.instance.getSettings().checkAction(FrontierSettings.Action.CreateGlobalFrontier, new SettingsUser((Player)player), MapFrontiers.isOPorHost(player), null)) {
                FrontierData frontier = FrontiersManager.instance.createNewGlobalFrontier(message.dimension, player, message.vertices, message.chunks);
                PacketHandler.sendToAll(new PacketFrontierCreated(frontier, player.getId()), server);
                return;
            }
            PacketHandler.sendTo(new PacketSettingsProfile(FrontiersManager.instance.getSettings().getProfile(player)), player);
        }
    }
}

