/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.platform;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.common.util.ReflectionHelper;
import games.alejandrocoria.mapfrontiers.platform.services.IJourneyMapHelper;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.MarkerOverlay;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.client.data.WorldData;
import journeymap.client.io.FileHandler;
import journeymap.client.io.ThemeLoader;
import journeymap.client.model.map.MapState;
import journeymap.client.model.map.MapType;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawMarkerStep;
import journeymap.client.render.draw.DrawPolygonStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.MapRenderer;
import journeymap.client.render.map.Renderer;
import journeymap.client.render.pip.PolygonPipRenderState;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.minimap.Position;
import journeymap.client.ui.minimap.Shape;
import journeymap.client.ui.theme.Theme;
import journeymap.common.accessors.GuiRenderStateMixinAccess;
import journeymap.common.mixin.client.GuiGraphicsAccessor;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class NeoForgeJourneyMapHelper
implements IJourneyMapHelper {
    private static boolean minimapPropertiesInitialized = false;
    private static boolean minimapEnabled;
    private static int minimapSize;
    private static Shape minimapShape;
    private static Position minimapPosition;
    private static String minimapInfo1;
    private static String minimapInfo2;
    private static String minimapInfo3;
    private static String minimapInfo4;
    private static int minimapFontScale;
    private static int minimapCompassFontScale;

    @Override
    public File getJMWorldDir(Minecraft client) {
        return FileHandler.getJMWorldDir((Minecraft)client);
    }

    @Override
    public void fullscreenMapCenterOn(int x, int z) {
        UIManager.INSTANCE.openFullscreenMap().centerOn((double)x, (double)z);
    }

    @Override
    public boolean isMinimapEnabled() {
        return UIManager.INSTANCE.isMiniMapEnabled();
    }

    @Override
    public void drawMinimapPreview(GuiGraphics graphics) {
        UIManager.INSTANCE.getMiniMap().drawMap(graphics, true);
    }

    @Override
    public double getMinimapWidth() throws NoSuchFieldException, IllegalAccessException {
        return (Double)ReflectionHelper.getPrivateField(NeoForgeJourneyMapHelper.getDisplayVars(), "minimapWidth");
    }

    @Override
    public double getMinimapHeight() throws NoSuchFieldException, IllegalAccessException {
        return (Double)ReflectionHelper.getPrivateField(NeoForgeJourneyMapHelper.getDisplayVars(), "minimapHeight");
    }

    @Override
    public double getMinimapTranslateX() throws NoSuchFieldException, IllegalAccessException {
        return (Double)ReflectionHelper.getPrivateField(NeoForgeJourneyMapHelper.getDisplayVars(), "translateX");
    }

    @Override
    public double getMinimapTranslateY() throws NoSuchFieldException, IllegalAccessException {
        return (Double)ReflectionHelper.getPrivateField(NeoForgeJourneyMapHelper.getDisplayVars(), "translateY");
    }

    @Override
    public int getMinimapMargin() {
        Object minimapSpec = UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties().shape.get() == Shape.Circle && ThemeLoader.getCurrentTheme().minimap.circle != null ? ThemeLoader.getCurrentTheme().minimap.circle : ThemeLoader.getCurrentTheme().minimap.square;
        return minimapSpec.margin;
    }

    @Override
    public IJourneyMapHelper.JMPosition getMinimapPosition() {
        return switch ((Position)UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties().position.get()) {
            case Position.TopRight -> IJourneyMapHelper.JMPosition.TopRight;
            case Position.BottomRight -> IJourneyMapHelper.JMPosition.BottomRight;
            case Position.BottomLeft -> IJourneyMapHelper.JMPosition.BottomLeft;
            case Position.TopLeft -> IJourneyMapHelper.JMPosition.TopLeft;
            case Position.TopCenter -> IJourneyMapHelper.JMPosition.TopCenter;
            case Position.Center -> IJourneyMapHelper.JMPosition.Center;
            default -> IJourneyMapHelper.JMPosition.Custom;
        };
    }

    @Override
    public int minimapLabelBackgroundColor() {
        if (UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties().shape.get() == Shape.Circle && ThemeLoader.getCurrentTheme().minimap.circle != null) {
            return NeoForgeJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.circle.labelTop.background);
        }
        return NeoForgeJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.square.labelTop.background);
    }

    @Override
    public int minimapLabelHighlightColor() {
        if (UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties().shape.get() == Shape.Circle && ThemeLoader.getCurrentTheme().minimap.circle != null) {
            return NeoForgeJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.circle.labelTop.highlight);
        }
        return NeoForgeJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.square.labelTop.highlight);
    }

    @Override
    public int minimapLabelForegroundColor() {
        if (UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties().shape.get() == Shape.Circle && ThemeLoader.getCurrentTheme().minimap.circle != null) {
            return NeoForgeJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.circle.labelTop.foreground);
        }
        return NeoForgeJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.square.labelTop.foreground);
    }

    @Override
    public boolean minimapPropertiesChanged() {
        if (!minimapPropertiesInitialized) {
            NeoForgeJourneyMapHelper.setAllMinimapProperties();
            return true;
        }
        MiniMapProperties minimapProperties = UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties();
        if (!(minimapEnabled == minimapProperties.enabled.get() && minimapSize == minimapProperties.sizePercent.get() && minimapShape == minimapProperties.shape.get() && minimapPosition == minimapProperties.position.get() && minimapInfo1.equals(minimapProperties.info1Label.get()) && minimapInfo2.equals(minimapProperties.info2Label.get()) && minimapInfo3.equals(minimapProperties.info3Label.get()) && minimapInfo4.equals(minimapProperties.info4Label.get()) && minimapFontScale == minimapProperties.fontScale.get().intValue() && minimapCompassFontScale == minimapProperties.compassFontScale.get().intValue())) {
            NeoForgeJourneyMapHelper.setAllMinimapProperties();
            return true;
        }
        return false;
    }

    @Override
    public List<String> getDimensionList() {
        ArrayList<String> list = new ArrayList<String>();
        List dimensionProviders = WorldData.getDimensionProviders((List)WaypointStore.getInstance().getLoadedDimensions());
        for (WorldData.DimensionProvider dimension : dimensionProviders) {
            list.add(dimension.getDimensionId());
        }
        return list;
    }

    @Override
    public IJourneyMapHelper.ICustomPreviewRenderer createCustomPreviewRenderer() {
        return new CustomPreviewRenderer();
    }

    private static int colorSpecToInt(Theme.ColorSpec colorSpec) {
        int color = colorSpec.getColor();
        return color |= Math.round(colorSpec.alpha * 255.0f) << 24;
    }

    private static DisplayVars getDisplayVars() throws NoSuchFieldException, IllegalAccessException {
        MiniMap minimap = UIManager.INSTANCE.getMiniMap();
        return (DisplayVars)ReflectionHelper.getPrivateField(minimap, "dv");
    }

    private static void setAllMinimapProperties() {
        MiniMapProperties minimapProperties = UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties();
        minimapEnabled = minimapProperties.enabled.get();
        minimapSize = minimapProperties.sizePercent.get();
        minimapShape = (Shape)minimapProperties.shape.get();
        minimapPosition = (Position)minimapProperties.position.get();
        minimapInfo1 = minimapProperties.info1Label.get();
        minimapInfo2 = minimapProperties.info2Label.get();
        minimapInfo3 = minimapProperties.info3Label.get();
        minimapInfo4 = minimapProperties.info4Label.get();
        minimapFontScale = minimapProperties.fontScale.get().intValue();
        minimapCompassFontScale = minimapProperties.compassFontScale.get().intValue();
        minimapPropertiesInitialized = true;
    }

    private static class CustomPreviewRenderer
    implements IJourneyMapHelper.ICustomPreviewRenderer {
        private final MapRenderer mapRenderer;
        private final List<DrawStep> drawSteps = new ArrayList<DrawStep>();

        public CustomPreviewRenderer() {
            this.mapRenderer = new MapRenderer(Context.UI.Fullscreen);
            this.mapRenderer.setZoom(512.0);
            this.mapRenderer.setViewPortBounds(null);
            MapState mapState = new MapState();
            mapState.setMapType(MapType.day((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"overworld"))));
            this.mapRenderer.setContext(mapState);
            this.mapRenderer.center(mapState.getWorldDir(), mapState.getMapType(), 0.0, 0.0, 512);
        }

        @Override
        public void setFrontiers(List<FrontierOverlay> frontierOverlays) {
            this.drawSteps.clear();
            for (FrontierOverlay frontierOverlay : frontierOverlays) {
                for (PolygonOverlay polygon : frontierOverlay.getPolygonOverlays()) {
                    this.drawSteps.add((DrawStep)new DrawPolygonStep(polygon));
                }
                for (MarkerOverlay banner : frontierOverlay.getBannerOverlays()) {
                    this.drawSteps.add((DrawStep)new DrawMarkerStep(banner));
                }
            }
        }

        @Override
        public void draw(GuiGraphics graphics, MultiBufferSource.BufferSource buffers, int x, int y, int size, float scaleFactor) {
            if (this.drawSteps.isEmpty()) {
                return;
            }
            int width = Minecraft.getInstance().getWindow().getScreenWidth();
            int height = Minecraft.getInstance().getWindow().getScreenHeight();
            double guiScale = Minecraft.getInstance().getWindow().getGuiScale();
            graphics.pose().pushMatrix();
            graphics.pose().translate((float)((double)(-width) / guiScale / 2.0 * (double)scaleFactor) + (float)x, (float)((double)(-height) / guiScale / 2.0 * (double)scaleFactor) + (float)y);
            graphics.pose().scale((float)(1.0 / guiScale) * scaleFactor, (float)(1.0 / guiScale) * scaleFactor);
            this.mapRenderer.setViewPortBounds(new Rectangle2D.Double(0.0, 0.0, (float)width * scaleFactor, (float)height * scaleFactor));
            for (DrawStep drawStep : this.drawSteps) {
                if (drawStep instanceof DrawPolygonStep) continue;
                drawStep.draw(graphics, 0.0, 0.0, (Renderer)this.mapRenderer, 1.0, 0.0);
            }
            graphics.pose().popMatrix();
            graphics.nextStratum();
            ((GuiRenderStateMixinAccess)((GuiGraphicsAccessor)graphics).jm$GuiRenderStateAccessor()).jm$submitPicturesInPictureStateCurrentLayer((PictureInPictureRenderState)new PolygonPipRenderState(graphics, Context.UI.Fullscreen, 0.0, (buf, poseStack) -> {
                VertexConsumer maskBuffer = buffers.getBuffer(JMRenderTypes.MINIMAP_RECTANGLE_MASK_RENDER_TYPE);
                DrawUtil.drawQuad((PoseStack)poseStack, (VertexConsumer)maskBuffer, (int)0xFFFFFF, (float)1.0f, (double)((double)x * guiScale / (double)scaleFactor + 1.0), (double)((double)y * guiScale / (double)scaleFactor + 1.0), (double)(size - 1), (double)(size - 1), (double)0.0, (boolean)false);
                this.drawSteps.forEach(drawStep -> {
                    if (drawStep instanceof DrawPolygonStep) {
                        DrawPolygonStep drawPolygonStep = (DrawPolygonStep)drawStep;
                        poseStack.pushPose();
                        drawPolygonStep.draw(graphics, poseStack, buf, (double)(-width / 2) + (double)x * guiScale / (double)scaleFactor, (double)(-height / 2) + (double)y * guiScale / (double)scaleFactor, (Renderer)this.mapRenderer, 1.0, 0.0);
                        poseStack.popPose();
                    }
                });
            }));
        }
    }
}

