/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import games.alejandrocoria.mapfrontiers.client.gui.component.button.ButtonBase;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class TabbedBox
implements Layout {
    private final Font font;
    private final IntConsumer tabChanged;
    private int width;
    private int height;
    private final List<Tab> tabs = new ArrayList<Tab>();
    private final List<FrameLayout> contents = new ArrayList<FrameLayout>();
    private final LinearLayout mainLayout = LinearLayout.vertical().spacing(16);
    private final LinearLayout tabLayouts = LinearLayout.horizontal();
    private final FrameLayout contentLayouts = new FrameLayout();
    private int selected;

    public TabbedBox(Font font, int width, int height, IntConsumer tabChanged) {
        this.font = font;
        this.tabChanged = tabChanged;
        this.selected = -1;
        this.width = width;
        this.height = height;
        this.contentLayouts.setMinDimensions(width, height - 32);
        this.mainLayout.addChild((LayoutElement)this.tabLayouts, LayoutSettings.defaults().alignHorizontallyCenter());
        this.mainLayout.addChild((LayoutElement)this.contentLayouts, LayoutSettings.defaults().alignHorizontallyCenter());
    }

    public void addTab(Component text, boolean enabled) {
        this.tabs.add(new Tab(this.font, text, this.tabs.size(), enabled, this::setTabSelected));
        this.tabLayouts.addChild((LayoutElement)this.tabs.getLast());
        this.contents.add(new FrameLayout(this.width, this.height - 32));
        this.contentLayouts.addChild((LayoutElement)this.contents.getLast());
        if (this.selected == -1) {
            this.selected = 0;
        }
    }

    public void setTabSelected(int tab) {
        if (this.selected != -1) {
            this.tabs.get(this.selected).setSelected(false);
        }
        this.selected = tab;
        this.tabs.get(this.selected).setSelected(true);
        for (int i = 0; i < this.contents.size(); ++i) {
            if (i == this.selected) {
                this.contents.get(i).visitWidgets(widget -> {
                    widget.visible = true;
                });
                continue;
            }
            this.contents.get(i).visitWidgets(widget -> {
                widget.visible = false;
            });
        }
        this.tabChanged.accept(this.selected);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.contentLayouts.setMinDimensions(width, height - 32);
        for (FrameLayout content : this.contents) {
            content.setMinDimensions(width, height - 32);
        }
        this.arrangeElements();
    }

    public <T extends LayoutElement> T addChild(T layoutElement, int tab) {
        this.contents.get(tab).addChild(layoutElement);
        return layoutElement;
    }

    public <T extends LayoutElement> T addChild(T layoutElement, int tab, LayoutSettings layoutSettings) {
        this.contents.get(tab).addChild(layoutElement, layoutSettings);
        return layoutElement;
    }

    public void visitChildren(Consumer<LayoutElement> visitor) {
        this.mainLayout.visitChildren(visitor);
    }

    public void arrangeElements() {
        this.mainLayout.arrangeElements();
    }

    public int getWidth() {
        return this.mainLayout.getWidth();
    }

    public int getHeight() {
        return this.mainLayout.getHeight();
    }

    public void setX(int x) {
        this.mainLayout.setX(x);
    }

    public void setY(int y) {
        this.mainLayout.setY(y);
    }

    public int getX() {
        return this.mainLayout.getX();
    }

    public int getY() {
        return this.mainLayout.getY();
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.fill(this.getX(), this.getY() + 16, this.getX() + this.width, this.getY() + this.height, -955248624);
        if (this.selected == -1) {
            graphics.hLine(this.getX(), this.getX() + this.width, this.getY() + 16, -8947849);
        } else {
            Tab tab = this.tabs.get(this.selected);
            graphics.hLine(this.getX(), tab.getX(), this.getY() + 16, -8947849);
            graphics.hLine(tab.getX() + tab.getWidth(), this.getX() + this.width, this.getY() + 16, -8947849);
        }
        graphics.hLine(this.getX(), this.getX() + this.width, this.getY() + this.height, -8947849);
        graphics.vLine(this.getX(), this.getY() + 16, this.getY() + this.height, -8947849);
        graphics.vLine(this.getX() + this.width, this.getY() + 16, this.getY() + this.height, -8947849);
    }

    private static class Tab
    extends ButtonBase {
        private final Font font;
        private boolean selected = false;

        public Tab(Font font, Component text, int index, boolean enabled, Consumer<Integer> onPress) {
            super(0, 0, 70, 16, text, b -> onPress.accept(index), Button.DEFAULT_NARRATION);
            this.font = font;
            this.active = enabled;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), -955248624);
            graphics.hLine(this.getX(), this.getX() + this.getWidth(), this.getY(), this.isKeyboardFocused() ? -1 : -8947849);
            graphics.vLine(this.getX(), this.getY(), this.getY() + this.getHeight(), -8947849);
            graphics.vLine(this.getX() + this.getWidth(), this.getY(), this.getY() + this.getHeight(), -8947849);
            int labelColor = -8947849;
            if (!this.active) {
                labelColor = -12303292;
            } else if (this.selected || this.isHoveredOrKeyboardFocused()) {
                labelColor = -1;
            }
            graphics.drawCenteredString(this.font, this.getMessage(), this.getX() + this.getWidth() / 2, this.getY() + 5, labelColor);
        }
    }
}

