/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.hud;

import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import games.alejandrocoria.mapfrontiers.client.gui.hud.HUD;
import games.alejandrocoria.mapfrontiers.common.Config;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class HUDWidget
extends AbstractWidgetNoNarration {
    private final HUD hud;
    private final boolean minimapEnabled;
    private Config.Point positionHUD = new Config.Point();
    private final Config.Point grabOffset = new Config.Point();
    private boolean grabbed = false;
    private final Consumer<HUDWidget> callbackHUDUpdated;

    public HUDWidget(HUD hud, boolean minimapEnabled, Consumer<HUDWidget> callbackHUDUpdated) {
        super(0, 0, 0, 0, (Component)Component.empty());
        this.hud = hud;
        this.minimapEnabled = minimapEnabled;
        this.callbackHUDUpdated = callbackHUDUpdated;
    }

    public void setPositionHUD(Config.Point positionHUD) {
        this.positionHUD = positionHUD;
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent navigationEvent) {
        return null;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        int factor = (int)Minecraft.getInstance().getWindow().getGuiScale();
        int xScaled = (int)mouseX * factor;
        int yScaled = (int)mouseY * factor;
        return this.active && this.visible && this.hud.isInside(xScaled, yScaled);
    }

    public void onClick(double mouseX, double mouseY) {
        int factor = (int)Minecraft.getInstance().getWindow().getGuiScale();
        int xScaled = (int)mouseX * factor;
        int yScaled = (int)mouseY * factor;
        this.grabOffset.x = xScaled - this.positionHUD.x;
        this.grabOffset.y = yScaled - this.positionHUD.y;
        this.grabbed = true;
    }

    public void onRelease(double mouseX, double mouseY) {
        this.grabbed = false;
    }

    public void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.grabbed) {
            Minecraft mc = Minecraft.getInstance();
            float factor = (float)mc.getWindow().getGuiScale();
            this.positionHUD.x = (int)(mouseX *= (double)factor) - this.grabOffset.x;
            this.positionHUD.y = (int)(mouseY *= (double)factor) - this.grabOffset.y;
            Config.Point anchorPoint = Config.getHUDAnchor(Config.hudAnchor);
            Config.Point originPoint = Config.getHUDOrigin(Config.hudAnchor, this.hud.getWidth(), this.hud.getHeight());
            if (Config.hudAutoAdjustAnchor) {
                Config.HUDAnchor closestAnchor = null;
                int closestDistance = 99999;
                Config.HUDAnchor[] hUDAnchorArray = Config.HUDAnchor.values();
                int n = hUDAnchorArray.length;
                for (int i = 0; i < n; ++i) {
                    Config.HUDAnchor anchor = hUDAnchorArray[i];
                    if ((anchor == Config.HUDAnchor.Minimap || anchor == Config.HUDAnchor.MinimapHorizontal || anchor == Config.HUDAnchor.MinimapVertical) && !this.minimapEnabled) continue;
                    Config.Point anchorP = Config.getHUDAnchor(anchor);
                    Config.Point originP = Config.getHUDOrigin(anchor, this.hud.getWidth(), this.hud.getHeight());
                    int distance = Math.abs(anchorP.x - this.positionHUD.x - originP.x) + Math.abs(anchorP.y - this.positionHUD.y - originP.y);
                    if (distance >= closestDistance) continue;
                    closestDistance = distance;
                    closestAnchor = anchor;
                }
                if (closestAnchor != null && closestAnchor != Config.hudAnchor) {
                    Config.hudAnchor = closestAnchor;
                    anchorPoint = Config.getHUDAnchor(Config.hudAnchor);
                    originPoint = Config.getHUDOrigin(Config.hudAnchor, this.hud.getWidth(), this.hud.getHeight());
                    this.callbackHUDUpdated.accept(this);
                }
            }
            Config.Point snapOffset = new Config.Point();
            if (Config.hudSnapToBorder) {
                snapOffset.x = 16;
                snapOffset.y = 16;
                for (Config.HUDAnchor anchor : Config.HUDAnchor.values()) {
                    if (anchor == Config.HUDAnchor.MinimapHorizontal || anchor == Config.HUDAnchor.MinimapVertical) continue;
                    Config.Point anchorP = Config.getHUDAnchor(anchor);
                    Config.Point originP = Config.getHUDOrigin(anchor, this.hud.getWidth(), this.hud.getHeight());
                    int offsetX = this.positionHUD.x - anchorP.x + originP.x;
                    int offsetY = this.positionHUD.y - anchorP.y + originP.y;
                    if (anchor == Config.HUDAnchor.Minimap) {
                        if (!this.minimapEnabled) continue;
                        int displayWidth = mc.getWindow().getWidth();
                        int displayHeight = mc.getWindow().getHeight();
                        if (anchorP.x < displayWidth / 2 && offsetX >= 16 || anchorP.x > displayWidth / 2 && offsetX <= -16 || anchorP.y < displayHeight / 2 && offsetY >= 16 || anchorP.y > displayHeight / 2 && offsetY <= -16) continue;
                    }
                    if (Math.abs(offsetX) < Math.abs(snapOffset.x)) {
                        snapOffset.x = offsetX;
                    }
                    if (Math.abs(offsetY) >= Math.abs(snapOffset.y)) continue;
                    snapOffset.y = offsetY;
                }
                if (snapOffset.x == 16) {
                    snapOffset.x = 0;
                }
                if (snapOffset.y == 16) {
                    snapOffset.y = 0;
                }
            }
            Config.hudXPosition = this.positionHUD.x - anchorPoint.x + originPoint.x - snapOffset.x;
            Config.hudYPosition = this.positionHUD.y - anchorPoint.y + originPoint.y - snapOffset.y;
            this.hud.configUpdated();
            this.callbackHUDUpdated.accept(this);
        }
    }

    public void playDownSound(SoundManager soundHandlerIn) {
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.hud.draw(graphics, partialTicks);
        if (!this.grabbed) {
            this.positionHUD.x = this.hud.getPosX();
            this.positionHUD.y = this.hud.getPosY();
        }
    }
}

