/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.settings;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.util.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class SettingsUser
implements Comparable<SettingsUser> {
    public String username;
    public UUID uuid;

    public SettingsUser() {
        this.username = "";
    }

    public SettingsUser(Player player) {
        this.username = player.getName().getString();
        this.uuid = player.getUUID();
    }

    public boolean isEmpty() {
        return this.uuid == null && StringUtils.isBlank((CharSequence)this.username);
    }

    public void fillMissingInfo(boolean forceNameUpdate, @Nullable MinecraftServer server) {
        if (this.isEmpty()) {
            return;
        }
        if (this.uuid == null) {
            this.uuid = UUIDHelper.getUUIDFromName(this.username, server);
        } else if (StringUtils.isBlank((CharSequence)this.username) || forceNameUpdate) {
            String newUsername = UUIDHelper.getNameFromUUID(this.uuid, server);
            if (newUsername != null) {
                this.username = newUsername;
            } else if (this.username == null) {
                this.username = "";
            }
        }
    }

    public void readFromNBT(CompoundTag nbt) {
        this.username = nbt.getStringOr("username", "");
        try {
            this.uuid = UUID.fromString(nbt.getStringOr("UUID", ""));
        }
        catch (Exception e) {
            MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.putString("username", this.username);
        if (this.uuid != null) {
            nbt.putString("UUID", this.uuid.toString());
        }
    }

    public void fromBytes(FriendlyByteBuf buf) {
        boolean hasUsername = buf.readBoolean();
        this.username = hasUsername ? buf.readUtf(17) : "";
        boolean hasUUID = buf.readBoolean();
        this.uuid = hasUUID ? UUIDHelper.fromBytes((ByteBuf)buf) : null;
    }

    public void toBytes(FriendlyByteBuf buf) {
        if (StringUtils.isBlank((CharSequence)this.username)) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeUtf(this.username, 17);
        }
        if (this.uuid == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            UUIDHelper.toBytes((ByteBuf)buf, this.uuid);
        }
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SettingsUser) {
            SettingsUser user = (SettingsUser)other;
            if (this.uuid != null) {
                return this.uuid.equals(user.uuid);
            }
            return this.username.equals(user.username);
        }
        return false;
    }

    public String toString() {
        return this.toString(I18n.get((String)"mapfrontiers.unnamed", (Object[])new Object[]{ChatFormatting.ITALIC}));
    }

    public String toString(String blank) {
        if (!StringUtils.isBlank((CharSequence)this.username)) {
            return this.username;
        }
        if (this.uuid != null) {
            return this.uuid.toString();
        }
        return blank;
    }

    @Override
    public int compareTo(SettingsUser other) {
        if (StringUtils.isBlank((CharSequence)this.username) && StringUtils.isBlank((CharSequence)other.username)) {
            if (this.uuid == null || other.uuid == null) {
                return 0;
            }
            return this.uuid.compareTo(other.uuid);
        }
        if (this.username == null) {
            return other.username == null ? 0 : -1;
        }
        if (other.username == null) {
            return 1;
        }
        return this.username.compareTo(other.username);
    }
}

