/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.event;

import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.config.Hotkeys;
import fi.dy.masa.itemscroller.event.KeybindCallbacks;
import fi.dy.masa.itemscroller.event.RenderEventHandler;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.AccessorUtils;
import fi.dy.masa.itemscroller.util.ClickPacketBuffer;
import fi.dy.masa.itemscroller.util.InputUtils;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.itemscroller.util.MoveAction;
import fi.dy.masa.itemscroller.villager.VillagerDataStorage;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.IKeyboardInputHandler;
import fi.dy.masa.malilib.hotkeys.IMouseInputHandler;
import fi.dy.masa.malilib.util.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class InputHandler
implements IKeybindProvider,
IKeyboardInputHandler,
IMouseInputHandler {
    private final KeybindCallbacks callbacks = KeybindCallbacks.getInstance();

    public void addKeysToMap(IKeybindManager manager) {
        for (IHotkey iHotkey : Hotkeys.HOTKEY_LIST) {
            manager.addKeybindToMap(iHotkey.getKeybind());
        }
    }

    public void addHotkeys(IKeybindManager manager) {
        manager.addHotkeysForCategory("Item Scroller", "itemscroller.hotkeys.category.hotkeys", Hotkeys.HOTKEY_LIST);
    }

    public boolean onKeyInput(KeyEvent input, boolean eventKeyState) {
        if (InputUtils.isRecipeViewOpen() && eventKeyState) {
            int recipeIndexChange;
            int index = -1;
            RecipeStorage recipes = RecipeStorage.getInstance();
            int oldIndex = recipes.getSelection();
            int recipesPerPage = recipes.getRecipeCountPerPage();
            int n = recipeIndexChange = input.hasShiftDown() || GuiBase.isShiftDown() ? recipesPerPage : recipesPerPage / 2;
            if (input.key() >= 49 && input.key() <= 57) {
                index = Mth.clamp((int)(input.key() - 49), (int)0, (int)8);
            } else if (input.key() == 265 && oldIndex > 0) {
                index = oldIndex - 1;
            } else if (input.key() == 264 && oldIndex < recipes.getTotalRecipeCount() - 1) {
                index = oldIndex + 1;
            } else if (input.key() == 263 && oldIndex >= recipeIndexChange) {
                index = oldIndex - recipeIndexChange;
            } else if (input.key() == 262 && oldIndex < recipes.getTotalRecipeCount() - recipeIndexChange) {
                index = oldIndex + recipeIndexChange;
            }
            if (index >= 0) {
                recipes.changeSelectedRecipe(index);
                return true;
            }
        }
        return this.handleInput(input.key(), eventKeyState, 0.0);
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        return this.handleInput(-1, false, amount);
    }

    public boolean onMouseClick(MouseButtonEvent click, boolean eventButtonState) {
        return this.handleInput(click.input() - 100, eventButtonState, 0.0);
    }

    private boolean handleInput(int keyCode, boolean keyState, double dWheel) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return false;
        }
        if (Configs.Generic.RATE_LIMIT_CLICK_PACKETS.getBooleanValue() && this.callbacks.functionalityEnabled()) {
            ClickPacketBuffer.setShouldBufferClickPackets(true);
        }
        boolean cancel = this.handleInputImpl(keyCode, keyState, dWheel, mc);
        ClickPacketBuffer.setShouldBufferClickPackets(false);
        return cancel;
    }

    private boolean handleInputImpl(int keyCode, boolean keyState, double dWheel, Minecraft mc) {
        MoveAction action = InventoryUtils.getActiveMoveAction();
        if (action != MoveAction.NONE && !InputUtils.isActionKeyActive(action)) {
            InventoryUtils.stopDragging();
        }
        boolean cancel = false;
        if (this.callbacks.functionalityEnabled() && mc.player != null) {
            Screen screen;
            boolean isAttack = InputUtils.isAttack(keyCode, mc);
            boolean isUse = InputUtils.isUse(keyCode, mc);
            boolean isPickBlock = InputUtils.isPickBlock(keyCode, mc);
            boolean isAttackUseOrPick = isAttack || isUse || isPickBlock;
            int mouseX = fi.dy.masa.malilib.util.InputUtils.getMouseX();
            int mouseY = fi.dy.masa.malilib.util.InputUtils.getMouseY();
            if (Configs.Toggles.VILLAGER_TRADE_FEATURES.getBooleanValue()) {
                VillagerDataStorage storage = VillagerDataStorage.getInstance();
                if (mc.screen == null && mc.hitResult != null && mc.hitResult.getType() == HitResult.Type.ENTITY && ((EntityHitResult)mc.hitResult).getEntity() instanceof AbstractVillager) {
                    storage.setLastInteractedUUID(((EntityHitResult)mc.hitResult).getEntity().getUUID());
                }
            }
            if ((screen = mc.screen) instanceof AbstractContainerScreen) {
                AbstractContainerScreen gui = (AbstractContainerScreen)screen;
                if (!(mc.screen instanceof CreativeModeInventoryScreen) && !Configs.GUI_BLACKLIST.contains(mc.screen.getClass().getName())) {
                    RecipeStorage recipes = RecipeStorage.getInstance();
                    if (dWheel != 0.0) {
                        if (InputUtils.isRecipeViewOpen()) {
                            recipes.scrollSelection(dWheel < 0.0);
                            cancel = true;
                        } else if (!InventoryUtils.ignoreScrollingInsideOfBundles) {
                            cancel = InventoryUtils.tryMoveItems((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, recipes, dWheel > 0.0);
                        }
                    } else {
                        Slot slot = AccessorUtils.getSlotUnderMouse(gui);
                        boolean isShiftDown = GuiBase.isShiftDown();
                        if (keyState && isAttackUseOrPick) {
                            int hoveredRecipeId = RenderEventHandler.instance().getHoveredRecipeId(mouseX, mouseY, recipes, gui);
                            if (hoveredRecipeId >= 0) {
                                InventoryUtils.handleRecipeClick((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, mc, recipes, hoveredRecipeId, isAttack, isUse, isPickBlock, isShiftDown);
                                return true;
                            }
                            if (isPickBlock && InputUtils.isRecipeViewOpen() && InventoryUtils.isCraftingSlot((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, slot)) {
                                recipes.storeCraftingRecipeToCurrentSelection(slot, gui, true, false, mc);
                                cancel = true;
                            }
                        }
                        InventoryUtils.checkForItemPickup(gui);
                        if (keyState && (isAttack || isUse)) {
                            InventoryUtils.storeSourceSlotCandidate(slot, gui);
                        }
                        if (Configs.Toggles.RIGHT_CLICK_CRAFT_STACK.getBooleanValue() && isUse && keyState && InventoryUtils.isCraftingSlot((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, slot)) {
                            InventoryUtils.rightClickCraftOneStack((AbstractContainerScreen<? extends AbstractContainerMenu>)gui);
                        } else if (Configs.Toggles.SHIFT_PLACE_ITEMS.getBooleanValue() && isAttack && isShiftDown && InventoryUtils.canShiftPlaceItems((AbstractContainerScreen<? extends AbstractContainerMenu>)gui)) {
                            cancel |= InventoryUtils.shiftPlaceItems(slot, (AbstractContainerScreen<? extends AbstractContainerMenu>)gui);
                        } else if (Configs.Toggles.SHIFT_DROP_ITEMS.getBooleanValue() && isAttack && isShiftDown && InputUtils.canShiftDropItems(gui, mc, mouseX, mouseY)) {
                            cancel |= InventoryUtils.shiftDropItems((AbstractContainerScreen<? extends AbstractContainerMenu>)gui);
                        }
                    }
                }
            }
        }
        return cancel;
    }

    public void onMouseMove(double mouseX, double mouseY) {
        AbstractContainerScreen screen;
        Screen screen2;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (this.callbacks.functionalityEnabled() && mc.player != null && (screen2 = GuiUtils.getCurrentScreen()) instanceof AbstractContainerScreen && !Configs.GUI_BLACKLIST.contains((screen = (AbstractContainerScreen)screen2).getClass().getName())) {
            this.handleDragging(screen, mc, (int)mouseX, (int)mouseY, false);
        }
    }

    private boolean handleDragging(AbstractContainerScreen<?> gui, Minecraft mc, int mouseX, int mouseY, boolean isClick) {
        MoveAction action = InventoryUtils.getActiveMoveAction();
        boolean cancel = false;
        if (Configs.Generic.RATE_LIMIT_CLICK_PACKETS.getBooleanValue()) {
            ClickPacketBuffer.setShouldBufferClickPackets(true);
        }
        if (InputUtils.isActionKeyActive(action)) {
            cancel = InventoryUtils.dragMoveItems(gui, action, mouseX, mouseY, false);
        } else if (action != MoveAction.NONE) {
            InventoryUtils.stopDragging();
        }
        ClickPacketBuffer.setShouldBufferClickPackets(false);
        return cancel;
    }
}

