/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.event;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.config.Hotkeys;
import fi.dy.masa.itemscroller.gui.GuiConfigs;
import fi.dy.masa.itemscroller.mixin.recipe.IMixinCraftingResultSlot;
import fi.dy.masa.itemscroller.recipes.CraftingHandler;
import fi.dy.masa.itemscroller.recipes.RecipePattern;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.AccessorUtils;
import fi.dy.masa.itemscroller.util.ClickPacketBuffer;
import fi.dy.masa.itemscroller.util.InputUtils;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.itemscroller.util.MoveAction;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeyCallbackToggleBooleanConfigWithMessage;
import fi.dy.masa.malilib.interfaces.IClientTickHandler;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.PacketListener;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;

public class KeybindCallbacks
implements IHotkeyCallback,
IClientTickHandler {
    private static final KeybindCallbacks INSTANCE = new KeybindCallbacks();
    protected int massCraftTicker;
    private boolean recipeBookClicks = false;

    public static KeybindCallbacks getInstance() {
        return INSTANCE;
    }

    private KeybindCallbacks() {
    }

    public void setCallbacks() {
        for (ConfigHotkey hotkey : Hotkeys.HOTKEY_LIST) {
            hotkey.getKeybind().setCallback((IHotkeyCallback)this);
        }
        Hotkeys.MASS_CRAFT_TOGGLE.getKeybind().setCallback((IHotkeyCallback)new KeyCallbackToggleBooleanConfigWithMessage((IConfigBoolean)Configs.Generic.MASS_CRAFT_HOLD));
    }

    public boolean functionalityEnabled() {
        return Configs.Generic.MOD_MAIN_TOGGLE.getBooleanValue();
    }

    public boolean onKeyAction(KeyAction action, IKeybind key) {
        if (Configs.Generic.RATE_LIMIT_CLICK_PACKETS.getBooleanValue()) {
            ClickPacketBuffer.setShouldBufferClickPackets(true);
        }
        boolean cancel = this.onKeyActionImpl(action, key);
        ClickPacketBuffer.setShouldBufferClickPackets(false);
        return cancel;
    }

    private boolean onKeyActionImpl(KeyAction action, IKeybind key) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return false;
        }
        if (key == Hotkeys.TOGGLE_MOD_ON_OFF.getKeybind()) {
            Configs.Generic.MOD_MAIN_TOGGLE.toggleBooleanValue();
            String msg = this.functionalityEnabled() ? "itemscroller.message.toggled_mod_on" : "itemscroller.message.toggled_mod_off";
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.INFO, (String)msg, (Object[])new Object[0]);
            return true;
        }
        if (key == Hotkeys.OPEN_CONFIG_GUI.getKeybind()) {
            GuiBase.openGui((Screen)new GuiConfigs());
            return true;
        }
        if (!this.functionalityEnabled() || !(GuiUtils.getCurrentScreen() instanceof AbstractContainerScreen) || Configs.GUI_BLACKLIST.contains(GuiUtils.getCurrentScreen().getClass().getName())) {
            return false;
        }
        AbstractContainerScreen gui = (AbstractContainerScreen)GuiUtils.getCurrentScreen();
        Slot slot = AccessorUtils.getSlotUnderMouse(gui);
        RecipeStorage recipes = RecipeStorage.getInstance();
        MoveAction moveAction = InputUtils.getDragMoveAction(key);
        if (slot != null) {
            if (moveAction != MoveAction.NONE) {
                int mouseX = fi.dy.masa.malilib.util.InputUtils.getMouseX();
                int mouseY = fi.dy.masa.malilib.util.InputUtils.getMouseY();
                return InventoryUtils.dragMoveItems((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, moveAction, mouseX, mouseY, true);
            }
            if (key == Hotkeys.KEY_MOVE_EVERYTHING.getKeybind()) {
                InventoryUtils.tryMoveStacks(slot, (AbstractContainerScreen<? extends AbstractContainerMenu>)gui, false, true, false);
                return true;
            }
            if (key == Hotkeys.DROP_ALL_MATCHING.getKeybind() && Configs.Toggles.DROP_MATCHING.getBooleanValue() && !Configs.GUI_BLACKLIST.contains(gui.getClass().getName()) && slot.hasItem()) {
                InventoryUtils.dropStacks((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, slot.getItem(), slot, true);
                return true;
            }
        }
        if (key == Hotkeys.CRAFT_EVERYTHING.getKeybind()) {
            InventoryUtils.craftEverythingPossibleWithCurrentRecipe(recipes.getSelectedRecipe(), (AbstractContainerScreen<? extends AbstractContainerMenu>)gui);
            return true;
        }
        if (key == Hotkeys.THROW_CRAFT_RESULTS.getKeybind()) {
            InventoryUtils.throwAllCraftingResultsToGround(recipes.getSelectedRecipe(), (AbstractContainerScreen<? extends AbstractContainerMenu>)gui);
            return true;
        }
        if (key == Hotkeys.MOVE_CRAFT_RESULTS.getKeybind()) {
            InventoryUtils.moveAllCraftingResultsToOtherInventory(recipes.getSelectedRecipe(), (AbstractContainerScreen<? extends AbstractContainerMenu>)gui);
            return true;
        }
        if (key == Hotkeys.STORE_RECIPE.getKeybind()) {
            if (InputUtils.isRecipeViewOpen() && InventoryUtils.isCraftingSlot((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, slot)) {
                recipes.storeCraftingRecipeToCurrentSelection(slot, gui, true, true, mc);
                return true;
            }
        } else {
            if (key == Hotkeys.VILLAGER_TRADE_FAVORITES.getKeybind()) {
                return InventoryUtils.villagerTradeEverythingPossibleWithAllFavoritedTrades();
            }
            if (key == Hotkeys.SLOT_DEBUG.getKeybind()) {
                if (slot != null) {
                    InventoryUtils.debugPrintSlotInfo((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, slot);
                } else {
                    ItemScroller.LOGGER.info("GUI class: {}", (Object)gui.getClass().getName());
                }
                return true;
            }
            if (key == Hotkeys.SORT_INVENTORY.getKeybind() && Configs.Generic.SORT_INVENTORY_TOGGLE.getBooleanValue()) {
                InventoryUtils.sortInventory(gui);
                return true;
            }
        }
        return false;
    }

    public void onClientTick(Minecraft mc) {
        if (InventoryUtils.dontUpdateRecipeBook > 0) {
            --InventoryUtils.dontUpdateRecipeBook;
        }
        if (!this.functionalityEnabled() || mc.player == null) {
            return;
        }
        ClickPacketBuffer.sendBufferedPackets(Configs.Generic.PACKET_RATE_LIMIT.getIntegerValue());
        if (ClickPacketBuffer.shouldCancelWindowClicks()) {
            return;
        }
        Screen screen = GuiUtils.getCurrentScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            if (!(GuiUtils.getCurrentScreen() instanceof CreativeModeInventoryScreen) && !Configs.GUI_BLACKLIST.contains(GuiUtils.getCurrentScreen().getClass().getName()) && (Hotkeys.MASS_CRAFT.getKeybind().isKeybindHeld() || Configs.Generic.MASS_CRAFT_HOLD.getBooleanValue())) {
                if (++this.massCraftTicker < Configs.Generic.MASS_CRAFT_INTERVAL.getIntegerValue()) {
                    return;
                }
                InventoryUtils.bufferInvUpdates = true;
                Slot outputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui((AbstractContainerScreen<? extends AbstractContainerMenu>)gui);
                if (outputSlot != null) {
                    if (Configs.Generic.RATE_LIMIT_CLICK_PACKETS.getBooleanValue()) {
                        ClickPacketBuffer.setShouldBufferClickPackets(true);
                    }
                    RecipePattern recipe = RecipeStorage.getInstance().getSelectedRecipe();
                    int limit = Configs.Generic.MASS_CRAFT_ITERATIONS.getIntegerValue();
                    if (Configs.Generic.MASS_CRAFT_RECIPE_BOOK.getBooleanValue() && recipe.getNetworkRecipeId() != null) {
                        InventoryUtils.dontUpdateRecipeBook = 2;
                        for (int i = 0; i < limit; ++i) {
                            CraftingContainer craftingInv = ((IMixinCraftingResultSlot)outputSlot).itemscroller_getCraftingInventory();
                            if (recipe.getVanillaRecipe() != null && !recipe.getVanillaRecipe().matches((RecipeInput)craftingInv.asCraftInput(), (Level)mc.level)) {
                                CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, outputSlot);
                                int invSlots = gui.getMenu().slots.size();
                                int rangeSlots = range.getSlotCount();
                                int j = 0;
                                for (int slotNum = range.getFirst(); j < rangeSlots && slotNum < invSlots; ++j, ++slotNum) {
                                    InventoryUtils.shiftClickSlot((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, slotNum);
                                    Slot slotTmp = gui.getMenu().getSlot(slotNum);
                                    ItemStack stack = slotTmp.getItem();
                                    if (stack.isEmpty()) continue;
                                    InventoryUtils.dropStack((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, slotNum);
                                }
                            }
                            mc.gameMode.handlePlaceRecipe(gui.getMenu().containerId, recipe.getNetworkRecipeId(), true);
                            craftingInv = ((IMixinCraftingResultSlot)outputSlot).itemscroller_getCraftingInventory();
                            if (recipe.getVanillaRecipe() != null && recipe.getVanillaRecipe().matches((RecipeInput)craftingInv.asCraftInput(), (Level)mc.level)) break;
                            InventoryUtils.shiftClickSlot((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, outputSlot.index);
                            InventoryUtils.dropStack((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, outputSlot.index);
                            this.recipeBookClicks = true;
                        }
                        InventoryUtils.tryClearCursor((AbstractContainerScreen<? extends AbstractContainerMenu>)gui);
                        InventoryUtils.throwAllCraftingResultsToGround(recipe, (AbstractContainerScreen<? extends AbstractContainerMenu>)gui);
                    } else if (Configs.Generic.MASS_CRAFT_SWAPS.getBooleanValue()) {
                        for (int i = 0; i < limit; ++i) {
                            InventoryUtils.tryClearCursor((AbstractContainerScreen<? extends AbstractContainerMenu>)gui);
                            InventoryUtils.setInhibitCraftingOutputUpdate(true);
                            InventoryUtils.throwAllCraftingResultsToGround(recipe, (AbstractContainerScreen<? extends AbstractContainerMenu>)gui);
                            InventoryUtils.throwAllNonRecipeItemsToGround(recipe, (AbstractContainerScreen<? extends AbstractContainerMenu>)gui);
                            CraftingContainer inv = ((IMixinCraftingResultSlot)outputSlot).itemscroller_getCraftingInventory();
                            try {
                                Thread.sleep(0L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            InventoryUtils.setCraftingGridContentsUsingSwaps((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, mc.player.getInventory(), recipe, outputSlot);
                            InventoryUtils.setInhibitCraftingOutputUpdate(false);
                            InventoryUtils.updateCraftingOutputSlot(outputSlot);
                            if (InventoryUtils.areStacksEqual(outputSlot.getItem(), recipe.getResult())) {
                                InventoryUtils.shiftClickSlot((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, outputSlot.index);
                                continue;
                            }
                            break;
                        }
                    } else {
                        int failsafe = 0;
                        while (++failsafe < limit) {
                            InventoryUtils.tryClearCursor((AbstractContainerScreen<? extends AbstractContainerMenu>)gui);
                            InventoryUtils.setInhibitCraftingOutputUpdate(true);
                            InventoryUtils.throwAllCraftingResultsToGround(recipe, (AbstractContainerScreen<? extends AbstractContainerMenu>)gui);
                            InventoryUtils.throwAllNonRecipeItemsToGround(recipe, (AbstractContainerScreen<? extends AbstractContainerMenu>)gui);
                            InventoryUtils.tryMoveItemsToFirstCraftingGrid(recipe, (AbstractContainerScreen<? extends AbstractContainerMenu>)gui, true);
                            InventoryUtils.setInhibitCraftingOutputUpdate(false);
                            InventoryUtils.updateCraftingOutputSlot(outputSlot);
                            if (InventoryUtils.areStacksEqual(outputSlot.getItem(), recipe.getResult())) {
                                if (Configs.Generic.CARPET_CTRL_Q_CRAFTING.getBooleanValue()) {
                                    InventoryUtils.dropStack((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, outputSlot.index);
                                    continue;
                                }
                                InventoryUtils.dropStacksWhileHasItem((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, outputSlot.index, recipe.getResult());
                                continue;
                            }
                            break;
                        }
                    }
                    ClickPacketBuffer.setShouldBufferClickPackets(false);
                }
                this.massCraftTicker = 0;
                InventoryUtils.bufferInvUpdates = false;
                InventoryUtils.invUpdatesBuffer.removeIf(packet -> {
                    packet.handle((PacketListener)mc.getConnection());
                    return true;
                });
            }
        }
    }
}

