/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.mixin.network;

import fi.dy.masa.itemscroller.util.ClickPacketBuffer;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.network.protocol.Packet;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MultiPlayerGameMode.class})
public class MixinClientPlayerInteractionManager {
    @Inject(method={"handleInventoryMouseClick(IIILnet/minecraft/world/inventory/ClickType;Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelWindowClicksWhileReplayingBufferedPackets(CallbackInfo ci) {
        if (ClickPacketBuffer.shouldCancelWindowClicks()) {
            ci.cancel();
        }
    }

    @Redirect(method={"handleInventoryMouseClick(IIILnet/minecraft/world/inventory/ClickType;Lnet/minecraft/world/entity/player/Player;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientPacketListener;send(Lnet/minecraft/network/protocol/Packet;)V"))
    private void bufferClickPacketsAndCancel(ClientPacketListener netHandler, Packet<?> packet) {
        if (ClickPacketBuffer.shouldBufferClickPackets()) {
            ClickPacketBuffer.bufferPacket(packet);
            return;
        }
        netHandler.send(packet);
    }
}

