/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.mixin.screen;

import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.config.Hotkeys;
import fi.dy.masa.itemscroller.gui.ItemScrollerIcons;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.itemscroller.villager.FavoriteData;
import fi.dy.masa.itemscroller.villager.IMerchantScreenHandler;
import fi.dy.masa.itemscroller.villager.VillagerData;
import fi.dy.masa.itemscroller.villager.VillagerDataStorage;
import fi.dy.masa.itemscroller.villager.VillagerUtils;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.trading.MerchantOffer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MerchantScreen.class})
public abstract class MixinMerchantScreen
extends AbstractContainerScreen<MerchantMenu> {
    @Unique
    @Nullable
    private FavoriteData favoriteData;
    @Shadow
    private int shopItem;
    @Shadow
    int scrollOff;
    @Unique
    private int indexStartOffsetLast = -1;

    @Shadow
    protected abstract boolean canScroll(int var1);

    private MixinMerchantScreen(MerchantMenu handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    @Inject(method={"renderContents(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/MerchantScreen;renderScroller(Lnet/minecraft/client/gui/GuiGraphics;IILnet/minecraft/world/item/trading/MerchantOffers;)V")})
    private void fixRenderScrollBar(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (Configs.Toggles.VILLAGER_TRADE_FEATURES.getBooleanValue() && Configs.Generic.VILLAGER_TRADE_LIST_REMEMBER_SCROLL.getBooleanValue()) {
            VillagerData data = VillagerDataStorage.getInstance().getDataForLastInteractionTarget();
            int listSize = ((MerchantMenu)this.menu).getOffers().size();
            if (data != null && this.canScroll(listSize)) {
                this.scrollOff = this.getClampedIndex(data.getTradeListPosition());
            }
        }
    }

    @Inject(method={"mouseScrolled(DDDD)Z"}, at={@At(value="RETURN")})
    private void onMouseScrollPost(double mouseX, double mouseY, double horizontalAmount, double verticalAmount, CallbackInfoReturnable<Boolean> cir) {
        if (Configs.Toggles.VILLAGER_TRADE_FEATURES.getBooleanValue() && Configs.Generic.VILLAGER_TRADE_LIST_REMEMBER_SCROLL.getBooleanValue() && this.indexStartOffsetLast != this.scrollOff) {
            int index = this.getClampedIndex(this.scrollOff);
            VillagerDataStorage.getInstance().setTradeListPosition(index);
            this.indexStartOffsetLast = index;
        }
    }

    @Inject(method={"mouseDragged(Lnet/minecraft/client/input/MouseButtonEvent;DD)Z"}, at={@At(value="RETURN")})
    private void onMouseDragPost(MouseButtonEvent click, double offsetX, double offsetY, CallbackInfoReturnable<Boolean> cir) {
        if (Configs.Toggles.VILLAGER_TRADE_FEATURES.getBooleanValue() && Configs.Generic.VILLAGER_TRADE_LIST_REMEMBER_SCROLL.getBooleanValue() && this.indexStartOffsetLast != this.scrollOff) {
            int index = this.getClampedIndex(this.scrollOff);
            VillagerDataStorage.getInstance().setTradeListPosition(index);
            this.indexStartOffsetLast = index;
        }
    }

    @Inject(method={"mouseClicked(Lnet/minecraft/client/input/MouseButtonEvent;Z)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void onMouseClicked(MouseButtonEvent click, boolean doubled, CallbackInfoReturnable<Boolean> cir) {
        int visibleIndex;
        int realIndex;
        if (Configs.Toggles.VILLAGER_TRADE_FEATURES.getBooleanValue() && (realIndex = VillagerUtils.getRealTradeIndexFor(visibleIndex = this.getHoveredTradeButtonIndex(click.x(), click.y()), (MerchantMenu)this.menu)) >= 0) {
            if (click.input() == 1) {
                InventoryUtils.villagerTradeEverythingPossibleWithTrade(visibleIndex);
                cir.setReturnValue((Object)true);
            } else if (click.input() == 2) {
                if (Hotkeys.MODIFIER_TOGGLE_VILLAGER_GLOBAL_FAVORITE.getKeybind().isKeybindHeld()) {
                    MerchantOffer trade = (MerchantOffer)((MerchantMenu)this.menu).getOffers().get(visibleIndex);
                    VillagerDataStorage.getInstance().toggleGlobalFavorite(trade);
                } else {
                    VillagerDataStorage.getInstance().toggleFavorite(realIndex);
                }
                this.favoriteData = null;
                ((MerchantMenu)this.menu).setOffers(((IMerchantScreenHandler)this.menu).itemscroller$getOriginalList());
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"postButtonClick()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void fixRecipeIndex(CallbackInfo ci) {
        if (Configs.Toggles.VILLAGER_TRADE_FEATURES.getBooleanValue() && this.getMenu() instanceof IMerchantScreenHandler && VillagerUtils.switchToTradeByVisibleIndex(this.shopItem)) {
            ci.cancel();
        }
    }

    @Inject(method={"renderContents(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/gui/screens/inventory/MerchantScreen;tradeOfferButtons:[Lnet/minecraft/client/gui/screens/inventory/MerchantScreen$TradeOfferButton;")})
    private void renderFavoriteMarker(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (Configs.Toggles.VILLAGER_TRADE_FEATURES.getBooleanValue()) {
            int numFavorites;
            FavoriteData favoriteData = this.favoriteData;
            if (favoriteData == null) {
                this.favoriteData = favoriteData = VillagerDataStorage.getInstance().getFavoritesForCurrentVillager((MerchantMenu)this.menu);
            }
            if ((numFavorites = favoriteData.favorites.size()) > 0 && this.scrollOff < numFavorites) {
                int screenX = (this.width - this.imageWidth) / 2;
                int screenY = (this.height - this.imageHeight) / 2;
                int buttonsStartX = screenX + 5;
                int buttonsStartY = screenY + 16 + 2;
                int x = buttonsStartX + 89 - 8;
                int y = buttonsStartY + 2;
                float z = 300.0f;
                ItemScrollerIcons icon = favoriteData.isGlobal ? ItemScrollerIcons.STAR_5_PURPLE : ItemScrollerIcons.STAR_5_YELLOW;
                for (int i = 0; i < numFavorites - this.scrollOff; ++i) {
                    icon.renderAt(context, x, y, z, false, false);
                    y += 20;
                }
            }
        }
    }

    @Unique
    private int getClampedIndex(int index) {
        int listSize = ((MerchantMenu)this.menu).getOffers().size();
        return Math.max(0, Math.min(index, listSize - 7));
    }

    @Unique
    private int getHoveredTradeButtonIndex(double mouseX, double mouseY) {
        int screenX = (this.width - this.imageWidth) / 2;
        int screenY = (this.height - this.imageHeight) / 2;
        int buttonsStartX = screenX + 5;
        int buttonsStartY = screenY + 16 + 2;
        int buttonWidth = 89;
        int buttonHeight = 20;
        if (mouseX >= (double)buttonsStartX && mouseX <= (double)(buttonsStartX + buttonWidth) && mouseY >= (double)buttonsStartY && mouseY <= (double)(buttonsStartY + 7 * buttonHeight)) {
            return this.scrollOff + ((int)mouseY - buttonsStartY) / buttonHeight;
        }
        return -1;
    }
}

