/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.recipes;

import fi.dy.masa.itemscroller.ItemScroller;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class CraftingHandler {
    private static final Map<CraftingOutputSlot, SlotRange> CRAFTING_GRID_SLOTS = new HashMap<CraftingOutputSlot, SlotRange>();
    private static final Set<Class<? extends AbstractContainerScreen<?>>> CRAFTING_GUIS = new HashSet();

    public static void clearDefinitions() {
        CRAFTING_GRID_SLOTS.clear();
        CRAFTING_GUIS.clear();
    }

    public static boolean addCraftingGridDefinition(String guiClassName, String slotClassName, int outputSlot, SlotRange range) {
        try {
            Class<?> guiClass = Class.forName(guiClassName);
            Class<?> slotClass = Class.forName(slotClassName);
            CRAFTING_GRID_SLOTS.put(new CraftingOutputSlot(guiClass, slotClass, outputSlot), range);
            CRAFTING_GUIS.add(guiClass);
            return true;
        }
        catch (Exception e) {
            ItemScroller.LOGGER.warn("addCraftingGridDefinition(): Failed to find classes for grid definition: gui: '{}', slot: '{}', outputSlot: {}", (Object)guiClassName, (Object)slotClassName, (Object)outputSlot);
            return false;
        }
    }

    public static boolean isCraftingGui(Screen gui) {
        return gui instanceof AbstractContainerScreen && CRAFTING_GUIS.contains(((AbstractContainerScreen)gui).getClass());
    }

    @Nullable
    public static SlotRange getCraftingGridSlots(AbstractContainerScreen<?> gui, Slot slot) {
        return CRAFTING_GRID_SLOTS.get(CraftingOutputSlot.from(gui, slot));
    }

    @Nullable
    public static Slot getFirstCraftingOutputSlotForGui(AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        if (CRAFTING_GUIS.contains(gui.getClass())) {
            for (Slot slot : gui.getMenu().slots) {
                if (CraftingHandler.getCraftingGridSlots(gui, slot) == null) continue;
                return slot;
            }
        }
        return null;
    }

    public static class CraftingOutputSlot {
        private final Class<? extends AbstractContainerScreen<?>> guiClass;
        private final Class<? extends Slot> slotClass;
        private final int outputSlot;

        private CraftingOutputSlot(Class<? extends AbstractContainerScreen<?>> guiClass, Class<? extends Slot> slotClass, int outputSlot) {
            this.guiClass = guiClass;
            this.slotClass = slotClass;
            this.outputSlot = outputSlot;
        }

        public static CraftingOutputSlot from(AbstractContainerScreen<?> gui, Slot slot) {
            return new CraftingOutputSlot(gui.getClass(), slot.getClass(), slot.index);
        }

        public Class<? extends AbstractContainerScreen<?>> getGuiClass() {
            return this.guiClass;
        }

        public Class<? extends Slot> getSlotClass() {
            return this.slotClass;
        }

        public int getSlotNumber() {
            return this.outputSlot;
        }

        public boolean matches(AbstractContainerScreen<?> gui, Slot slot, int outputSlot) {
            return outputSlot == this.outputSlot && gui.getClass() == this.guiClass && slot.getClass() == this.slotClass;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.guiClass == null ? 0 : this.guiClass.hashCode());
            result = 31 * result + this.outputSlot;
            result = 31 * result + (this.slotClass == null ? 0 : this.slotClass.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CraftingOutputSlot other = (CraftingOutputSlot)obj;
            if (this.guiClass == null ? other.guiClass != null : this.guiClass != other.guiClass) {
                return false;
            }
            if (this.outputSlot != other.outputSlot) {
                return false;
            }
            if (this.slotClass == null) {
                return other.slotClass == null;
            }
            return this.slotClass == other.slotClass;
        }
    }

    public static class SlotRange {
        private final int first;
        private final int last;

        public SlotRange(int start, int numSlots) {
            this.first = start;
            this.last = start + numSlots - 1;
        }

        public int getFirst() {
            return this.first;
        }

        public int getLast() {
            return this.last;
        }

        public int getSlotCount() {
            return this.last - this.first + 1;
        }

        public boolean contains(int slot) {
            return slot >= this.first && slot <= this.last;
        }

        public String toString() {
            return String.format("SlotRange: {first: %d, last: %d}", this.first, this.last);
        }
    }
}

