/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.recipes;

import com.llamalad7.mixinextras.lib.apache.commons.tuple.Pair;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.mixin.recipe.IMixinClientRecipeBook;
import fi.dy.masa.itemscroller.mixin.recipe.IMixinRecipeBookWidget;
import fi.dy.masa.itemscroller.mixin.screen.IMixinRecipeBookScreen;
import fi.dy.masa.itemscroller.recipes.CraftingHandler;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.malilib.util.game.RecipeBookUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.client.gui.screens.inventory.StonecutterScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.level.Level;

public class RecipePattern {
    private ItemStack result = InventoryUtils.EMPTY_STACK;
    private ItemStack[] recipe = new ItemStack[9];
    private RecipeHolder<?> vanillaRecipe;
    private RecipeDisplayId networkRecipeId;
    private RecipeDisplayEntry displayEntry;
    private RecipeBookCategory category;
    private RecipeBookUtils.Type recipeType;
    private long recipeSaveTime;

    public RecipePattern() {
        this.ensureRecipeSizeAndClearRecipe(9);
    }

    public void ensureRecipeSize(int size) {
        if (this.getRecipeLength() != size) {
            this.recipe = new ItemStack[size];
        }
    }

    public void clearRecipe() {
        Arrays.fill(this.recipe, InventoryUtils.EMPTY_STACK);
        this.result = InventoryUtils.EMPTY_STACK;
        this.vanillaRecipe = null;
        this.networkRecipeId = null;
        this.displayEntry = null;
        this.category = null;
        this.recipeType = null;
        this.recipeSaveTime = -1L;
    }

    public void ensureRecipeSizeAndClearRecipe(int size) {
        this.ensureRecipeSize(size);
        this.clearRecipe();
    }

    @Nullable
    public <T extends RecipeInput> Recipe<T> lookupVanillaRecipe(Level world) {
        ServerLevel serverWorld;
        int recipeSize;
        this.vanillaRecipe = null;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return null;
        }
        if (this.recipe.length == 4) {
            recipeSize = 2;
        } else if (this.recipe.length == 9) {
            recipeSize = 3;
        } else {
            return null;
        }
        ServerLevel serverLevel = serverWorld = mc.getSingleplayerServer() != null ? mc.getSingleplayerServer().getLevel(mc.level.dimension()) : null;
        if (mc.hasSingleplayerServer() && serverWorld != null) {
            CraftingInput input = CraftingInput.of((int)recipeSize, (int)recipeSize, Arrays.asList(this.recipe));
            Optional opt = serverWorld.recipeAccess().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, (Level)serverWorld);
            if (opt.isPresent()) {
                RecipeHolder recipeEntry = (RecipeHolder)opt.get();
                Recipe match = ((RecipeHolder)opt.get()).value();
                ItemStack result = match.assemble((RecipeInput)input, (HolderLookup.Provider)serverWorld.registryAccess());
                if (result != null && !result.isEmpty()) {
                    this.vanillaRecipe = recipeEntry;
                    this.storeIdFromClientRecipeBook(mc);
                    return match;
                }
            }
        } else {
            this.storeIdFromClientRecipeBook(mc);
        }
        return null;
    }

    public void storeIdFromClientRecipeBook(Minecraft mc) {
        Pair<RecipeDisplayId, RecipeDisplayEntry> pair = this.matchClientRecipeBook(mc);
        if (pair == null || pair.getLeft() == null || pair.getRight() == null) {
            return;
        }
        this.storeNetworkRecipeId((RecipeDisplayId)pair.getLeft());
        this.storeRecipeCategory(((RecipeDisplayEntry)pair.getRight()).category());
        this.storeRecipeDisplayEntry((RecipeDisplayEntry)pair.getRight());
        this.storeRecipeType(RecipeBookUtils.Type.fromRecipeDisplay((RecipeDisplay)((RecipeDisplayEntry)pair.getRight()).display()));
    }

    public void storeNetworkRecipeId(RecipeDisplayId id) {
        this.networkRecipeId = id;
    }

    public void storeRecipeDisplayEntry(RecipeDisplayEntry entry) {
        this.displayEntry = entry;
    }

    public void storeRecipeCategory(RecipeBookCategory category) {
        this.category = category;
    }

    public void storeRecipeType(RecipeBookUtils.Type type) {
        this.recipeType = type;
    }

    @Nullable
    public RecipeDisplayId getNetworkRecipeId() {
        return this.networkRecipeId;
    }

    @Nullable
    public RecipeDisplayEntry getRecipeDisplayEntry() {
        return this.displayEntry;
    }

    @Nullable
    public RecipeBookCategory getRecipeCategory() {
        return this.category;
    }

    @Nullable
    public RecipeBookUtils.Type getRecipeType() {
        return this.recipeType;
    }

    public boolean matchRecipeCategory(RecipeBookCategory category) {
        return this.getRecipeCategory() != null && this.getRecipeCategory().equals(category);
    }

    public boolean matchRecipeType(RecipeDisplayEntry entry) {
        return RecipeBookUtils.Type.fromRecipeDisplay((RecipeDisplay)entry.display()) == this.recipeType;
    }

    @Nullable
    public Pair<RecipeDisplayId, RecipeDisplayEntry> matchClientRecipeBook(Minecraft mc) {
        if (mc.player == null || mc.level == null || this.isEmpty()) {
            return null;
        }
        ClientRecipeBook recipeBook = mc.player.getRecipeBook();
        ContextMap map = RecipeBookUtils.getMap((Minecraft)mc);
        Map<RecipeDisplayId, RecipeDisplayEntry> recipeMap = ((IMixinClientRecipeBook)recipeBook).itemscroller_getRecipeMap();
        if (recipeMap.size() < 1) {
            return null;
        }
        for (RecipeDisplayId id : recipeMap.keySet()) {
            RecipeDisplayEntry entry = recipeMap.get(id);
            if (entry == null || this.getRecipeCategory() != null && !this.matchRecipeCategory(entry.category())) continue;
            if (this.getRecipeType() != null && !this.matchRecipeType(entry)) {
                ItemScroller.LOGGER.warn("matchClientRecipeBook(): Type mismatch: [{} != {}]", (Object)this.getRecipeType().name(), (Object)RecipeBookUtils.Type.fromRecipeDisplay((RecipeDisplay)entry.display()).name());
                continue;
            }
            List stacks = entry.resultItems(map);
            if (stacks.isEmpty()) {
                ItemScroller.LOGGER.warn("matchClientRecipeBook(): Failed receiving crafting stacks for NetworkRecipeId: [{}] -- is it even a valid recipe?", (Object)id.index());
                continue;
            }
            if (!RecipeBookUtils.areStacksEqual((ItemStack)this.getResult(), (ItemStack)((ItemStack)stacks.getFirst()))) continue;
            Pair pair = Pair.of((Object)id, (Object)entry);
            return pair;
        }
        return null;
    }

    public void storeCraftingRecipe(Slot slot, AbstractContainerScreen<? extends AbstractContainerMenu> gui, boolean clearIfEmpty, boolean fromKeybind, Minecraft mc) {
        CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, slot);
        if (range != null) {
            if (slot.hasItem()) {
                int gridSize = range.getSlotCount();
                if (fromKeybind) {
                    int numSlots = gui.getMenu().slots.size();
                    this.ensureRecipeSizeAndClearRecipe(gridSize);
                    int i = 0;
                    for (int s = range.getFirst(); i < gridSize && s < numSlots; ++i, ++s) {
                        Slot slotTmp = gui.getMenu().getSlot(s);
                        this.recipe[i] = slotTmp.hasItem() ? slotTmp.getItem().copy() : InventoryUtils.EMPTY_STACK;
                    }
                    this.recipeSaveTime = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - this.recipeSaveTime < 4000L) {
                    this.recipeSaveTime = System.currentTimeMillis();
                    gui.getMenu().setCarried(ItemStack.EMPTY);
                    InventoryUtils.clearFirstCraftingGridOfAllItems(gui);
                    return;
                }
                this.result = slot.getItem().copy();
                this.lookupVanillaRecipe((Level)mc.level);
                this.storeSelectedRecipeIdFromGui(gui);
                InventoryUtils.clearFirstCraftingGridOfAllItems(gui);
            } else if (clearIfEmpty) {
                this.clearRecipe();
            }
        }
    }

    public void storeSelectedRecipeIdFromGui(AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        RecipeDisplayId id;
        AbstractRecipeBookScreen rbs;
        RecipeBookComponent<?> widget;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        List<RecipeBookUtils.Type> types = gui instanceof StonecutterScreen ? List.of(RecipeBookUtils.Type.STONECUTTER) : List.of(RecipeBookUtils.Type.SHAPED, RecipeBookUtils.Type.SHAPELESS);
        if (gui instanceof AbstractRecipeBookScreen && (widget = ((IMixinRecipeBookScreen)(rbs = (AbstractRecipeBookScreen)gui)).itemscroller_getRecipeBookWidget()) != null && (id = ((IMixinRecipeBookWidget)widget).itemscroller_getSelectedRecipe()) != null) {
            ClientRecipeBook recipeBook = mc.player.getRecipeBook();
            Map<RecipeDisplayId, RecipeDisplayEntry> recipeMap = ((IMixinClientRecipeBook)recipeBook).itemscroller_getRecipeMap();
            ContextMap map = RecipeBookUtils.getMap((Minecraft)mc);
            if (recipeMap.containsKey(id)) {
                RecipeDisplayEntry entry = recipeMap.get(id);
                List stacks = entry.resultItems(map);
                if (stacks.isEmpty()) {
                    ItemScroller.LOGGER.error("storeSelectedRecipeIdFromGui(): Failed reading crafting stacks for NetworkRecipeId: [{}] -- is it even a valid recipe?", (Object)entry.id().index());
                    return;
                }
                ItemStack result = (ItemStack)stacks.getFirst();
                if (RecipeBookUtils.areStacksEqual((ItemStack)this.getResult(), (ItemStack)result)) {
                    if (entry.craftingRequirements().isPresent()) {
                        if (RecipeBookUtils.compareStacksAndIngredients(Arrays.asList(this.getRecipeItems()), (List)((List)entry.craftingRequirements().get()), (RecipeBookUtils.Type)RecipeBookUtils.Type.fromRecipeDisplay((RecipeDisplay)entry.display()), types)) {
                            ItemScroller.debugLog("storeSelectedRecipeIdFromGui(): Matched Ingredients for result stack [{}] networkId [{}]", this.getResult().toString(), id.index());
                            this.storeNetworkRecipeId(id);
                            this.storeRecipeCategory(entry.category());
                            this.storeRecipeDisplayEntry(entry);
                            this.storeRecipeType(RecipeBookUtils.Type.fromRecipeDisplay((RecipeDisplay)entry.display()));
                        } else {
                            ItemScroller.LOGGER.warn("storeSelectedRecipeIdFromGui(): failed to match Ingredients for result stack [{}] networkId [{}]", (Object)this.getResult().toString(), (Object)id.index());
                        }
                    } else {
                        ItemScroller.debugLog("storeSelectedRecipeIdFromGui(): No craftingRequirements present, Saving Blindly for result stack [{}] networkId [{}]", this.getResult().toString(), id.index());
                        this.storeNetworkRecipeId(id);
                        this.storeRecipeCategory(entry.category());
                        this.storeRecipeDisplayEntry(entry);
                        this.storeRecipeType(RecipeBookUtils.Type.fromRecipeDisplay((RecipeDisplay)entry.display()));
                    }
                } else {
                    Pair<RecipeDisplayId, RecipeDisplayEntry> pair = this.matchClientRecipeBook(mc);
                    if (pair != null) {
                        ItemScroller.debugLog("storeSelectedRecipeIdFromGui(): matching pair for result stack [{}] networkId [{}]", this.getResult().toString(), ((RecipeDisplayId)pair.getLeft()).index());
                        this.storeNetworkRecipeId((RecipeDisplayId)pair.getLeft());
                        this.storeRecipeCategory(((RecipeDisplayEntry)pair.getRight()).category());
                        this.storeRecipeDisplayEntry((RecipeDisplayEntry)pair.getRight());
                        this.storeRecipeType(RecipeBookUtils.Type.fromRecipeDisplay((RecipeDisplay)entry.display()));
                    } else {
                        this.result = result.copy();
                        pair = this.matchClientRecipeBook(mc);
                        if (pair != null) {
                            ItemScroller.debugLog("storeSelectedRecipeIdFromGui(): RE-matching pair results stack [{}] networkId [{}]", this.getResult().toString(), ((RecipeDisplayId)pair.getLeft()).index());
                            this.storeNetworkRecipeId((RecipeDisplayId)pair.getLeft());
                            this.storeRecipeCategory(((RecipeDisplayEntry)pair.getRight()).category());
                            this.storeRecipeDisplayEntry((RecipeDisplayEntry)pair.getRight());
                            this.storeRecipeType(RecipeBookUtils.Type.fromRecipeDisplay((RecipeDisplay)entry.display()));
                        } else {
                            ItemScroller.LOGGER.error("storeSelectedRecipeIdFromGui(): Final Exception matching results stack [{}] versus [{}] --> Clearing Recipe", (Object)this.getResult().toString(), (Object)result.toString());
                            this.clearRecipe();
                        }
                    }
                }
            }
        }
    }

    public void copyRecipeFrom(RecipePattern other) {
        int size = other.getRecipeLength();
        ItemStack[] otherRecipe = other.getRecipeItems();
        this.ensureRecipeSizeAndClearRecipe(size);
        for (int i = 0; i < size; ++i) {
            this.recipe[i] = !InventoryUtils.isStackEmpty(otherRecipe[i]) ? otherRecipe[i].copy() : InventoryUtils.EMPTY_STACK;
        }
        this.result = !InventoryUtils.isStackEmpty(other.getResult()) ? other.getResult().copy() : InventoryUtils.EMPTY_STACK;
        this.vanillaRecipe = other.vanillaRecipe;
        this.networkRecipeId = other.networkRecipeId;
        this.displayEntry = other.displayEntry;
        this.category = other.category;
        this.recipeType = other.recipeType;
        this.recipeSaveTime = System.currentTimeMillis();
    }

    public void readFromNBT(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registryManager) {
        if (nbt.contains("Result") && nbt.contains("Ingredients")) {
            ListTag tagIngredients = nbt.getListOrEmpty("Ingredients");
            int count = tagIngredients.size();
            int length = nbt.getIntOr("Length", -1);
            if (length > 0) {
                this.ensureRecipeSizeAndClearRecipe(length);
            }
            for (int i = 0; i < count; ++i) {
                CompoundTag tag = tagIngredients.getCompoundOrEmpty(i);
                int slot = tag.getIntOr("Slot", -1);
                if (slot < 0 || slot >= this.recipe.length) continue;
                this.recipe[slot] = fi.dy.masa.malilib.util.InventoryUtils.fromNbtOrEmpty((RegistryAccess)registryManager, (Tag)tag);
            }
            this.result = fi.dy.masa.malilib.util.InventoryUtils.fromNbtOrEmpty((RegistryAccess)registryManager, (Tag)nbt.getCompoundOrEmpty("Result"));
        }
    }

    @Nonnull
    public CompoundTag writeToNBT(@Nonnull RegistryAccess registryManager) {
        CompoundTag nbt = new CompoundTag();
        if (this.isValid()) {
            CompoundTag tag = (CompoundTag)ItemStack.CODEC.encodeStart((DynamicOps)registryManager.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.result).getPartialOrThrow();
            nbt.putInt("Length", this.recipe.length);
            nbt.put("Result", (Tag)tag);
            ListTag tagIngredients = new ListTag();
            for (int i = 0; i < this.recipe.length; ++i) {
                if (this.recipe[i].isEmpty() || InventoryUtils.isStackEmpty(this.recipe[i])) continue;
                tag = (CompoundTag)ItemStack.CODEC.encodeStart((DynamicOps)registryManager.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.recipe[i]).getPartialOrThrow();
                tag.putInt("Slot", i);
                tagIngredients.add((Object)tag);
            }
            nbt.put("Ingredients", (Tag)tagIngredients);
        }
        return nbt;
    }

    public ItemStack getResult() {
        if (!this.result.isEmpty()) {
            return this.result;
        }
        return InventoryUtils.EMPTY_STACK;
    }

    public int getRecipeLength() {
        return this.recipe.length;
    }

    public ItemStack[] getRecipeItems() {
        return this.recipe;
    }

    public boolean isEmpty() {
        boolean empty = true;
        for (int i = 0; i < this.getRecipeLength(); ++i) {
            if (this.getRecipeItems()[i].isEmpty()) continue;
            empty = false;
        }
        return empty || this.getResult().isEmpty();
    }

    public int countRecipeItems() {
        int count = 0;
        for (ItemStack itemStack : this.recipe) {
            if (itemStack.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public boolean isValid() {
        return !InventoryUtils.isStackEmpty(this.getResult());
    }

    @Nullable
    public RecipeHolder<?> getVanillaRecipeEntry() {
        return this.vanillaRecipe;
    }

    @Nullable
    public <T extends RecipeInput> Recipe<T> getVanillaRecipe() {
        if (this.recipe == null) {
            return null;
        }
        if (this.vanillaRecipe != null) {
            return this.vanillaRecipe.value();
        }
        return null;
    }
}

