/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.recipes;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.recipes.RecipePattern;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.game.RecipeBookUtils;
import fi.dy.masa.malilib.util.nbt.NbtUtils;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;

public class RecipeStorage {
    private static final int MAX_PAGES = 8;
    private static final int MAX_RECIPES = 18;
    private static final RecipeStorage INSTANCE = new RecipeStorage(144);
    private final RecipePattern[] recipes;
    private int selected;
    private boolean dirty;

    public static RecipeStorage getInstance() {
        return INSTANCE;
    }

    public RecipeStorage(int recipeCount) {
        this.recipes = new RecipePattern[recipeCount];
        this.initRecipes();
    }

    public void reset(boolean isLogout) {
        if (isLogout) {
            this.clearRecipes();
        }
    }

    private void initRecipes() {
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i] = new RecipePattern();
        }
    }

    private void clearRecipes() {
        for (int i = 0; i < this.recipes.length; ++i) {
            this.clearRecipe(i);
        }
    }

    public int getSelection() {
        return this.selected;
    }

    public void changeSelectedRecipe(int index) {
        if (index >= 0 && index < this.recipes.length) {
            this.selected = index;
            this.dirty = true;
        }
    }

    public void scrollSelection(boolean forward) {
        this.changeSelectedRecipe(this.selected + (forward ? 1 : -1));
    }

    public int getFirstVisibleRecipeId() {
        return this.getCurrentRecipePage() * this.getRecipeCountPerPage();
    }

    public int getTotalRecipeCount() {
        return this.recipes.length;
    }

    public int getRecipeCountPerPage() {
        return 18;
    }

    public int getCurrentRecipePage() {
        return this.getSelection() / this.getRecipeCountPerPage();
    }

    @Nonnull
    public RecipePattern getRecipe(int index) {
        if (index >= 0 && index < this.recipes.length) {
            return this.recipes[index];
        }
        return this.recipes[0];
    }

    @Nonnull
    public RecipePattern getSelectedRecipe() {
        return this.getRecipe(this.getSelection());
    }

    public void storeCraftingRecipeToCurrentSelection(Slot slot, AbstractContainerScreen<?> gui, boolean clearIfEmpty, boolean fromKeybind, Minecraft mc) {
        this.storeCraftingRecipe(this.getSelection(), slot, gui, clearIfEmpty, fromKeybind, mc);
    }

    public void storeCraftingRecipe(int index, Slot slot, AbstractContainerScreen<?> gui, boolean clearIfEmpty, boolean fromKeybind, Minecraft mc) {
        this.getRecipe(index).storeCraftingRecipe(slot, gui, clearIfEmpty, fromKeybind, mc);
        this.dirty = true;
    }

    public void clearRecipe(int index) {
        this.getRecipe(index).clearRecipe();
        this.dirty = true;
    }

    public void onAddToRecipeBook(RecipeDisplayEntry entry) {
        Minecraft mc = Minecraft.getInstance();
        for (RecipePattern recipe : this.recipes) {
            if (recipe.isEmpty()) continue;
            List<RecipeBookUtils.Type> types = recipe.getRecipeType() != null ? List.of(recipe.getRecipeType()) : List.of(RecipeBookUtils.Type.SHAPED, RecipeBookUtils.Type.SHAPELESS);
            if (!RecipeBookUtils.matchClientRecipeBookEntry((ItemStack)recipe.getResult(), Arrays.asList(recipe.getRecipeItems()), (RecipeDisplayEntry)entry, types, (Minecraft)mc)) continue;
            ItemScroller.debugLog("onAddToRecipeBook(): Positive Match for result stack: [{}] networkId [{}]", recipe.getResult().toString(), entry.id().index());
            recipe.storeNetworkRecipeId(entry.id());
            recipe.storeRecipeCategory(entry.category());
            recipe.storeRecipeDisplayEntry(entry);
            recipe.storeRecipeType(RecipeBookUtils.Type.fromRecipeDisplay((RecipeDisplay)entry.display()));
            break;
        }
    }

    private void readFromNBT(CompoundTag nbt, @Nonnull RegistryAccess registryManager) {
        if (nbt == null || !nbt.contains("Recipes")) {
            return;
        }
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i].clearRecipe();
        }
        ListTag tagList = nbt.getListOrEmpty("Recipes");
        int count = tagList.size();
        for (int i = 0; i < count; ++i) {
            String recipeType;
            CompoundTag tag = tagList.getCompoundOrEmpty(i);
            byte index = tag.getByteOr("RecipeIndex", (byte)-1);
            if (index < 0 || index >= this.recipes.length) continue;
            this.recipes[index].readFromNBT(tag, registryManager);
            if (tag.contains("RecipeCategory")) {
                this.recipes[index].storeRecipeCategory(RecipeBookUtils.getRecipeCategoryFromId((String)tag.getStringOr("RecipeCategory", "")));
            }
            if (tag.contains("LastNetworkId")) {
                this.recipes[index].storeNetworkRecipeId(new RecipeDisplayId(tag.getIntOr("LastNetworkId", -1)));
            }
            if (!tag.contains("RecipeType") || (recipeType = tag.getStringOr("RecipeType", "")).isEmpty()) continue;
            for (RecipeBookUtils.Type type : RecipeBookUtils.Type.values()) {
                if (!type.name().equalsIgnoreCase(recipeType)) continue;
                this.recipes[index].storeRecipeType(type);
            }
        }
        this.changeSelectedRecipe(nbt.getByteOr("Selected", (byte)-1));
    }

    private CompoundTag writeToNBT(@Nonnull RegistryAccess registry) {
        ListTag tagRecipes = new ListTag();
        CompoundTag nbt = new CompoundTag();
        for (int i = 0; i < this.recipes.length; ++i) {
            String id;
            if (!this.recipes[i].isValid()) continue;
            RecipePattern entry = this.recipes[i];
            CompoundTag tag = entry.writeToNBT(registry);
            tag.putByte("RecipeIndex", (byte)i);
            if (entry.getRecipeCategory() != null && !(id = RecipeBookUtils.getRecipeCategoryId((RecipeBookCategory)entry.getRecipeCategory())).isEmpty()) {
                tag.putString("RecipeCategory", id);
            }
            if (entry.getNetworkRecipeId() != null) {
                tag.putInt("LastNetworkId", entry.getNetworkRecipeId().index());
            }
            if (entry.getRecipeType() != null) {
                tag.putString("RecipeType", entry.getRecipeType().name().toLowerCase());
            }
            tagRecipes.add((Object)tag);
        }
        nbt.put("Recipes", (Tag)tagRecipes);
        nbt.putByte("Selected", (byte)this.selected);
        return nbt;
    }

    private String getFileName() {
        if (!Configs.Generic.SCROLL_CRAFT_RECIPE_FILE_GLOBAL.getBooleanValue()) {
            String worldName = StringUtils.getWorldOrServerName();
            if (worldName != null) {
                return "recipes_" + worldName + ".nbt";
            }
            return "recipes_unknown.nbt";
        }
        return "recipes.nbt";
    }

    private Path getSaveDirAsPath() {
        return FileUtils.getMinecraftDirectoryAsPath().resolve("itemscroller");
    }

    public void readFromDisk(@Nonnull RegistryAccess registry) {
        try {
            Path saveDir = this.getSaveDirAsPath();
            if (Files.isDirectory(saveDir, new LinkOption[0])) {
                Path file = saveDir.resolve(this.getFileName());
                if (Files.exists(file, new LinkOption[0])) {
                    CompoundTag nbtIn = NbtUtils.readNbtFromFileAsPath((Path)file, (NbtAccounter)NbtAccounter.unlimitedHeap());
                    if (nbtIn != null && !nbtIn.isEmpty()) {
                        this.initRecipes();
                        this.readFromNBT(nbtIn, registry);
                    } else {
                        ItemScroller.LOGGER.warn("readFromDisk(): Error reading recipes from file '{}'", (Object)file.toAbsolutePath());
                    }
                }
            } else {
                ItemScroller.LOGGER.warn("readFromDisk(): Error reading recipes saveDir '{}'", (Object)saveDir.toAbsolutePath());
            }
        }
        catch (Exception e) {
            ItemScroller.LOGGER.warn("readFromDisk(): Failed to read recipes from file", (Throwable)e);
        }
    }

    public void writeToDisk(@Nonnull RegistryAccess registry) {
        if (this.dirty) {
            try {
                Path saveDir = this.getSaveDirAsPath();
                if (!Files.exists(saveDir, new LinkOption[0])) {
                    FileUtils.createDirectoriesIfMissing((Path)saveDir);
                }
                if (Files.isDirectory(saveDir, new LinkOption[0])) {
                    Path fileTmp = saveDir.resolve(this.getFileName() + ".tmp");
                    Path fileReal = saveDir.resolve(this.getFileName());
                    NbtUtils.writeCompressed((CompoundTag)this.writeToNBT(registry), (Path)fileTmp);
                    if (Files.exists(fileReal, new LinkOption[0])) {
                        Files.delete(fileReal);
                    }
                    Files.move(fileTmp, fileReal, new CopyOption[0]);
                    this.dirty = false;
                }
            }
            catch (Exception e) {
                ItemScroller.LOGGER.warn("writeToDisk(): Failed to write recipes to file!", (Throwable)e);
            }
        }
    }
}

