/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.util;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.config.Hotkeys;
import fi.dy.masa.itemscroller.mixin.recipe.IMixinCraftingResultSlot;
import fi.dy.masa.itemscroller.recipes.CraftingHandler;
import fi.dy.masa.itemscroller.recipes.RecipePattern;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.AccessorUtils;
import fi.dy.masa.itemscroller.util.InputUtils;
import fi.dy.masa.itemscroller.util.ItemType;
import fi.dy.masa.itemscroller.util.MoveAction;
import fi.dy.masa.itemscroller.util.MoveAmount;
import fi.dy.masa.itemscroller.util.SortingCategory;
import fi.dy.masa.itemscroller.util.SortingMethod;
import fi.dy.masa.itemscroller.villager.VillagerDataStorage;
import fi.dy.masa.itemscroller.villager.VillagerUtils;
import fi.dy.masa.malilib.config.IConfigLockedListEntry;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.game.wrap.GameWrap;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIntMutablePair;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.MerchantResultSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.apache.commons.lang3.math.Fraction;

public class InventoryUtils {
    private static final Set<Integer> DRAGGED_SLOTS = new HashSet<Integer>();
    private static final int SERVER_SYNC_MAGIC = 45510;
    public static int dontUpdateRecipeBook;
    private static WeakReference<Slot> sourceSlotCandidate;
    private static WeakReference<Slot> sourceSlot;
    private static ItemStack stackInCursorLast;
    @Nullable
    protected static CraftingRecipe lastRecipe;
    private static MoveAction activeMoveAction;
    private static int lastPosX;
    private static int lastPosY;
    private static int slotNumberLast;
    private static boolean inhibitCraftResultUpdate;
    private static Runnable selectedSlotUpdateTask;
    public static boolean assumeEmptyShulkerStacking;
    private static List<String> topSortingPriorityList;
    private static List<String> bottomSortingPriorityList;
    public static boolean bufferInvUpdates;
    public static List<Packet<ClientGamePacketListener>> invUpdatesBuffer;
    private static CreativeModeTab.ItemDisplayParameters displayContext;
    public static boolean ignoreScrollingInsideOfBundles;
    public static final ItemStack EMPTY_STACK;

    public static void setInhibitCraftingOutputUpdate(boolean inhibitUpdate) {
        inhibitCraftResultUpdate = inhibitUpdate;
    }

    public static void setIgnoreScrollingInsideOfBundles(boolean toggle) {
        ignoreScrollingInsideOfBundles = toggle;
    }

    public static void onSlotChangedCraftingGrid(Player player, CraftingContainer craftMatrix, ResultContainer inventoryCraftResult) {
        if (Configs.Generic.CLIENT_CRAFTING_FIX.getBooleanValue()) {
            InventoryUtils.updateCraftingOutputSlot(player, craftMatrix, inventoryCraftResult, true);
        }
    }

    public static void updateCraftingOutputSlot(Slot outputSlot) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && outputSlot instanceof ResultSlot) {
            ResultSlot resultSlot = (ResultSlot)outputSlot;
            Container container = resultSlot.container;
            if (container instanceof ResultContainer) {
                ResultContainer resultInv = (ResultContainer)container;
                CraftingContainer craftingInv = ((IMixinCraftingResultSlot)outputSlot).itemscroller_getCraftingInventory();
                InventoryUtils.updateCraftingOutputSlot((Player)player, craftingInv, resultInv, true);
            }
        }
    }

    public static void updateCraftingOutputSlot(Player player, CraftingContainer craftMatrix, ResultContainer inventoryCraftResult, boolean setEmptyStack) {
        Minecraft mc = Minecraft.getInstance();
        ServerLevel serverWorld = mc.getSingleplayerServer() != null ? mc.getSingleplayerServer().getLevel(mc.level.dimension()) : null;
        Level world = player.level();
        if (world instanceof ClientLevel && player instanceof LocalPlayer) {
            ItemStack stack = ItemStack.EMPTY;
            CraftingRecipe recipe = Configs.Generic.USE_RECIPE_CACHING.getBooleanValue() ? lastRecipe : null;
            RecipeHolder recipeEntry = null;
            CraftingInput recipeInput = craftMatrix.asCraftInput();
            if (!(recipe != null && recipe.matches((RecipeInput)recipeInput, world) || serverWorld == null)) {
                Optional opt = serverWorld.recipeAccess().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)recipeInput, (Level)serverWorld);
                recipe = opt.map(RecipeHolder::value).orElse(null);
                recipeEntry = opt.orElse(null);
            }
            if (recipe != null) {
                GameRules rules = new GameRules(((LocalPlayer)player).connection.enabledFeatures());
                if (recipe.isSpecial() || !rules.getBoolean(GameRules.RULE_LIMITED_CRAFTING)) {
                    inventoryCraftResult.setRecipeUsed(recipeEntry);
                    stack = recipe.assemble((RecipeInput)recipeInput, (HolderLookup.Provider)world.registryAccess());
                }
                if (setEmptyStack || !stack.isEmpty()) {
                    inventoryCraftResult.setItem(0, stack);
                }
            }
            lastRecipe = recipe;
        }
    }

    public static String getStackString(ItemStack stack) {
        if (!InventoryUtils.isStackEmpty(stack)) {
            ResourceLocation rl = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            String idStr = rl != null ? rl.toString() : "null";
            String displayName = stack.getHoverName().getString();
            String nbtStr = stack.getComponents() != null ? stack.getComponents().toString() : "<no NBT>";
            return String.format("[%s - display: %s - NBT: %s] (%s)", idStr, displayName, nbtStr, stack);
        }
        return "<empty>";
    }

    public static void debugPrintSlotInfo(AbstractContainerScreen<? extends AbstractContainerMenu> gui, Slot slot) {
        if (slot == null) {
            ItemScroller.LOGGER.info("slot was null");
            return;
        }
        boolean hasSlot = gui.getMenu().slots.contains((Object)slot);
        Container inv = slot.container;
        String stackStr = InventoryUtils.getStackString(slot.getItem());
        ItemScroller.LOGGER.info(String.format("slot: slotNumber: %d, getSlotIndex(): %d, getHasStack(): %s, slot class: %s, inv class: %s, Container's slot list has slot: %s, stack: %s, numSlots: %d", slot.index, AccessorUtils.getSlotIndex(slot), slot.hasItem(), slot.getClass().getName(), inv != null ? inv.getClass().getName() : "<null>", hasSlot ? " true" : "false", stackStr, gui.getMenu().slots.size()));
    }

    private static boolean isValidSlot(Slot slot, AbstractContainerScreen<? extends AbstractContainerMenu> gui, boolean requireItems) {
        AbstractContainerMenu container = gui.getMenu();
        return container != null && container.slots != null && slot != null && container.slots.contains((Object)slot) && (!requireItems || slot.hasItem()) && !Configs.SLOT_BLACKLIST.contains(slot.getClass().getName());
    }

    public static boolean isCraftingSlot(AbstractContainerScreen<? extends AbstractContainerMenu> gui, @Nullable Slot slot) {
        return slot != null && CraftingHandler.getCraftingGridSlots(gui, slot) != null;
    }

    private static boolean inventoryExistsAbove(Slot slot, AbstractContainerMenu container) {
        for (Slot slotTmp : container.slots) {
            if (slotTmp.y >= slot.y || InventoryUtils.areSlotsInSameInventory(slot, slotTmp)) continue;
            return true;
        }
        return false;
    }

    public static boolean canShiftPlaceItems(AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        Slot slot = AccessorUtils.getSlotUnderMouse(gui);
        ItemStack stackCursor = gui.getMenu().getCarried();
        return slot != null && !InventoryUtils.isStackEmpty(stackCursor) && InventoryUtils.isValidSlot(slot, gui, false) && !slot.hasItem() && slot.mayPlace(stackCursor);
    }

    public static boolean tryMoveItems(AbstractContainerScreen<? extends AbstractContainerMenu> gui, RecipeStorage recipes, boolean scrollingUp) {
        Slot slot = AccessorUtils.getSlotUnderMouse(gui);
        if (slot == null || !InventoryUtils.isStackEmpty(gui.getMenu().getCarried()) || ignoreScrollingInsideOfBundles) {
            return false;
        }
        boolean villagerHandling = Configs.Toggles.SCROLL_VILLAGER.getBooleanValue() && gui instanceof MerchantScreen && slot instanceof MerchantResultSlot;
        boolean craftingHandling = Configs.Toggles.CRAFTING_FEATURES.getBooleanValue() && InventoryUtils.isCraftingSlot(gui, slot);
        boolean keyActiveMoveEverything = Hotkeys.MODIFIER_MOVE_EVERYTHING.getKeybind().isKeybindHeld();
        boolean keyActiveMoveMatching = Hotkeys.MODIFIER_MOVE_MATCHING.getKeybind().isKeybindHeld();
        boolean keyActiveMoveStacks = Hotkeys.MODIFIER_MOVE_STACK.getKeybind().isKeybindHeld();
        boolean nonSingleMove = keyActiveMoveEverything || keyActiveMoveMatching || keyActiveMoveStacks;
        boolean moveToOtherInventory = scrollingUp;
        if (Configs.Generic.SLOT_POSITION_AWARE_SCROLL_DIRECTION.getBooleanValue()) {
            boolean above = InventoryUtils.inventoryExistsAbove(slot, gui.getMenu());
            boolean bl = moveToOtherInventory = above == scrollingUp;
        }
        if (Configs.Generic.REVERSE_SCROLL_DIRECTION_SINGLE.getBooleanValue() && !nonSingleMove || Configs.Generic.REVERSE_SCROLL_DIRECTION_STACKS.getBooleanValue() && nonSingleMove) {
            moveToOtherInventory = !moveToOtherInventory;
        }
        if (!InventoryUtils.isValidSlot(slot, gui, !villagerHandling && !craftingHandling)) {
            return false;
        }
        if (craftingHandling) {
            return InventoryUtils.tryMoveItemsCrafting(recipes, slot, gui, moveToOtherInventory, keyActiveMoveStacks, keyActiveMoveEverything);
        }
        if (villagerHandling) {
            return InventoryUtils.tryMoveItemsVillager((MerchantScreen)gui, slot, moveToOtherInventory, keyActiveMoveStacks);
        }
        if (!Configs.Toggles.SCROLL_SINGLE.getBooleanValue() && !nonSingleMove || !Configs.Toggles.SCROLL_STACKS.getBooleanValue() && keyActiveMoveStacks || !Configs.Toggles.SCROLL_MATCHING.getBooleanValue() && keyActiveMoveMatching || !Configs.Toggles.SCROLL_EVERYTHING.getBooleanValue() && keyActiveMoveEverything) {
            return false;
        }
        if (keyActiveMoveEverything) {
            InventoryUtils.tryMoveStacks(slot, gui, false, moveToOtherInventory, false);
        } else {
            if (keyActiveMoveMatching) {
                InventoryUtils.tryMoveStacks(slot, gui, true, moveToOtherInventory, false);
                return true;
            }
            if (keyActiveMoveStacks) {
                InventoryUtils.tryMoveStacks(slot, gui, true, moveToOtherInventory, true);
            } else {
                ItemStack stack = slot.getItem();
                if (moveToOtherInventory) {
                    InventoryUtils.tryMoveSingleItemToOtherInventory(slot, gui);
                } else if (InventoryUtils.getStackSize(stack) < slot.getMaxStackSize(stack)) {
                    InventoryUtils.tryMoveSingleItemToThisInventory(slot, gui);
                }
            }
        }
        return false;
    }

    public static boolean dragMoveItems(AbstractContainerScreen<? extends AbstractContainerMenu> gui, MoveAction action, int mouseX, int mouseY, boolean isClick) {
        boolean isPlayerInv;
        int slotNumber;
        if (!InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
            lastPosX = mouseX;
            lastPosY = mouseY;
            InventoryUtils.stopDragging();
            return false;
        }
        boolean cancel = false;
        if (isClick && action != MoveAction.NONE) {
            slotNumberLast = -1;
            lastPosX = mouseX;
            lastPosY = mouseY;
            activeMoveAction = action;
            cancel = InventoryUtils.dragMoveFromSlotAtPosition(gui, mouseX, mouseY, action);
        } else {
            action = activeMoveAction;
        }
        if (activeMoveAction != MoveAction.NONE && !cancel) {
            int absY;
            int distX = mouseX - lastPosX;
            int distY = mouseY - lastPosY;
            int absX = Math.abs(distX);
            if (absX > (absY = Math.abs(distY))) {
                int inc = distX > 0 ? 1 : -1;
                int x = lastPosX;
                while (true) {
                    int y = absX != 0 ? lastPosY + (x - lastPosX) * distY / absX : mouseY;
                    InventoryUtils.dragMoveFromSlotAtPosition(gui, x, y, action);
                    if (x != mouseX) {
                        x += inc;
                        continue;
                    }
                    break;
                }
            } else {
                int inc = distY > 0 ? 1 : -1;
                int y = lastPosY;
                while (true) {
                    int x = absY != 0 ? lastPosX + (y - lastPosY) * distX / absY : mouseX;
                    InventoryUtils.dragMoveFromSlotAtPosition(gui, x, y, action);
                    if (y == mouseY) break;
                    y += inc;
                }
            }
        }
        lastPosX = mouseX;
        lastPosY = mouseY;
        Slot slot = AccessorUtils.getSlotAtPosition(gui, mouseX, mouseY);
        slotNumberLast = slot != null ? (gui instanceof CreativeModeInventoryScreen ? (slotNumber = (isPlayerInv = ((CreativeModeInventoryScreen)gui).isInventoryOpen()) ? AccessorUtils.getSlotIndex(slot) : slot.index) : slot.index) : -1;
        return cancel;
    }

    public static void stopDragging() {
        activeMoveAction = MoveAction.NONE;
        DRAGGED_SLOTS.clear();
    }

    private static boolean dragMoveFromSlotAtPosition(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int x, int y, MoveAction action) {
        boolean flag;
        if (gui instanceof CreativeModeInventoryScreen) {
            return InventoryUtils.dragMoveFromSlotAtPositionCreative(gui, x, y, action);
        }
        Slot slot = AccessorUtils.getSlotAtPosition(gui, x, y);
        Minecraft mc = Minecraft.getInstance();
        MoveAmount amount = InputUtils.getMoveAmount(action);
        boolean bl = flag = slot != null && InventoryUtils.isValidSlot(slot, gui, true) && slot.mayPickup((Player)mc.player);
        if (flag && slot.index != slotNumberLast && (amount != MoveAmount.MOVE_ONE || !DRAGGED_SLOTS.contains(slot.index))) {
            switch (action) {
                case MOVE_TO_OTHER_MOVE_ONE: {
                    InventoryUtils.tryMoveSingleItemToOtherInventory(slot, gui);
                    break;
                }
                case MOVE_TO_OTHER_LEAVE_ONE: {
                    InventoryUtils.tryMoveAllButOneItemToOtherInventory(slot, gui);
                    break;
                }
                case MOVE_TO_OTHER_STACKS: {
                    InventoryUtils.shiftClickSlot(gui, slot.index);
                    break;
                }
                case MOVE_TO_OTHER_MATCHING: {
                    InventoryUtils.tryMoveStacks(slot, gui, true, true, false);
                    break;
                }
                case DROP_ONE: {
                    InventoryUtils.clickSlot(gui, slot.index, 0, ClickType.THROW);
                    break;
                }
                case DROP_LEAVE_ONE: {
                    InventoryUtils.leftClickSlot(gui, slot.index);
                    InventoryUtils.rightClickSlot(gui, slot.index);
                    InventoryUtils.dropItemsFromCursor(gui);
                    break;
                }
                case DROP_STACKS: {
                    InventoryUtils.clickSlot(gui, slot.index, 1, ClickType.THROW);
                    break;
                }
                case MOVE_DOWN_MOVE_ONE: 
                case MOVE_DOWN_LEAVE_ONE: 
                case MOVE_DOWN_STACKS: 
                case MOVE_DOWN_MATCHING: {
                    InventoryUtils.tryMoveItemsVertically(gui, slot, false, amount);
                    break;
                }
                case MOVE_UP_MOVE_ONE: 
                case MOVE_UP_LEAVE_ONE: 
                case MOVE_UP_STACKS: 
                case MOVE_UP_MATCHING: {
                    InventoryUtils.tryMoveItemsVertically(gui, slot, true, amount);
                    break;
                }
            }
            DRAGGED_SLOTS.add(slot.index);
        }
        return true;
    }

    private static boolean dragMoveFromSlotAtPositionCreative(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int x, int y, MoveAction action) {
        int slotNumber;
        CreativeModeInventoryScreen guiCreative = (CreativeModeInventoryScreen)gui;
        Slot slot = AccessorUtils.getSlotAtPosition(gui, x, y);
        boolean isPlayerInv = guiCreative.isInventoryOpen();
        if (slot == null || slot.getClass() != Slot.class && !isPlayerInv) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        MoveAmount amount = InputUtils.getMoveAmount(action);
        boolean flag = slot != null && InventoryUtils.isValidSlot(slot, gui, true) && slot.mayPickup((Player)mc.player);
        boolean cancel = flag && (amount == MoveAmount.LEAVE_ONE || amount == MoveAmount.MOVE_ONE);
        int n = slotNumber = isPlayerInv ? AccessorUtils.getSlotIndex(slot) : slot.index;
        if (flag && slotNumber != slotNumberLast && !DRAGGED_SLOTS.contains(slotNumber)) {
            switch (action) {
                case MOVE_TO_OTHER_MOVE_ONE: 
                case SCROLL_TO_OTHER_MOVE_ONE: {
                    InventoryUtils.leftClickSlot((AbstractContainerScreen<? extends AbstractContainerMenu>)guiCreative, slot, slotNumber);
                    InventoryUtils.rightClickSlot((AbstractContainerScreen<? extends AbstractContainerMenu>)guiCreative, slot, slotNumber);
                    InventoryUtils.shiftClickSlot((AbstractContainerScreen<? extends AbstractContainerMenu>)guiCreative, slot, slotNumber);
                    InventoryUtils.leftClickSlot((AbstractContainerScreen<? extends AbstractContainerMenu>)guiCreative, slot, slotNumber);
                    cancel = true;
                    break;
                }
                case MOVE_TO_OTHER_LEAVE_ONE: {
                    if (!isPlayerInv) {
                        InventoryUtils.leftClickSlot((AbstractContainerScreen<? extends AbstractContainerMenu>)guiCreative, slot, slotNumber);
                        InventoryUtils.rightClickSlot((AbstractContainerScreen<? extends AbstractContainerMenu>)guiCreative, slot, slotNumber);
                        Slot slotFirst = (Slot)gui.getMenu().slots.get(0);
                        InventoryUtils.leftClickSlot((AbstractContainerScreen<? extends AbstractContainerMenu>)guiCreative, slotFirst, slotFirst.index);
                    }
                    cancel = true;
                    break;
                }
                case MOVE_TO_OTHER_STACKS: 
                case SCROLL_TO_OTHER_STACKS: {
                    InventoryUtils.shiftClickSlot(gui, slot, slotNumber);
                    cancel = true;
                    break;
                }
                case DROP_ONE: {
                    InventoryUtils.clickSlot(gui, slot.index, 0, ClickType.THROW);
                    break;
                }
                case DROP_LEAVE_ONE: {
                    InventoryUtils.leftClickSlot(gui, slot.index);
                    InventoryUtils.rightClickSlot(gui, slot.index);
                    InventoryUtils.dropItemsFromCursor(gui);
                    break;
                }
                case DROP_STACKS: {
                    InventoryUtils.clickSlot(gui, slot.index, 1, ClickType.THROW);
                    cancel = true;
                    break;
                }
                case MOVE_DOWN_MOVE_ONE: 
                case MOVE_DOWN_LEAVE_ONE: 
                case MOVE_DOWN_STACKS: {
                    InventoryUtils.tryMoveItemsVertically(gui, slot, false, amount);
                    cancel = true;
                    break;
                }
                case MOVE_UP_MOVE_ONE: 
                case MOVE_UP_LEAVE_ONE: 
                case MOVE_UP_STACKS: {
                    InventoryUtils.tryMoveItemsVertically(gui, slot, true, amount);
                    cancel = true;
                    break;
                }
            }
            DRAGGED_SLOTS.add(slotNumber);
        }
        return cancel;
    }

    public static void dropStacks(AbstractContainerScreen<? extends AbstractContainerMenu> gui, ItemStack stackReference, Slot slotReference, boolean sameInventory) {
        if (slotReference != null && !InventoryUtils.isStackEmpty(stackReference)) {
            AbstractContainerMenu container = gui.getMenu();
            stackReference = stackReference.copy();
            for (Slot slot : container.slots) {
                if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) != sameInventory || !InventoryUtils.areStacksEqual(slot.getItem(), stackReference)) continue;
                InventoryUtils.dropStack(gui, slot.index);
            }
        }
    }

    public static void dropAllMatchingStacks(AbstractContainerScreen<? extends AbstractContainerMenu> gui, ItemStack stackReference) {
        if (!InventoryUtils.isStackEmpty(stackReference)) {
            AbstractContainerMenu container = gui.getMenu();
            stackReference = stackReference.copy();
            for (Slot slot : container.slots) {
                if (!InventoryUtils.areStacksEqual(slot.getItem(), stackReference)) continue;
                InventoryUtils.dropStack(gui, slot.index);
            }
        }
    }

    public static boolean shiftDropItems(AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        ItemStack stackReference = gui.getMenu().getCarried();
        if (!InventoryUtils.isStackEmpty(stackReference) && sourceSlot != null) {
            stackReference = stackReference.copy();
            InventoryUtils.dropItemsFromCursor(gui);
            InventoryUtils.dropStacks(gui, stackReference, (Slot)sourceSlot.get(), true);
            return true;
        }
        return false;
    }

    public static boolean shiftPlaceItems(Slot slot, AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        InventoryUtils.leftClickSlot(gui, slot.index);
        DRAGGED_SLOTS.add(slot.index);
        InventoryUtils.tryMoveStacks(slot, gui, true, false, false);
        return true;
    }

    public static void storeSourceSlotCandidate(Slot slot, AbstractContainerScreen<?> gui) {
        if (slot != null) {
            ItemStack stackCursor = gui.getMenu().getCarried();
            ItemStack stack = EMPTY_STACK;
            if (!InventoryUtils.isStackEmpty(stackCursor)) {
                stack = new ItemStack((ItemLike)stackCursor.getItem(), InventoryUtils.getStackSize(stackCursor));
            }
            sourceSlotCandidate = new WeakReference<Slot>(slot);
            stackInCursorLast = stack;
        }
    }

    public static void checkForItemPickup(AbstractContainerScreen<?> gui) {
        ItemStack stackCursor = gui.getMenu().getCarried();
        if (!InventoryUtils.isStackEmpty(stackCursor) && !ItemStack.isSameItem((ItemStack)stackCursor, (ItemStack)stackInCursorLast) && sourceSlotCandidate != null) {
            sourceSlot = new WeakReference<Slot>((Slot)sourceSlotCandidate.get());
        }
    }

    private static boolean tryMoveItemsVillager(MerchantScreen gui, Slot slot, boolean moveToOtherInventory, boolean fullStacks) {
        if (fullStacks) {
            if (!moveToOtherInventory) {
                InventoryUtils.tryMoveItemsToMerchantBuySlots(gui, true);
            } else if (slot.hasItem()) {
                InventoryUtils.tryMoveStacks(slot, (AbstractContainerScreen<? extends AbstractContainerMenu>)gui, true, true, true);
            } else {
                InventoryUtils.tryMoveStacks(slot, (AbstractContainerScreen<? extends AbstractContainerMenu>)gui, false, true, false);
            }
        } else if (!moveToOtherInventory) {
            InventoryUtils.tryMoveItemsToMerchantBuySlots(gui, false);
        } else if (slot.hasItem()) {
            InventoryUtils.moveOneSetOfItemsFromSlotToPlayerInventory((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, slot);
        }
        return false;
    }

    public static void villagerClearTradeInputSlots() {
        Screen screen = GuiUtils.getCurrentScreen();
        if (screen instanceof MerchantScreen) {
            MerchantScreen merchantGui = (MerchantScreen)screen;
            Slot slot = ((MerchantMenu)merchantGui.getMenu()).getSlot(0);
            if (slot.hasItem()) {
                InventoryUtils.shiftClickSlot((AbstractContainerScreen<? extends AbstractContainerMenu>)merchantGui, slot.index);
            }
            if ((slot = ((MerchantMenu)merchantGui.getMenu()).getSlot(1)).hasItem()) {
                InventoryUtils.shiftClickSlot((AbstractContainerScreen<? extends AbstractContainerMenu>)merchantGui, slot.index);
            }
        }
    }

    public static void villagerTradeEverythingPossibleWithTrade(int visibleIndex) {
        Screen screen = GuiUtils.getCurrentScreen();
        if (screen instanceof MerchantScreen) {
            MerchantScreen merchantGui = (MerchantScreen)screen;
            MerchantMenu handler = (MerchantMenu)merchantGui.getMenu();
            try {
                if (handler.getOffers().isEmpty()) {
                    return;
                }
            }
            catch (Exception ignored) {
                return;
            }
            Slot slot = handler.getSlot(2);
            ItemStack sellItem = ((MerchantOffer)handler.getOffers().get(visibleIndex)).getResult().copy();
            do {
                VillagerUtils.switchToTradeByVisibleIndex(visibleIndex);
                if (!InventoryUtils.areStacksEqual(sellItem, slot.getItem())) break;
                InventoryUtils.shiftClickSlot((AbstractContainerScreen<? extends AbstractContainerMenu>)merchantGui, slot.index);
            } while (!slot.hasItem());
            InventoryUtils.villagerClearTradeInputSlots();
        }
    }

    public static boolean villagerTradeEverythingPossibleWithAllFavoritedTrades() {
        Screen screen = GuiUtils.getCurrentScreen();
        if (screen instanceof MerchantScreen) {
            MerchantMenu handler = (MerchantMenu)((MerchantScreen)screen).getMenu();
            IntArrayList favorites = VillagerDataStorage.getInstance().getFavoritesForCurrentVillager((MerchantMenu)handler).favorites;
            for (int index = 0; index < favorites.size(); ++index) {
                VillagerUtils.switchToTradeByVisibleIndex(index);
                InventoryUtils.villagerTradeEverythingPossibleWithTrade(index);
            }
            InventoryUtils.villagerClearTradeInputSlots();
            return true;
        }
        return false;
    }

    private static boolean tryMoveSingleItemToOtherInventory(Slot slot, AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        int targetSlot;
        ItemStack stackOrig = slot.getItem();
        AbstractContainerMenu container = gui.getMenu();
        Minecraft mc = Minecraft.getInstance();
        if (!InventoryUtils.isStackEmpty(gui.getMenu().getCarried()) || !slot.mayPickup((Player)mc.player) || InventoryUtils.getStackSize(stackOrig) > 1 && !slot.mayPlace(stackOrig)) {
            return false;
        }
        if (InventoryUtils.getStackSize(stackOrig) <= stackOrig.getMaxStackSize()) {
            return InventoryUtils.clickSlotsToMoveSingleItemByShiftClick(gui, slot.index);
        }
        ItemStack stack = stackOrig.copy();
        InventoryUtils.setStackSize(stack, 1);
        ItemStack[] originalStacks = InventoryUtils.getOriginalStacks(container);
        slot.set(stack);
        container.quickMoveStack((Player)mc.player, slot.index);
        if (!slot.hasItem() && (targetSlot = InventoryUtils.getTargetSlot(container, originalStacks)) >= 0) {
            ((Slot)container.slots.get(targetSlot)).remove(1);
            InventoryUtils.restoreOriginalStacks(container, originalStacks);
            return InventoryUtils.clickSlotsToMoveSingleItem(gui, slot.index, targetSlot);
        }
        slot.set(stackOrig);
        return false;
    }

    private static boolean tryMoveAllButOneItemToOtherInventory(Slot slot, AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        ItemStack stackOrig = slot.getItem().copy();
        if (InventoryUtils.getStackSize(stackOrig) == 1 || InventoryUtils.getStackSize(stackOrig) > stackOrig.getMaxStackSize() || !slot.mayPickup((Player)player) || !slot.mayPlace(stackOrig)) {
            return true;
        }
        InventoryUtils.rightClickSlot(gui, slot.index);
        ItemStack stackInCursor = gui.getMenu().getCarried();
        if (InventoryUtils.isStackEmpty(stackInCursor)) {
            return false;
        }
        int stackInCursorSizeOrig = InventoryUtils.getStackSize(stackInCursor);
        int tempSlotNum = -1;
        for (Slot slotTmp : gui.getMenu().slots) {
            ItemStack stackInSlot;
            if (slotTmp.index == slot.index || !InventoryUtils.areSlotsInSameInventory(slotTmp, slot, true) || !slotTmp.mayPlace(stackInCursor) || !slotTmp.mayPickup((Player)player) || !InventoryUtils.isStackEmpty(stackInSlot = slotTmp.getItem()) && !InventoryUtils.areStacksEqual(stackInSlot, stackInCursor)) continue;
            InventoryUtils.rightClickSlot(gui, slotTmp.index);
            stackInCursor = gui.getMenu().getCarried();
            if (!InventoryUtils.isStackEmpty(stackInCursor) && InventoryUtils.getStackSize(stackInCursor) >= stackInCursorSizeOrig) continue;
            tempSlotNum = slotTmp.index;
            break;
        }
        if (!InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
            InventoryUtils.leftClickSlot(gui, slot.index);
        }
        if (tempSlotNum != -1) {
            InventoryUtils.shiftClickSlot(gui, slot.index);
            InventoryUtils.rightClickSlot(gui, tempSlotNum);
            InventoryUtils.rightClickSlot(gui, slot.index);
            if (!InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
                InventoryUtils.leftClickSlot(gui, tempSlotNum);
            }
            return true;
        }
        boolean treatHotbarAsDifferent = gui.getClass() == InventoryScreen.class;
        IntArrayList slots = InventoryUtils.getSlotNumbersOfEmptySlots(gui.getMenu(), slot, false, treatHotbarAsDifferent, false);
        if (slots.isEmpty()) {
            slots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.getMenu(), slot, false, slot.getItem(), true, treatHotbarAsDifferent, false);
        }
        if (!slots.isEmpty()) {
            InventoryUtils.leftClickSlot(gui, slot.index);
            InventoryUtils.rightClickSlot(gui, slot.index);
            IntListIterator intListIterator = slots.iterator();
            while (intListIterator.hasNext()) {
                int slotNum = (Integer)intListIterator.next();
                Slot slotTmp = gui.getMenu().getSlot(slotNum);
                stackInCursor = gui.getMenu().getCarried();
                if (InventoryUtils.isStackEmpty(stackInCursor)) {
                    return true;
                }
                if (!slotTmp.mayPlace(stackInCursor)) continue;
                InventoryUtils.leftClickSlot(gui, slotNum);
            }
            if (!InventoryUtils.isStackEmpty(stackInCursor)) {
                InventoryUtils.leftClickSlot(gui, slot.index);
            }
        }
        return false;
    }

    private static boolean tryMoveSingleItemToThisInventory(Slot slot, AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        AbstractContainerMenu container = gui.getMenu();
        ItemStack stackOrig = slot.getItem();
        Minecraft mc = Minecraft.getInstance();
        if (!slot.mayPlace(stackOrig)) {
            return false;
        }
        for (int slotNum = container.slots.size() - 1; slotNum >= 0; --slotNum) {
            Slot slotTmp = (Slot)container.slots.get(slotNum);
            ItemStack stackTmp = slotTmp.getItem();
            if (InventoryUtils.areSlotsInSameInventory(slotTmp, slot) || InventoryUtils.isStackEmpty(stackTmp) || !slotTmp.mayPickup((Player)mc.player) || InventoryUtils.getStackSize(stackTmp) != 1 && !slotTmp.mayPlace(stackTmp) || !InventoryUtils.areStacksEqual(stackTmp, stackOrig)) continue;
            return InventoryUtils.clickSlotsToMoveSingleItem(gui, slotTmp.index, slot.index);
        }
        return false;
    }

    public static void tryMoveStacks(Slot slot, AbstractContainerScreen<? extends AbstractContainerMenu> gui, boolean matchingOnly, boolean toOtherInventory, boolean firstOnly) {
        InventoryUtils.tryMoveStacks(slot.getItem(), slot, gui, matchingOnly, toOtherInventory, firstOnly);
    }

    private static void tryMoveStacks(ItemStack stackReference, Slot slot, AbstractContainerScreen<? extends AbstractContainerMenu> gui, boolean matchingOnly, boolean toOtherInventory, boolean firstOnly) {
        int maxSlot;
        AbstractContainerMenu container = gui.getMenu();
        for (int i = maxSlot = container.slots.size() - 1; i >= 0; --i) {
            Slot slotTmp = (Slot)container.slots.get(i);
            if (slotTmp.index == slot.index || InventoryUtils.areSlotsInSameInventory(slotTmp, slot) != toOtherInventory || !slotTmp.hasItem() || matchingOnly && !InventoryUtils.areStacksEqual(stackReference, slotTmp.getItem())) continue;
            boolean success = InventoryUtils.shiftClickSlotWithCheck(gui, slotTmp.index);
            if (!success && Configs.Toggles.SCROLL_STACKS_FALLBACK.getBooleanValue()) {
                InventoryUtils.clickSlotsToMoveItemsFromSlot(slotTmp, gui, toOtherInventory);
            }
            if (!firstOnly) continue;
            return;
        }
        if (toOtherInventory && !InventoryUtils.shiftClickSlotWithCheck(gui, slot.index) && Configs.Toggles.SCROLL_STACKS_FALLBACK.getBooleanValue()) {
            InventoryUtils.clickSlotsToMoveItemsFromSlot(slot, gui, toOtherInventory);
        }
    }

    private static void tryMoveItemsToMerchantBuySlots(MerchantScreen gui, boolean fillStacks) {
        MerchantOffers list = ((MerchantMenu)gui.getMenu()).getOffers();
        int index = AccessorUtils.getSelectedMerchantRecipe(gui);
        if (list == null || list.size() <= index) {
            return;
        }
        MerchantOffer recipe = (MerchantOffer)list.get(index);
        if (recipe == null) {
            return;
        }
        ItemStack buy1 = recipe.getCostA();
        ItemStack buy2 = recipe.getCostB();
        if (!InventoryUtils.isStackEmpty(buy1)) {
            InventoryUtils.fillBuySlot((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, 0, buy1, fillStacks);
        }
        if (!InventoryUtils.isStackEmpty(buy2)) {
            InventoryUtils.fillBuySlot((AbstractContainerScreen<? extends AbstractContainerMenu>)gui, 1, buy2, fillStacks);
        }
    }

    private static void fillBuySlot(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int slotNum, ItemStack buyStack, boolean fillStacks) {
        Slot slot = gui.getMenu().getSlot(slotNum);
        ItemStack existingStack = slot.getItem();
        Minecraft mc = Minecraft.getInstance();
        if (!InventoryUtils.isStackEmpty(existingStack) && !InventoryUtils.areStacksEqual(buyStack, existingStack)) {
            InventoryUtils.shiftClickSlot(gui, slotNum);
        }
        if (InventoryUtils.isStackEmpty(existingStack = slot.getItem()) || InventoryUtils.areStacksEqual(buyStack, existingStack)) {
            InventoryUtils.moveItemsFromInventory(gui, slotNum, (Container)mc.player.getInventory(), buyStack, fillStacks);
        }
    }

    public static void handleRecipeClick(AbstractContainerScreen<? extends AbstractContainerMenu> gui, Minecraft mc, RecipeStorage recipes, int hoveredRecipeId, boolean isLeftClick, boolean isRightClick, boolean isPickBlock, boolean isShiftDown) {
        if (isLeftClick || isRightClick) {
            boolean changed = recipes.getSelection() != hoveredRecipeId;
            recipes.changeSelectedRecipe(hoveredRecipeId);
            if (changed) {
                InventoryUtils.clearFirstCraftingGridOfItems(recipes.getSelectedRecipe(), gui, false);
            } else {
                InventoryUtils.tryMoveItemsToFirstCraftingGrid(recipes.getRecipe(hoveredRecipeId), gui, isShiftDown);
            }
            if (isRightClick) {
                Slot outputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
                boolean dropKeyDown = mc.options.keyDrop.isDown();
                if (outputSlot != null) {
                    if (dropKeyDown) {
                        if (isShiftDown) {
                            if (Configs.Generic.CARPET_CTRL_Q_CRAFTING.getBooleanValue()) {
                                InventoryUtils.dropStack(gui, outputSlot.index);
                            } else {
                                InventoryUtils.dropStacksUntilEmpty(gui, outputSlot.index);
                            }
                        } else {
                            InventoryUtils.dropItem(gui, outputSlot.index);
                        }
                    } else if (isShiftDown) {
                        InventoryUtils.shiftClickSlot(gui, outputSlot.index);
                    } else {
                        InventoryUtils.moveOneSetOfItemsFromSlotToPlayerInventory(gui, outputSlot);
                    }
                }
            }
        } else if (isPickBlock) {
            InventoryUtils.clearFirstCraftingGridOfAllItems(gui);
        }
    }

    public static void tryMoveItemsToFirstCraftingGrid(RecipePattern recipe, AbstractContainerScreen<? extends AbstractContainerMenu> gui, boolean fillStacks) {
        Slot craftingOutputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (craftingOutputSlot != null) {
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, craftingOutputSlot, gui, fillStacks);
        }
    }

    public static void loadRecipeItemsToGridForOutputSlotUnderMouse(RecipePattern recipe, AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        Slot slot = AccessorUtils.getSlotUnderMouse(gui);
        InventoryUtils.loadRecipeItemsToGridForOutputSlot(recipe, gui, slot);
    }

    private static void loadRecipeItemsToGridForOutputSlot(RecipePattern recipe, AbstractContainerScreen<? extends AbstractContainerMenu> gui, Slot outputSlot) {
        if (InventoryUtils.isCraftingSlot(gui, outputSlot) && !InventoryUtils.isStackEmpty(recipe.getResult())) {
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, outputSlot, gui, false);
        }
    }

    private static boolean tryMoveItemsCrafting(RecipeStorage recipes, Slot slot, AbstractContainerScreen<? extends AbstractContainerMenu> gui, boolean moveToOtherInventory, boolean moveStacks, boolean moveEverything) {
        RecipePattern recipe = recipes.getSelectedRecipe();
        ItemStack stackRecipeOutput = recipe.getResult();
        if (moveToOtherInventory) {
            if (slot.hasItem()) {
                if (InventoryUtils.areStacksEqual(slot.getItem(), stackRecipeOutput)) {
                    if (moveEverything) {
                        InventoryUtils.craftAsManyItemsAsPossible(recipe, slot, gui);
                    } else if (moveStacks) {
                        InventoryUtils.shiftClickSlot(gui, slot.index);
                    } else {
                        InventoryUtils.moveOneSetOfItemsFromSlotToPlayerInventory(gui, slot);
                    }
                }
            } else {
                InventoryUtils.clearCraftingGridOfAllItems(gui, CraftingHandler.getCraftingGridSlots(gui, slot));
            }
        } else if (!moveToOtherInventory && !InventoryUtils.isStackEmpty(stackRecipeOutput)) {
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, slot, gui, moveStacks);
        }
        return false;
    }

    private static void craftAsManyItemsAsPossible(RecipePattern recipe, Slot slot, AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        ItemStack result = recipe.getResult();
        for (int failSafe = 1024; failSafe > 0 && slot.hasItem() && InventoryUtils.areStacksEqual(slot.getItem(), result); --failSafe) {
            InventoryUtils.shiftClickSlot(gui, slot.index);
            if (slot.hasItem() && InventoryUtils.areStacksEqual(slot.getItem(), result)) break;
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, slot, gui, true);
        }
    }

    public static void clearFirstCraftingGridOfItems(RecipePattern recipe, AbstractContainerScreen<? extends AbstractContainerMenu> gui, boolean clearNonMatchingOnly) {
        Slot craftingOutputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (craftingOutputSlot != null) {
            CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, craftingOutputSlot);
            InventoryUtils.clearCraftingGridOfItems(recipe, gui, range, clearNonMatchingOnly);
        }
    }

    public static void clearFirstCraftingGridOfAllItems(AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        Slot craftingOutputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (craftingOutputSlot != null) {
            CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, craftingOutputSlot);
            InventoryUtils.clearCraftingGridOfAllItems(gui, range);
        }
    }

    private static boolean clearCraftingGridOfItems(RecipePattern recipe, AbstractContainerScreen<? extends AbstractContainerMenu> gui, CraftingHandler.SlotRange range, boolean clearNonMatchingOnly) {
        int invSlots = gui.getMenu().slots.size();
        int rangeSlots = range.getSlotCount();
        int recipeSize = recipe.getRecipeLength();
        int slotCount = Math.min(rangeSlots, recipeSize);
        int i = 0;
        for (int slotNum = range.getFirst(); i < slotCount && slotNum < invSlots; ++i, ++slotNum) {
            Slot slotTmp = gui.getMenu().getSlot(slotNum);
            if (slotTmp == null || !slotTmp.hasItem() || clearNonMatchingOnly && InventoryUtils.areStacksEqual(recipe.getRecipeItems()[i], slotTmp.getItem())) continue;
            InventoryUtils.shiftClickSlot(gui, slotNum);
            if (!slotTmp.hasItem()) continue;
            InventoryUtils.dropStack(gui, slotNum);
        }
        return true;
    }

    private static boolean clearCraftingGridOfAllItems(AbstractContainerScreen<? extends AbstractContainerMenu> gui, CraftingHandler.SlotRange range) {
        int invSlots = gui.getMenu().slots.size();
        int rangeSlots = range.getSlotCount();
        boolean clearedAll = true;
        int i = 0;
        for (int slotNum = range.getFirst(); i < rangeSlots && slotNum < invSlots; ++i, ++slotNum) {
            Slot slotTmp = gui.getMenu().getSlot(slotNum);
            if (slotTmp == null || !slotTmp.hasItem()) continue;
            InventoryUtils.shiftClickSlot(gui, slotNum);
            if (!slotTmp.hasItem()) continue;
            clearedAll = false;
        }
        return clearedAll;
    }

    private static boolean tryMoveItemsToCraftingGridSlots(RecipePattern recipe, Slot slot, AbstractContainerScreen<? extends AbstractContainerMenu> gui, boolean fillStacks) {
        AbstractContainerMenu container = gui.getMenu();
        int numSlots = container.slots.size();
        CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, slot);
        if (range != null && range.getLast() < numSlots && recipe.getRecipeLength() <= range.getSlotCount()) {
            if (!InventoryUtils.clearCraftingGridOfItems(recipe, gui, range, true)) {
                return false;
            }
            Slot slotGridFirst = container.getSlot(range.getFirst());
            Map<ItemType, IntArrayList> ingredientSlots = ItemType.getSlotsPerItem(recipe.getRecipeItems());
            for (Map.Entry<ItemType, IntArrayList> entry : ingredientSlots.entrySet()) {
                ItemStack ingredientReference = entry.getKey().stack();
                IntArrayList recipeSlots = entry.getValue();
                IntArrayList targetSlots = new IntArrayList();
                IntListIterator intListIterator = recipeSlots.iterator();
                while (intListIterator.hasNext()) {
                    int s = (Integer)intListIterator.next();
                    targetSlots.add(s + range.getFirst());
                }
                if (fillStacks) {
                    InventoryUtils.fillCraftingGrid(gui, slotGridFirst, ingredientReference, targetSlots);
                    continue;
                }
                InventoryUtils.moveOneRecipeItemIntoCraftingGrid(gui, slotGridFirst, ingredientReference, targetSlots);
            }
        }
        return false;
    }

    private static void fillCraftingGrid(AbstractContainerScreen<? extends AbstractContainerMenu> gui, Slot slotGridFirst, ItemStack ingredientReference, IntArrayList targetSlots) {
        int slotNum;
        AbstractContainerMenu container = gui.getMenu();
        int slotReturn = -1;
        if (InventoryUtils.isStackEmpty(ingredientReference)) {
            return;
        }
        while ((slotNum = InventoryUtils.getSlotNumberOfLargestMatchingStackFromDifferentInventory(container, slotGridFirst, ingredientReference)) >= 0) {
            if (slotReturn == -1) {
                slotReturn = slotNum;
            }
            InventoryUtils.leftClickSlot(gui, slotNum);
            ItemStack stackCursor = gui.getMenu().getCarried();
            if (!InventoryUtils.areStacksEqual(ingredientReference, stackCursor)) break;
            int sizeOrig = InventoryUtils.getStackSize(stackCursor);
            InventoryUtils.dragSplitItemsIntoSlots(gui, targetSlots);
            stackCursor = gui.getMenu().getCarried();
            if (!InventoryUtils.isStackEmpty(stackCursor)) {
                if (InventoryUtils.getStackSize(stackCursor) >= sizeOrig) break;
                InventoryUtils.leftClickSlot(gui, slotReturn);
                if (!InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
                    slotReturn = slotNum;
                    InventoryUtils.leftClickSlot(gui, slotReturn);
                }
            }
            if (InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) continue;
            break;
        }
        if (slotNum >= 0 && !InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
            InventoryUtils.leftClickSlot(gui, slotNum);
        }
    }

    public static void rightClickCraftOneStack(AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        Slot slot = AccessorUtils.getSlotUnderMouse(gui);
        ItemStack stackCursor = gui.getMenu().getCarried();
        if (slot == null || !slot.hasItem() || !InventoryUtils.isStackEmpty(stackCursor) && !InventoryUtils.areStacksEqual(slot.getItem(), stackCursor)) {
            return;
        }
        int sizeLast = 0;
        while (true) {
            InventoryUtils.rightClickSlot(gui, slot.index);
            stackCursor = gui.getMenu().getCarried();
            if (InventoryUtils.isStackEmpty(stackCursor) || InventoryUtils.getStackSize(stackCursor) <= sizeLast || InventoryUtils.getStackSize(stackCursor) >= stackCursor.getMaxStackSize() || !InventoryUtils.areStacksEqual(slot.getItem(), stackCursor)) break;
            sizeLast = InventoryUtils.getStackSize(stackCursor);
        }
    }

    public static void craftEverythingPossibleWithCurrentRecipe(RecipePattern recipe, AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        CraftingHandler.SlotRange range;
        Slot slot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (slot != null && !InventoryUtils.isStackEmpty(recipe.getResult()) && (range = CraftingHandler.getCraftingGridSlots(gui, slot)) != null) {
            if (!InventoryUtils.clearCraftingGridOfItems(recipe, gui, range, false)) {
                return;
            }
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, slot, gui, true);
            if (slot.hasItem()) {
                InventoryUtils.craftAsManyItemsAsPossible(recipe, slot, gui);
            }
        }
    }

    public static void moveAllCraftingResultsToOtherInventory(RecipePattern recipe, AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        if (!InventoryUtils.isStackEmpty(recipe.getResult())) {
            Slot slot = null;
            ItemStack stackResult = recipe.getResult().copy();
            for (Slot slotTmp : gui.getMenu().slots) {
                if (!InventoryUtils.areStacksEqual(slotTmp.getItem(), stackResult) || !InventoryUtils.inventoryExistsAbove(slotTmp, gui.getMenu())) continue;
                slot = slotTmp;
                break;
            }
            if (slot != null) {
                IntArrayList slots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.getMenu(), slot, true, stackResult, false, false, false);
                IntListIterator intListIterator = slots.iterator();
                while (intListIterator.hasNext()) {
                    int slotNum = (Integer)intListIterator.next();
                    InventoryUtils.shiftClickSlot(gui, slotNum);
                }
            }
        }
    }

    public static void throwAllCraftingResultsToGround(RecipePattern recipe, AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        Slot slot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (slot != null && !InventoryUtils.isStackEmpty(recipe.getResult())) {
            InventoryUtils.dropStacks(gui, recipe.getResult(), slot, false);
        }
    }

    public static void throwAllNonRecipeItemsToGround(RecipePattern recipe, AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        Slot outputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (outputSlot != null && !InventoryUtils.isStackEmpty(recipe.getResult())) {
            CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, outputSlot);
            ItemStack[] recipeItems = recipe.getRecipeItems();
            int invSlots = gui.getMenu().slots.size();
            int rangeSlots = Math.min(range.getSlotCount(), recipeItems.length);
            int i = 0;
            for (int slotNum = range.getFirst(); i < rangeSlots && slotNum < invSlots; ++i, ++slotNum) {
                Slot slotTmp = gui.getMenu().getSlot(slotNum);
                ItemStack stack = slotTmp.getItem();
                if (stack.isEmpty() || InventoryUtils.areStacksEqual(stack, recipeItems[i])) continue;
                InventoryUtils.dropAllMatchingStacks(gui, stack);
            }
        }
    }

    public static void setCraftingGridContentsUsingSwaps(AbstractContainerScreen<? extends AbstractContainerMenu> gui, Inventory inv, RecipePattern recipe, Slot outputSlot) {
        CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, outputSlot);
        if (range != null && !InventoryUtils.isStackEmpty(recipe.getResult())) {
            int slotNum;
            ItemStack[] recipeItems = recipe.getRecipeItems();
            int invSlots = gui.getMenu().slots.size();
            int rangeSlots = Math.min(range.getSlotCount(), recipeItems.length);
            IntArrayList toRemove = new IntArrayList();
            boolean movedSomething = false;
            InventoryUtils.setInhibitCraftingOutputUpdate(true);
            int i = 0;
            for (slotNum = range.getFirst(); i < rangeSlots && slotNum < invSlots; ++i, ++slotNum) {
                ItemStack recipeStack = recipeItems[i];
                Slot craftingTableSlot = gui.getMenu().getSlot(slotNum);
                ItemStack slotStack = craftingTableSlot.getItem();
                if (InventoryUtils.areStacksEqual(recipeStack, slotStack)) continue;
                if (recipeStack.isEmpty()) {
                    toRemove.add(slotNum);
                    continue;
                }
                int index = InventoryUtils.getSlotNumberOfLargestMatchingStackFromDifferentInventory(gui.getMenu(), craftingTableSlot, recipeStack);
                if (index < 0) continue;
                Slot ingredientSlot = gui.getMenu().getSlot(index);
                if (ingredientSlot.container instanceof Inventory && ingredientSlot.getContainerSlot() < 9) {
                    InventoryUtils.clickSlot(gui, slotNum, ingredientSlot.getContainerSlot(), ClickType.SWAP);
                } else {
                    InventoryUtils.swapSlots(gui, slotNum, index);
                }
                movedSomething = true;
            }
            movedSomething |= !toRemove.isEmpty();
            IntListIterator intListIterator = toRemove.iterator();
            while (intListIterator.hasNext()) {
                slotNum = (Integer)intListIterator.next();
                InventoryUtils.shiftClickSlot(gui, slotNum);
                if (InventoryUtils.isStackEmpty(gui.getMenu().getSlot(slotNum).getItem())) continue;
                InventoryUtils.dropStack(gui, slotNum);
            }
            InventoryUtils.setInhibitCraftingOutputUpdate(false);
            if (movedSomething) {
                InventoryUtils.updateCraftingOutputSlot(outputSlot);
            }
        }
    }

    private static int putSingleItemIntoSlots(AbstractContainerScreen<? extends AbstractContainerMenu> gui, IntArrayList targetSlots, int startIndex) {
        int slotNum;
        ItemStack stackInCursor = gui.getMenu().getCarried();
        if (InventoryUtils.isStackEmpty(stackInCursor)) {
            return 0;
        }
        int numSlots = gui.getMenu().slots.size();
        int numItems = InventoryUtils.getStackSize(stackInCursor);
        int loops = Math.min(numItems, targetSlots.size() - startIndex);
        int count = 0;
        for (int i = 0; i < loops && (slotNum = targetSlots.getInt(startIndex + i)) < numSlots; ++i) {
            InventoryUtils.rightClickSlot(gui, slotNum);
            ++count;
        }
        return count;
    }

    public static void moveOneSetOfItemsFromSlotToPlayerInventory(AbstractContainerScreen<? extends AbstractContainerMenu> gui, Slot slot) {
        IntArrayList slots;
        InventoryUtils.leftClickSlot(gui, slot.index);
        ItemStack stackCursor = gui.getMenu().getCarried();
        if (!InventoryUtils.isStackEmpty(stackCursor) && !InventoryUtils.moveItemFromCursorToSlots(gui, slots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.getMenu(), slot, false, stackCursor, true, true, false))) {
            slots = InventoryUtils.getSlotNumbersOfEmptySlotsInPlayerInventory(gui.getMenu(), false);
            InventoryUtils.moveItemFromCursorToSlots(gui, slots);
        }
    }

    private static void moveOneRecipeItemIntoCraftingGrid(AbstractContainerScreen<? extends AbstractContainerMenu> gui, Slot slotGridFirst, ItemStack ingredientReference, IntArrayList targetSlots) {
        int filled;
        AbstractContainerMenu container = gui.getMenu();
        int slotNum = -1;
        int slotCount = targetSlots.size();
        for (int index = 0; index < slotCount && (slotNum = InventoryUtils.getSlotNumberOfSmallestStackFromDifferentInventory(container, slotGridFirst, ingredientReference, slotCount)) >= 0; index += filled) {
            InventoryUtils.leftClickSlot(gui, slotNum);
            if (!InventoryUtils.areStacksEqual(ingredientReference, gui.getMenu().getCarried())) break;
            filled = InventoryUtils.putSingleItemIntoSlots(gui, targetSlots, index);
            if (filled >= 1) continue;
            break;
        }
        if (slotNum >= 0 && !InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
            InventoryUtils.leftClickSlot(gui, slotNum);
        }
    }

    private static boolean moveItemFromCursorToSlots(AbstractContainerScreen<? extends AbstractContainerMenu> gui, IntArrayList slotNumbers) {
        IntListIterator intListIterator = slotNumbers.iterator();
        while (intListIterator.hasNext()) {
            int slotNum = (Integer)intListIterator.next();
            InventoryUtils.leftClickSlot(gui, slotNum);
            if (!InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) continue;
            return true;
        }
        return false;
    }

    private static void moveItemsFromInventory(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int slotTo, Container invSrc, ItemStack stackTemplate, boolean fillStacks) {
        AbstractContainerMenu container = gui.getMenu();
        for (Slot slot : container.slots) {
            if (slot == null || slot.container != invSrc || !InventoryUtils.areStacksEqual(stackTemplate, slot.getItem())) continue;
            if (fillStacks) {
                if (InventoryUtils.clickSlotsToMoveItems(gui, slot.index, slotTo)) continue;
                break;
            }
            InventoryUtils.clickSlotsToMoveSingleItem(gui, slot.index, slotTo);
            break;
        }
    }

    private static int getSlotNumberOfLargestMatchingStackFromDifferentInventory(AbstractContainerMenu container, Slot slotReference, ItemStack stackReference) {
        int slotNum = -1;
        int largest = 0;
        for (Slot slot : container.slots) {
            int stackSize;
            if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) || !slot.hasItem() || !InventoryUtils.areStacksEqual(stackReference, slot.getItem()) || (stackSize = InventoryUtils.getStackSize(slot.getItem())) <= largest) continue;
            slotNum = slot.index;
            largest = stackSize;
        }
        return slotNum;
    }

    private static int getSlotNumberOfSmallestStackFromDifferentInventory(AbstractContainerMenu container, Slot slotReference, ItemStack stackReference, int idealSize) {
        int slotNumSmallest = -1;
        int slotNumLargest = -1;
        int smallest = Integer.MAX_VALUE;
        int largest = 0;
        for (Slot slot : container.slots) {
            if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) || !slot.hasItem() || !InventoryUtils.areStacksEqual(stackReference, slot.getItem())) continue;
            int stackSize = InventoryUtils.getStackSize(slot.getItem());
            if (stackSize < smallest && stackSize >= idealSize) {
                slotNumSmallest = slot.index;
                smallest = stackSize;
            }
            if (stackSize <= largest) continue;
            slotNumLargest = slot.index;
            largest = stackSize;
        }
        return slotNumSmallest != -1 ? slotNumSmallest : slotNumLargest;
    }

    private static IntArrayList getSlotNumbersOfMatchingStacks(AbstractContainerMenu container, Slot slotReference, boolean sameInventory, ItemStack stackReference, boolean preferPartial, boolean treatHotbarAsDifferent, boolean reverse) {
        int i;
        IntArrayList slots = new IntArrayList(64);
        int maxSlot = container.slots.size() - 1;
        int increment = reverse ? -1 : 1;
        int n = i = reverse ? maxSlot : 0;
        while (i >= 0 && i <= maxSlot) {
            Slot slot = container.getSlot(i);
            if (slot != null && slot.hasItem() && InventoryUtils.areSlotsInSameInventory(slot, slotReference, treatHotbarAsDifferent) == sameInventory && InventoryUtils.areStacksEqual(slot.getItem(), stackReference)) {
                if (InventoryUtils.getStackSize(slot.getItem()) < stackReference.getMaxStackSize() == preferPartial) {
                    slots.add(0, slot.index);
                } else {
                    slots.add(slot.index);
                }
            }
            i += increment;
        }
        return slots;
    }

    private static IntArrayList getSlotNumbersOfMatchingStacks(AbstractContainerMenu container, ItemStack stackReference, boolean preferPartial) {
        IntArrayList slots = new IntArrayList(64);
        int maxSlot = container.slots.size() - 1;
        for (int i = 0; i <= maxSlot; ++i) {
            Slot slot = container.getSlot(i);
            if (slot == null || !slot.hasItem() || !InventoryUtils.areStacksEqual(slot.getItem(), stackReference)) continue;
            if (InventoryUtils.getStackSize(slot.getItem()) < stackReference.getMaxStackSize() == preferPartial) {
                slots.add(0, slot.index);
                continue;
            }
            slots.add(slot.index);
        }
        return slots;
    }

    public static int getPlayerInventoryIndexWithItem(ItemStack stackReference, Inventory inv) {
        int size = inv.getNonEquipmentItems().size();
        for (int index = 0; index < size; ++index) {
            ItemStack stack = (ItemStack)inv.getNonEquipmentItems().get(index);
            if (!InventoryUtils.areStacksEqual(stack, stackReference)) continue;
            return index;
        }
        return -1;
    }

    private static IntArrayList getSlotNumbersOfEmptySlots(AbstractContainerMenu container, Slot slotReference, boolean sameInventory, boolean treatHotbarAsDifferent, boolean reverse) {
        int i;
        IntArrayList slots = new IntArrayList(64);
        int maxSlot = container.slots.size() - 1;
        int increment = reverse ? -1 : 1;
        int n = i = reverse ? maxSlot : 0;
        while (i >= 0 && i <= maxSlot) {
            Slot slot = container.getSlot(i);
            if (slot != null && !slot.hasItem() && InventoryUtils.areSlotsInSameInventory(slot, slotReference, treatHotbarAsDifferent) == sameInventory) {
                slots.add(slot.index);
            }
            i += increment;
        }
        return slots;
    }

    private static IntArrayList getSlotNumbersOfEmptySlotsInPlayerInventory(AbstractContainerMenu container, boolean reverse) {
        int i;
        IntArrayList slots = new IntArrayList(64);
        int maxSlot = container.slots.size() - 1;
        int increment = reverse ? -1 : 1;
        int n = i = reverse ? maxSlot : 0;
        while (i >= 0 && i <= maxSlot) {
            Slot slot = container.getSlot(i);
            if (slot != null && slot.container instanceof Inventory && !slot.hasItem()) {
                slots.add(slot.index);
            }
            i += increment;
        }
        return slots;
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    private static boolean areSlotsInSameInventory(Slot slot1, Slot slot2) {
        return InventoryUtils.areSlotsInSameInventory(slot1, slot2, false);
    }

    private static boolean areSlotsInSameInventory(Slot slot1, Slot slot2, boolean treatHotbarAsDifferent) {
        if (slot1.container == slot2.container) {
            if (treatHotbarAsDifferent && slot1.container instanceof Inventory) {
                int index1 = AccessorUtils.getSlotIndex(slot1);
                int index2 = AccessorUtils.getSlotIndex(slot2);
                return index1 == 40 || index2 == 40 || index1 < 9 == index2 < 9;
            }
            return true;
        }
        return false;
    }

    private static ItemStack[] getOriginalStacks(AbstractContainerMenu container) {
        ItemStack[] originalStacks = new ItemStack[container.slots.size()];
        for (int i = 0; i < originalStacks.length; ++i) {
            originalStacks[i] = ((Slot)container.slots.get(i)).getItem().copy();
        }
        return originalStacks;
    }

    private static void restoreOriginalStacks(AbstractContainerMenu container, ItemStack[] originalStacks) {
        for (int i = 0; i < originalStacks.length; ++i) {
            ItemStack stackSlot = container.getSlot(i).getItem();
            if (InventoryUtils.areStacksEqual(stackSlot, originalStacks[i]) && (InventoryUtils.isStackEmpty(stackSlot) || InventoryUtils.getStackSize(stackSlot) == InventoryUtils.getStackSize(originalStacks[i]))) continue;
            container.getSlot(i).set(originalStacks[i]);
        }
    }

    private static int getTargetSlot(AbstractContainerMenu container, ItemStack[] originalStacks) {
        NonNullList slots = container.slots;
        for (int i = 0; i < originalStacks.length; ++i) {
            ItemStack stackOrig = originalStacks[i];
            ItemStack stackNew = ((Slot)slots.get(i)).getItem();
            if ((!InventoryUtils.isStackEmpty(stackOrig) || InventoryUtils.isStackEmpty(stackNew)) && (InventoryUtils.isStackEmpty(stackOrig) || InventoryUtils.isStackEmpty(stackNew) || InventoryUtils.getStackSize(stackNew) != InventoryUtils.getStackSize(stackOrig) + 1)) continue;
            return i;
        }
        return -1;
    }

    private static void clickSlotsToMoveItemsFromSlot(Slot slotFrom, AbstractContainerScreen<? extends AbstractContainerMenu> gui, boolean toOtherInventory) {
        InventoryUtils.leftClickSlot(gui, slotFrom.index);
        if (InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
            return;
        }
        for (Slot slotDst : gui.getMenu().slots) {
            ItemStack stackDst = slotDst.getItem();
            if (InventoryUtils.areSlotsInSameInventory(slotDst, slotFrom) != toOtherInventory && (InventoryUtils.isStackEmpty(stackDst) || InventoryUtils.areStacksEqual(stackDst, gui.getMenu().getCarried()))) {
                InventoryUtils.leftClickSlot(gui, slotDst.index);
            }
            if (!InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) continue;
            return;
        }
        if (!InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
            InventoryUtils.leftClickSlot(gui, slotFrom.index);
        }
    }

    private static boolean clickSlotsToMoveSingleItem(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int slotFrom, int slotTo) {
        ItemStack stack = ((Slot)gui.getMenu().slots.get(slotFrom)).getItem();
        if (InventoryUtils.isStackEmpty(stack)) {
            return false;
        }
        if (InventoryUtils.getStackSize(stack) > 1) {
            InventoryUtils.rightClickSlot(gui, slotFrom);
        } else {
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        InventoryUtils.rightClickSlot(gui, slotTo);
        if (!InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        return true;
    }

    private static boolean clickSlotsToMoveSingleItemByShiftClick(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int slotFrom) {
        Slot slot = (Slot)gui.getMenu().slots.get(slotFrom);
        ItemStack stack = slot.getItem();
        if (InventoryUtils.isStackEmpty(stack)) {
            return false;
        }
        if (InventoryUtils.getStackSize(stack) > 1) {
            InventoryUtils.leftClickSlot(gui, slotFrom);
            if (slot.hasItem()) {
                InventoryUtils.leftClickSlot(gui, slotFrom);
                return false;
            }
            InventoryUtils.rightClickSlot(gui, slotFrom);
        }
        InventoryUtils.shiftClickSlot(gui, slotFrom);
        if (!InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        return true;
    }

    private static boolean clickSlotsToMoveItems(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int slotFrom, int slotTo) {
        InventoryUtils.leftClickSlot(gui, slotFrom);
        if (InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
            return false;
        }
        boolean ret = true;
        int size = InventoryUtils.getStackSize(gui.getMenu().getCarried());
        InventoryUtils.leftClickSlot(gui, slotTo);
        if (!InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
            ret = InventoryUtils.getStackSize(gui.getMenu().getCarried()) != size;
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        return ret;
    }

    public static void dropStacksUntilEmpty(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int slotNum) {
        if (slotNum >= 0 && slotNum < gui.getMenu().slots.size()) {
            Slot slot = gui.getMenu().getSlot(slotNum);
            int failsafe = 64;
            while (failsafe-- > 0 && slot.hasItem()) {
                InventoryUtils.dropStack(gui, slotNum);
            }
        }
    }

    public static void dropStacksWhileHasItem(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int slotNum, ItemStack stackReference) {
        if (slotNum >= 0 && slotNum < gui.getMenu().slots.size()) {
            Slot slot = gui.getMenu().getSlot(slotNum);
            int failsafe = 256;
            while (failsafe-- > 0 && InventoryUtils.areStacksEqual(slot.getItem(), stackReference)) {
                InventoryUtils.dropStack(gui, slotNum);
            }
        }
    }

    private static boolean shiftClickSlotWithCheck(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int slotNum) {
        Slot slot = gui.getMenu().getSlot(slotNum);
        if (slot == null || !slot.hasItem()) {
            return false;
        }
        int sizeOrig = InventoryUtils.getStackSize(slot.getItem());
        InventoryUtils.shiftClickSlot(gui, slotNum);
        return !slot.hasItem() || InventoryUtils.getStackSize(slot.getItem()) != sizeOrig;
    }

    public static boolean tryMoveItemsVertically(AbstractContainerScreen<? extends AbstractContainerMenu> gui, Slot slot, boolean moveUp, MoveAmount amount) {
        if (slot == null || !InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
            return false;
        }
        IntArrayList slots = InventoryUtils.getVerticallyFurthestSuitableSlotsForStackInSlot(gui.getMenu(), slot, moveUp);
        if (slots.isEmpty()) {
            return false;
        }
        if (amount == MoveAmount.FULL_STACKS) {
            InventoryUtils.moveStackToSlots(gui, slot, slots, false);
        } else if (amount == MoveAmount.MOVE_ONE) {
            InventoryUtils.moveOneItemToFirstValidSlot(gui, slot, slots);
        } else if (amount == MoveAmount.LEAVE_ONE) {
            InventoryUtils.moveStackToSlots(gui, slot, slots, true);
        } else if (amount == MoveAmount.ALL_MATCHING) {
            InventoryUtils.moveMatchingStacksToSlots(gui, slot, moveUp);
        }
        return true;
    }

    private static void moveMatchingStacksToSlots(AbstractContainerScreen<? extends AbstractContainerMenu> gui, Slot slot, boolean moveUp) {
        IntArrayList matchingSlots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.getMenu(), slot, true, slot.getItem(), true, true, false);
        IntArrayList targetSlots = InventoryUtils.getSlotNumbersOfEmptySlots(gui.getMenu(), slot, false, true, false);
        targetSlots.addAll((IntList)InventoryUtils.getSlotNumbersOfEmptySlots(gui.getMenu(), slot, true, true, false));
        targetSlots.addAll((IntList)matchingSlots);
        matchingSlots.sort((IntComparator)new SlotVerticalSorterSlotNumbers(gui.getMenu(), !moveUp));
        targetSlots.sort((IntComparator)new SlotVerticalSorterSlotNumbers(gui.getMenu(), moveUp));
        IntListIterator intListIterator = matchingSlots.iterator();
        while (intListIterator.hasNext()) {
            int matchingSlot;
            int srcSlotNum = matchingSlot = ((Integer)intListIterator.next()).intValue();
            Slot srcSlot = gui.getMenu().getSlot(srcSlotNum);
            Slot lastSlot = InventoryUtils.moveStackToSlots(gui, srcSlot, targetSlots, false);
            if (lastSlot != null && lastSlot.index != srcSlot.index && lastSlot.y > srcSlot.y != moveUp) continue;
            return;
        }
    }

    private static Slot moveStackToSlots(AbstractContainerScreen<? extends AbstractContainerMenu> gui, Slot slotFrom, IntArrayList slotsTo, boolean leaveOne) {
        Slot lastSlot = null;
        if (!slotFrom.hasItem()) {
            return null;
        }
        InventoryUtils.leftClickSlot(gui, slotFrom.index);
        if (leaveOne) {
            InventoryUtils.rightClickSlot(gui, slotFrom.index);
        }
        IntListIterator intListIterator = slotsTo.iterator();
        while (intListIterator.hasNext()) {
            int slotNum = (Integer)intListIterator.next();
            if (InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) break;
            Slot dstSlot = gui.getMenu().getSlot(slotNum);
            if (!dstSlot.mayPlace(gui.getMenu().getCarried()) || dstSlot.hasItem() && !InventoryUtils.areStacksEqual(dstSlot.getItem(), gui.getMenu().getCarried())) continue;
            InventoryUtils.leftClickSlot(gui, slotNum);
            lastSlot = dstSlot;
        }
        if (!InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
            InventoryUtils.leftClickSlot(gui, slotFrom.index);
        }
        return lastSlot;
    }

    private static void moveOneItemToFirstValidSlot(AbstractContainerScreen<? extends AbstractContainerMenu> gui, Slot slotFrom, IntArrayList slotsTo) {
        InventoryUtils.rightClickSlot(gui, slotFrom.index);
        if (InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
            return;
        }
        int sizeOrig = InventoryUtils.getStackSize(gui.getMenu().getCarried());
        IntListIterator intListIterator = slotsTo.iterator();
        while (intListIterator.hasNext()) {
            int slotNum = (Integer)intListIterator.next();
            InventoryUtils.rightClickSlot(gui, slotNum);
            ItemStack stackCursor = gui.getMenu().getCarried();
            if (!InventoryUtils.isStackEmpty(stackCursor) && InventoryUtils.getStackSize(stackCursor) == sizeOrig) continue;
            break;
        }
        if (!InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
            InventoryUtils.leftClickSlot(gui, slotFrom.index);
        }
    }

    private static IntArrayList getVerticallyFurthestSuitableSlotsForStackInSlot(AbstractContainerMenu container, Slot slotIn, boolean above) {
        if (slotIn == null || !slotIn.hasItem()) {
            return IntArrayList.of();
        }
        IntArrayList slotNumbers = new IntArrayList();
        ItemStack stackSlot = slotIn.getItem();
        for (Slot slotTmp : container.slots) {
            ItemStack stackTmp;
            if (slotTmp.index == slotIn.index || slotTmp.y == slotIn.y || above != slotTmp.y < slotIn.y || (!InventoryUtils.isStackEmpty(stackTmp = slotTmp.getItem()) || !slotTmp.mayPlace(stackSlot)) && (!InventoryUtils.areStacksEqual(stackTmp, stackSlot) || slotTmp.getMaxStackSize(stackTmp) <= InventoryUtils.getStackSize(stackTmp))) continue;
            slotNumbers.add(slotTmp.index);
        }
        slotNumbers.sort((IntComparator)new SlotVerticalSorterSlotNumbers(container, above));
        return slotNumbers;
    }

    public static void tryClearCursor(AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        ItemStack stackCursor = gui.getMenu().getCarried();
        if (!InventoryUtils.isStackEmpty(stackCursor)) {
            IntArrayList emptySlots = InventoryUtils.getSlotNumbersOfEmptySlotsInPlayerInventory(gui.getMenu(), false);
            if (!emptySlots.isEmpty()) {
                InventoryUtils.leftClickSlot(gui, emptySlots.getInt(0));
            } else {
                IntArrayList matchingSlots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.getMenu(), stackCursor, true);
                if (!matchingSlots.isEmpty()) {
                    IntListIterator intListIterator = matchingSlots.iterator();
                    while (intListIterator.hasNext()) {
                        int slotNum = (Integer)intListIterator.next();
                        Slot slot = gui.getMenu().getSlot(slotNum);
                        ItemStack stackSlot = slot.getItem();
                        if (slot == null || !InventoryUtils.areStacksEqual(stackSlot, stackCursor) || InventoryUtils.getStackSize(stackSlot) >= stackCursor.getMaxStackSize()) break;
                        if (!(slot.container instanceof Inventory)) continue;
                        InventoryUtils.leftClickSlot(gui, slotNum);
                        stackCursor = gui.getMenu().getCarried();
                    }
                }
            }
            if (!InventoryUtils.isStackEmpty(gui.getMenu().getCarried())) {
                InventoryUtils.dropItemsFromCursor(gui);
            }
        }
    }

    public static void resetLastSlotNumber() {
        slotNumberLast = -1;
    }

    public static MoveAction getActiveMoveAction() {
        return activeMoveAction;
    }

    public static void sortInventory(AbstractContainerScreen<?> gui) {
        int hotbarSlot;
        CreativeModeInventoryScreen creative;
        IntIntMutablePair range = new IntIntMutablePair(Integer.MAX_VALUE, 0);
        Slot focusedSlot = AccessorUtils.getSlotUnderMouse(gui);
        Minecraft mc = GameWrap.getClient();
        if (focusedSlot == null) {
            return;
        }
        AbstractContainerMenu container = gui.getMenu();
        int limit = container.slots.size();
        int focusedIndex = -1;
        if (gui instanceof CreativeModeInventoryScreen && !(creative = (CreativeModeInventoryScreen)gui).isInventoryOpen()) {
            return;
        }
        if (gui instanceof InventoryScreen && (focusedSlot.index < 9 || focusedSlot.index > 44)) {
            return;
        }
        boolean shulkerBoxFix = gui instanceof ShulkerBoxScreen && focusedSlot.index < 27;
        for (int i = 0; i < limit; ++i) {
            Slot slot = (Slot)container.slots.get(i);
            if (slot == focusedSlot) {
                focusedIndex = i;
            }
            if (slot.container != focusedSlot.container) continue;
            if (i < (Integer)range.first()) {
                range.first((Object)i);
            }
            if (i < (Integer)range.second()) continue;
            range.second((Object)(i + 1));
        }
        if (focusedIndex == -1) {
            return;
        }
        if (focusedSlot.container instanceof Inventory) {
            if ((Integer)range.left() == 5 && (Integer)range.right() == 46) {
                if (focusedIndex >= 9 && focusedIndex < 36) {
                    range.left((Object)9).right((Object)36);
                } else if (focusedIndex >= 36 && focusedIndex < 45) {
                    range.left((Object)36).right((Object)45);
                }
            } else if ((Integer)range.right() - (Integer)range.left() == 36) {
                if (focusedIndex < (Integer)range.left() + 27) {
                    range.right((Object)((Integer)range.left() + 27));
                } else {
                    range.left((Object)((Integer)range.right() - 9));
                }
            }
        }
        if (shulkerBoxFix) {
            int slot_ix;
            Inventory playerInventory = Minecraft.getInstance().player.getInventory();
            for (hotbarSlot = 8; hotbarSlot >= 0 && ((slot_ix = container.findSlot((Container)playerInventory, hotbarSlot).orElse(-1)) == -1 || InventoryUtils.isShulkerBox(container.getSlot(slot_ix).getItem())); --hotbarSlot) {
            }
            if (hotbarSlot < 0) {
                ItemScroller.LOGGER.warn("sortInventory(): no usable hotbar slot to sort shulkerbox");
                return;
            }
        }
        int swapSlot = hotbarSlot;
        InventoryUtils.tryClearCursor(gui);
        InventoryUtils.tryMergeItems(gui, (Integer)range.left(), (Integer)range.right() - 1);
        if (Configs.Generic.SORT_ASSUME_EMPTY_BOX_STACKS.getBooleanValue()) {
            ServerboundClientCommandPacket packet = new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS);
            mc.getConnection().send((Packet)packet);
            selectedSlotUpdateTask = () -> InventoryUtils.lambda$sortInventory$0(gui, (Pair)range, shulkerBoxFix, swapSlot);
        } else {
            InventoryUtils.trySort(gui, (Integer)range.first(), (Integer)range.second(), shulkerBoxFix, swapSlot);
        }
    }

    private static void trySort(AbstractContainerScreen<?> gui, int start, int end, boolean shulkerBoxFix, int swapSlot) {
        try {
            InventoryUtils.quickSort(gui, start, end, shulkerBoxFix, swapSlot);
        }
        catch (Exception err) {
            ItemScroller.LOGGER.error("trySort(): failed to sort items", (Throwable)err);
        }
    }

    private static void quickSort(AbstractContainerScreen<?> gui, int start, int end, boolean shulkerBoxFix, int swapSlot) {
        int ct = end - start;
        AbstractContainerMenu handler = gui.getMenu();
        ArrayList<Pair> snapshot = new ArrayList<Pair>(IntStream.range(0, end - start).mapToObj(ix -> Pair.of((Object)ix, (Object)handler.getSlot(start + ix).getItem().copy())).filter(pair -> !shulkerBoxFix || !InventoryUtils.isShulkerBox((ItemStack)pair.value())).toList());
        ct = snapshot.size();
        int[] slotindex_by_arrayindex = snapshot.stream().mapToInt(pair -> start + (Integer)pair.key()).toArray();
        List sorted_pairs = snapshot.stream().sorted((left, right) -> InventoryUtils.compareStacks((ItemStack)left.value(), (ItemStack)right.value())).toList();
        ItemScroller.LOGGER.debug(String.format("======\nsort\n%s\n\n", IntStream.range(0, ct).mapToObj(ix -> String.format("%2d: %2d/%-20s  %2d/%-20s", ix, ((Pair)snapshot.get(ix)).key(), ((ItemStack)((Pair)snapshot.get(ix)).value()).getHoverName().getString(), ((Pair)sorted_pairs.get(ix)).key(), ((ItemStack)((Pair)sorted_pairs.get(ix)).value()).getHoverName().getString())).collect(Collectors.joining("\n"))));
        Map<Integer, Integer> finalpos_by_id = IntStream.range(0, ct).boxed().collect(Collectors.toMap(ix -> (Integer)((Pair)sorted_pairs.get((int)ix)).key(), ix -> ix));
        int limit = 0;
        int max_limit = 200;
        Pair hold = null;
        for (int src_ix = 0; src_ix < ct; ++src_ix) {
            Pair src = snapshot.get(src_ix);
            int src_id = (Integer)src.key();
            int dst_ix = finalpos_by_id.get(src_id);
            Pair dst = snapshot.get(dst_ix);
            if (src_ix == dst_ix) {
                ItemScroller.LOGGER.debug("quickSort(): {} ok", (Object)src_ix);
                continue;
            }
            snapshot.set(src_ix, hold);
            hold = src;
            ItemScroller.LOGGER.debug("quickSort(): pick up {}; holding {}", (Object)src_ix, (Object)hold);
            InventoryUtils.clickSlot(gui, slotindex_by_arrayindex[src_ix], swapSlot, ClickType.SWAP);
            for (limit = 0; limit < max_limit; ++limit) {
                snapshot.set(dst_ix, hold);
                hold = dst;
                InventoryUtils.clickSlot(gui, slotindex_by_arrayindex[dst_ix], swapSlot, ClickType.SWAP);
                ItemScroller.LOGGER.debug("quickSort(): ... swap {} {}; holding {}", (Object)dst_ix, dst != null ? dst.value() : "null", (Object)hold);
                if (hold == null) break;
                dst_ix = finalpos_by_id.get(hold.key());
                dst = snapshot.get(dst_ix);
            }
            if (limit != max_limit) continue;
            ItemScroller.LOGGER.warn("quickSort(): took too long to follow swap chain ??");
        }
        if (hold != null) {
            ItemScroller.LOGGER.warn("quickSort(): sorting complete, but still holding {} ??", hold);
        }
    }

    private static int compareStacks(ItemStack stack1, ItemStack stack2) {
        boolean stack2IsEmpty;
        Minecraft mc = GameWrap.getClient();
        stack1 = stack1 != null ? stack1 : ItemStack.EMPTY;
        stack2 = stack2 != null ? stack2 : ItemStack.EMPTY;
        boolean stack1IsBox = InventoryUtils.isShulkerBox(stack1);
        boolean stack2IsBox = InventoryUtils.isShulkerBox(stack2);
        if (Configs.Generic.SORT_SHULKER_BOXES_AT_END.getBooleanValue() && stack1IsBox != stack2IsBox) {
            return Boolean.compare(stack1IsBox, stack2IsBox);
        }
        boolean stack1IsBundle = InventoryUtils.isBundle(stack1);
        boolean stack2IsBundle = InventoryUtils.isBundle(stack2);
        if (Configs.Generic.SORT_BUNDLES_AT_END.getBooleanValue() && stack1IsBundle != stack2IsBundle) {
            return Boolean.compare(stack1IsBundle, stack2IsBundle);
        }
        int priority1 = InventoryUtils.getCustomPriority(stack1);
        int priority2 = InventoryUtils.getCustomPriority(stack2);
        if (priority1 != -1 || priority2 != -1) {
            return Integer.compare(priority1, priority2);
        }
        boolean stack1IsEmpty = stack1.isEmpty();
        if (stack1IsEmpty != (stack2IsEmpty = stack2.isEmpty())) {
            return Boolean.compare(stack1IsEmpty, stack2IsEmpty);
        }
        if (stack1IsEmpty) {
            return 0;
        }
        if (stack1IsBox && stack2IsBox) {
            List contents1 = ((ItemContainerContents)stack1.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).nonEmptyStream().toList();
            List contents2 = ((ItemContainerContents)stack2.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).nonEmptyStream().toList();
            int flip = Configs.Generic.SORT_SHULKER_BOXES_INVERTED.getBooleanValue() ? -1 : 1;
            return Integer.compare(contents1.size(), contents2.size()) * flip;
        }
        if (stack1IsBundle && stack2IsBundle) {
            BundleContents bundle1 = (BundleContents)stack1.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
            BundleContents bundle2 = (BundleContents)stack2.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
            int flip = Configs.Generic.SORT_BUNDLES_INVERTED.getBooleanValue() ? -1 : 1;
            Fraction occupancy1 = bundle1.weight();
            Fraction occupancy2 = bundle2.weight();
            return occupancy1.compareTo(occupancy2) * flip;
        }
        SortingMethod method = (SortingMethod)Configs.Generic.SORT_METHOD_DEFAULT.getOptionListValue();
        if (method.equals((Object)SortingMethod.CATEGORY_NAME) || method.equals((Object)SortingMethod.CATEGORY_COUNT) || method.equals((Object)SortingMethod.CATEGORY_RARITY) || method.equals((Object)SortingMethod.CATEGORY_RAWID) && mc.level != null) {
            if (displayContext == null) {
                displayContext = SortingCategory.INSTANCE.buildDisplayContext(mc);
            }
            SortingCategory.Entry cat1 = SortingCategory.INSTANCE.fromItemStack(stack1);
            SortingCategory.Entry cat2 = SortingCategory.INSTANCE.fromItemStack(stack2);
            if (!cat1.getStringValue().equals(cat2.getStringValue())) {
                boolean stack2UnspecifiedCategoryPriority;
                int index1 = Configs.Generic.SORT_CATEGORY_ORDER.getEntryIndex((IConfigLockedListEntry)cat1);
                int index2 = Configs.Generic.SORT_CATEGORY_ORDER.getEntryIndex((IConfigLockedListEntry)cat2);
                boolean stack1UnspecifiedCategoryPriority = index1 == -1;
                boolean bl = stack2UnspecifiedCategoryPriority = index2 == -1;
                if (stack1UnspecifiedCategoryPriority != stack2UnspecifiedCategoryPriority) {
                    return Boolean.compare(stack1UnspecifiedCategoryPriority, stack2UnspecifiedCategoryPriority);
                }
                return Integer.compare(index1, index2);
            }
        }
        if (stack1.getItem() != stack2.getItem()) {
            if (method.equals((Object)SortingMethod.CATEGORY_NAME) || method.equals((Object)SortingMethod.ITEM_NAME)) {
                return stack1.getHoverName().getString().compareTo(stack2.getHoverName().getString());
            }
            if (method.equals((Object)SortingMethod.CATEGORY_COUNT) || method.equals((Object)SortingMethod.ITEM_COUNT)) {
                int result = Integer.compare(stack2.getCount(), stack1.getCount());
                if (result != 0) {
                    return result;
                }
                return Integer.compare(BuiltInRegistries.ITEM.getId((Object)stack1.getItem()), BuiltInRegistries.ITEM.getId((Object)stack2.getItem()));
            }
            if (method.equals((Object)SortingMethod.CATEGORY_RARITY) || method.equals((Object)SortingMethod.ITEM_RARITY)) {
                int result = stack1.getRarity().compareTo((Enum)stack2.getRarity());
                if (result != 0) {
                    return result;
                }
                return Integer.compare(BuiltInRegistries.ITEM.getId((Object)stack1.getItem()), BuiltInRegistries.ITEM.getId((Object)stack2.getItem()));
            }
            return Integer.compare(BuiltInRegistries.ITEM.getId((Object)stack1.getItem()), BuiltInRegistries.ITEM.getId((Object)stack2.getItem()));
        }
        if (!InventoryUtils.areStacksEqual(stack1, stack2)) {
            return Integer.compare(stack1.getComponents().hashCode(), stack2.getComponents().hashCode());
        }
        return Integer.compare(stack2.getCount(), stack1.getCount());
    }

    private static int getCustomPriority(ItemStack stack) {
        int nameBottomPriority;
        String itemName;
        if (stack == null || stack.isEmpty()) {
            return -1;
        }
        String itemID = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        if (itemID.equals(itemName = stack.getHoverName().getString())) {
            itemName = null;
        }
        int idTopPriority = topSortingPriorityList.indexOf(itemID);
        int nameTopPriority = itemName != null ? topSortingPriorityList.indexOf(itemName) : -1;
        int idBottomPriority = bottomSortingPriorityList.indexOf(itemID);
        int n = nameBottomPriority = itemName != null ? bottomSortingPriorityList.indexOf(itemName) : -1;
        if (nameTopPriority != -1) {
            return -topSortingPriorityList.size() + nameTopPriority - 2;
        }
        if (idTopPriority != -1) {
            return -topSortingPriorityList.size() + idTopPriority - 2;
        }
        if (nameBottomPriority != -1) {
            return bottomSortingPriorityList.size() + nameBottomPriority;
        }
        if (idBottomPriority != -1) {
            return bottomSortingPriorityList.size() + idBottomPriority;
        }
        return -1;
    }

    public static boolean onPong(ClientboundAwardStatsPacket packet) {
        if (selectedSlotUpdateTask != null) {
            selectedSlotUpdateTask.run();
            selectedSlotUpdateTask = null;
            return true;
        }
        return false;
    }

    public static boolean isShulkerBox(ItemStack stack) {
        BlockItem bi;
        Item item = stack.getItem();
        return item instanceof BlockItem && (bi = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock;
    }

    private static boolean isEmptyShulkerBox(ItemStack stack) {
        return InventoryUtils.isShulkerBox(stack) && ((ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).nonEmptyStream().findAny().isEmpty();
    }

    private static boolean isBundle(ItemStack stack) {
        return stack.is(Items.BUNDLE) || stack.getComponents().has(DataComponents.BUNDLE_CONTENTS);
    }

    private static boolean isEmptyBundle(ItemStack stack) {
        return InventoryUtils.isBundle(stack) && fi.dy.masa.malilib.util.InventoryUtils.bundleCountItems((ItemStack)stack) < 1;
    }

    public static int stackMaxSize(ItemStack stack, boolean assumeShulkerStacking) {
        if (stack.isEmpty()) {
            return 64;
        }
        if (assumeShulkerStacking && Configs.Generic.SORT_ASSUME_EMPTY_BOX_STACKS.getBooleanValue() && InventoryUtils.isEmptyShulkerBox(stack)) {
            return 64;
        }
        return (Integer)stack.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)1);
    }

    private static boolean addStackTo(AbstractContainerScreen<? extends AbstractContainerMenu> gui, Slot slot, Slot target) {
        if (slot == null || target == null) {
            return false;
        }
        ItemStack stack = slot.getItem();
        ItemStack targetStack = target.getItem();
        if (stack.isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)targetStack)) {
            return !stack.isEmpty();
        }
        if (targetStack.isEmpty()) {
            InventoryUtils.clickSlot(gui, slot, slot.index, 0, ClickType.PICKUP);
            InventoryUtils.clickSlot(gui, target, target.index, 0, ClickType.PICKUP);
            return false;
        }
        int stackSize = stack.getCount();
        int targetSize = targetStack.getCount();
        assumeEmptyShulkerStacking = true;
        int maxSize = InventoryUtils.stackMaxSize(stack, true);
        if (targetSize >= maxSize) {
            return true;
        }
        InventoryUtils.clickSlot(gui, slot, slot.index, 0, ClickType.PICKUP);
        InventoryUtils.clickSlot(gui, target, target.index, 0, ClickType.PICKUP);
        InventoryUtils.clickSlot(gui, slot, slot.index, 0, ClickType.PICKUP);
        assumeEmptyShulkerStacking = false;
        int amount = stackSize + targetSize - maxSize;
        return amount > 0;
    }

    private static void tryMergeItems(AbstractContainerScreen<?> gui, int left, int right) {
        HashMap<ItemType, Integer> nonFullStacks = new HashMap<ItemType, Integer>();
        for (int i = left; i <= right; ++i) {
            ItemStack stack;
            Slot slot = gui.getMenu().getSlot(i);
            if (!slot.hasItem() || (stack = slot.getItem()).getCount() >= InventoryUtils.stackMaxSize(stack, true)) continue;
            ItemType key = new ItemType(stack);
            int slotNum = nonFullStacks.getOrDefault(key, -1);
            if (slotNum == -1) {
                nonFullStacks.put(key, i);
                continue;
            }
            if (!InventoryUtils.addStackTo(gui, slot, gui.getMenu().getSlot(slotNum))) continue;
            nonFullStacks.put(key, i);
        }
    }

    public static void clickSlot(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int slotNum, int mouseButton, ClickType type) {
        if (slotNum >= 0 && slotNum < gui.getMenu().slots.size()) {
            Slot slot = gui.getMenu().getSlot(slotNum);
            InventoryUtils.clickSlot(gui, slot, slotNum, mouseButton, type);
        } else {
            try {
                Minecraft mc = Minecraft.getInstance();
                mc.gameMode.handleInventoryMouseClick(gui.getMenu().containerId, slotNum, mouseButton, type, (Player)mc.player);
            }
            catch (Exception e) {
                ItemScroller.LOGGER.warn("Exception while emulating a slot click: gui: '{}', slotNum: {}, mouseButton; {}, SlotActionType: {}", (Object)gui.getClass().getName(), (Object)slotNum, (Object)mouseButton, (Object)type, (Object)e);
            }
        }
    }

    public static void clickSlot(AbstractContainerScreen<? extends AbstractContainerMenu> gui, Slot slot, int slotNum, int mouseButton, ClickType type) {
        try {
            AccessorUtils.handleMouseClick(gui, slot, slotNum, mouseButton, type);
        }
        catch (Exception e) {
            ItemScroller.LOGGER.warn("Exception while emulating a slot click: gui: '{}', slotNum: {}, mouseButton; {}, SlotActionType: {}", (Object)gui.getClass().getName(), (Object)slotNum, (Object)mouseButton, (Object)type, (Object)e);
        }
    }

    public static void leftClickSlot(AbstractContainerScreen<? extends AbstractContainerMenu> gui, Slot slot, int slotNumber) {
        InventoryUtils.clickSlot(gui, slot, slotNumber, 0, ClickType.PICKUP);
    }

    public static void rightClickSlot(AbstractContainerScreen<? extends AbstractContainerMenu> gui, Slot slot, int slotNumber) {
        InventoryUtils.clickSlot(gui, slot, slotNumber, 1, ClickType.PICKUP);
    }

    public static void shiftClickSlot(AbstractContainerScreen<? extends AbstractContainerMenu> gui, Slot slot, int slotNumber) {
        InventoryUtils.clickSlot(gui, slot, slotNumber, 0, ClickType.QUICK_MOVE);
    }

    public static void leftClickSlot(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 0, ClickType.PICKUP);
    }

    public static void rightClickSlot(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 1, ClickType.PICKUP);
    }

    public static void shiftClickSlot(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 0, ClickType.QUICK_MOVE);
    }

    public static void dropItemsFromCursor(AbstractContainerScreen<? extends AbstractContainerMenu> gui) {
        InventoryUtils.clickSlot(gui, -999, 0, ClickType.PICKUP);
    }

    public static void dropItem(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 0, ClickType.THROW);
    }

    public static void dropStack(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 1, ClickType.THROW);
    }

    public static void swapSlots(AbstractContainerScreen<? extends AbstractContainerMenu> gui, int slotNum, int otherSlot) {
        InventoryUtils.clickSlot(gui, slotNum, 8, ClickType.SWAP);
        InventoryUtils.clickSlot(gui, otherSlot, 8, ClickType.SWAP);
        InventoryUtils.clickSlot(gui, slotNum, 8, ClickType.SWAP);
    }

    private static void dragSplitItemsIntoSlots(AbstractContainerScreen<? extends AbstractContainerMenu> gui, IntArrayList targetSlots) {
        int slotNum;
        ItemStack stackInCursor = gui.getMenu().getCarried();
        if (InventoryUtils.isStackEmpty(stackInCursor)) {
            return;
        }
        if (targetSlots.size() == 1) {
            InventoryUtils.leftClickSlot(gui, targetSlots.getInt(0));
            return;
        }
        int numSlots = gui.getMenu().slots.size();
        InventoryUtils.clickSlot(gui, -999, 0, ClickType.QUICK_CRAFT);
        IntListIterator intListIterator = targetSlots.iterator();
        while (intListIterator.hasNext() && (slotNum = ((Integer)intListIterator.next()).intValue()) < numSlots) {
            InventoryUtils.clickSlot(gui, slotNum, 1, ClickType.QUICK_CRAFT);
        }
        InventoryUtils.clickSlot(gui, -999, 2, ClickType.QUICK_CRAFT);
    }

    public static boolean isStackEmpty(ItemStack stack) {
        return stack.isEmpty();
    }

    public static int getStackSize(ItemStack stack) {
        return stack.getCount();
    }

    public static void setStackSize(ItemStack stack, int size) {
        stack.setCount(size);
    }

    public static ItemStack copyStack(ItemStack stack, boolean empty) {
        if (empty) {
            return stack.copyAndClear();
        }
        return stack.copy();
    }

    private static /* synthetic */ void lambda$sortInventory$0(AbstractContainerScreen gui, Pair range, boolean shulkerBoxFix, int swapSlot) {
        InventoryUtils.trySort(gui, (Integer)range.first(), (Integer)range.second(), shulkerBoxFix, swapSlot);
    }

    static {
        sourceSlotCandidate = null;
        sourceSlot = null;
        stackInCursorLast = ItemStack.EMPTY;
        activeMoveAction = MoveAction.NONE;
        assumeEmptyShulkerStacking = false;
        topSortingPriorityList = Configs.Generic.SORT_TOP_PRIORITY_INVENTORY.getStrings();
        bottomSortingPriorityList = Configs.Generic.SORT_BOTTOM_PRIORITY_INVENTORY.getStrings();
        bufferInvUpdates = false;
        invUpdatesBuffer = new ArrayList<Packet<ClientGamePacketListener>>();
        ignoreScrollingInsideOfBundles = false;
        EMPTY_STACK = ItemStack.EMPTY;
    }

    private static class SlotVerticalSorterSlotNumbers
    implements IntComparator {
        private final AbstractContainerMenu container;
        private final boolean topToBottom;

        public SlotVerticalSorterSlotNumbers(AbstractContainerMenu container, boolean topToBottom) {
            this.container = container;
            this.topToBottom = topToBottom;
        }

        public int compare(int slotNum1, int slotNum2) {
            if (Objects.equals(slotNum1, slotNum2)) {
                return 0;
            }
            Slot slot1 = this.container.getSlot(slotNum1);
            Slot slot2 = this.container.getSlot(slotNum2);
            if (slot1.y == slot2.y) {
                return slot1.index < slot2.index == this.topToBottom ? -1 : 1;
            }
            return slot1.y < slot2.y == this.topToBottom ? -1 : 1;
        }
    }
}

