/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.util;

import fi.dy.masa.itemscroller.util.InventoryUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;

public record ItemType(ItemStack stack) {
    public ItemType(@Nonnull ItemStack stack) {
        this.stack = stack.isEmpty() ? InventoryUtils.EMPTY_STACK : InventoryUtils.copyStack(stack, false);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.stack.getItem().hashCode();
        result = 31 * result + (this.stack.getComponents() != null ? this.stack.getComponents().hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemType other = (ItemType)obj;
        return ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)other.stack);
    }

    public static Map<ItemType, IntArrayList> getSlotsPerItem(ItemStack[] stacks) {
        HashMap<ItemType, IntArrayList> mapSlots = new HashMap<ItemType, IntArrayList>();
        for (int i = 0; i < stacks.length; ++i) {
            ItemStack stack = stacks[i];
            if (InventoryUtils.isStackEmpty(stack)) continue;
            ItemType item = new ItemType(stack);
            IntArrayList slots = mapSlots.computeIfAbsent(item, k -> new IntArrayList());
            slots.add(i);
        }
        return mapSlots;
    }
}

