/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.util;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigLockedListEntry;
import fi.dy.masa.malilib.config.IConfigLockedListType;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;

public class SortingCategory
implements IConfigLockedListType {
    public static final SortingCategory INSTANCE = new SortingCategory();
    public ImmutableList<Entry> VALUES = ImmutableList.copyOf((Object[])Entry.values());

    @Nullable
    public CreativeModeTab.ItemDisplayParameters buildDisplayContext(Minecraft mc) {
        if (mc.level == null) {
            return null;
        }
        CreativeModeTab.ItemDisplayParameters ctx = new CreativeModeTab.ItemDisplayParameters(mc.level.enabledFeatures(), true, (HolderLookup.Provider)mc.level.registryAccess());
        BuiltInRegistries.CREATIVE_MODE_TAB.stream().filter(group -> group.getType() == CreativeModeTab.Type.CATEGORY).forEach(group -> group.buildContents(ctx));
        return ctx;
    }

    public Entry fromItemStack(ItemStack stack) {
        for (int i = 0; i < BuiltInRegistries.CREATIVE_MODE_TAB.size(); ++i) {
            Iterator iter;
            Collection stacks;
            CreativeModeTab itemGroup = (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.byId(i);
            if (itemGroup == null || !itemGroup.getType().equals((Object)CreativeModeTab.Type.CATEGORY)) continue;
            if (itemGroup.hasAnyItems()) {
                stacks = itemGroup.getDisplayItems();
                iter = stacks.iterator();
                while (iter.hasNext()) {
                    if (!ItemStack.isSameItem((ItemStack)((ItemStack)iter.next()), (ItemStack)stack)) continue;
                    return this.fromItemGroup(itemGroup);
                }
            }
            stacks = itemGroup.getSearchTabDisplayItems();
            iter = stacks.iterator();
            while (iter.hasNext()) {
                if (!ItemStack.isSameItem((ItemStack)((ItemStack)iter.next()), (ItemStack)stack)) continue;
                return this.fromItemGroup(itemGroup);
            }
        }
        return Entry.OTHER;
    }

    @Nullable
    public Entry fromItemGroup(CreativeModeTab group) {
        ResourceLocation id = BuiltInRegistries.CREATIVE_MODE_TAB.getKey((Object)group);
        if (id != null) {
            return Entry.fromString(id.getPath());
        }
        return Entry.OTHER;
    }

    public ImmutableList<IConfigLockedListEntry> getDefaultEntries() {
        ImmutableList.Builder list = ImmutableList.builder();
        this.VALUES.forEach(arg_0 -> ((ImmutableList.Builder)list).add(arg_0));
        return list.build();
    }

    @Nullable
    public IConfigLockedListEntry fromString(String string) {
        return Entry.fromString(string);
    }

    public static enum Entry implements IConfigLockedListEntry,
    StringRepresentable
    {
        BUILDING_BLOCKS("building_blocks", "building_blocks"),
        COLORED_BLOCKS("colored_blocks", "colored_blocks"),
        NATURAL("natural_blocks", "natural_blocks"),
        FUNCTIONAL("functional_blocks", "functional_blocks"),
        REDSTONE("redstone_blocks", "redstone_blocks"),
        TOOLS("tools_and_utilities", "tools_and_utilities"),
        COMBAT("combat", "combat"),
        FOOD_AND_DRINK("food_and_drinks", "food_and_drinks"),
        INGREDIENTS("ingredients", "ingredients"),
        SPAWN_EGGS("spawn_eggs", "spawn_eggs"),
        OPERATOR("op_blocks", "op_blocks"),
        OTHER("other", "other");

        public static final StringRepresentable.EnumCodec<Entry> CODEC;
        public static final ImmutableList<Entry> VALUES;
        private final String configKey;
        private final String translationKey;

        private Entry(String configKey, String translationKey) {
            this.configKey = configKey;
            this.translationKey = "itemscroller.gui.label.sorting_category." + translationKey;
        }

        public String getSerializedName() {
            return this.configKey;
        }

        public String getStringValue() {
            return this.configKey;
        }

        public String getDisplayName() {
            return StringUtils.getTranslatedOrFallback((String)this.translationKey, (String)this.configKey);
        }

        @Nullable
        public static Entry fromString(String key) {
            for (Entry entry : Entry.values()) {
                if (entry.configKey.equalsIgnoreCase(key)) {
                    return entry;
                }
                if (entry.translationKey.equalsIgnoreCase(key)) {
                    return entry;
                }
                if (!StringUtils.hasTranslation((String)entry.translationKey) || !StringUtils.translate((String)entry.translationKey, (Object[])new Object[0]).equalsIgnoreCase(key)) continue;
                return entry;
            }
            return null;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Entry::values);
            VALUES = ImmutableList.copyOf((Object[])Entry.values());
        }
    }
}

