/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.util;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;
import net.minecraft.util.StringRepresentable;

public enum SortingMethod implements IConfigOptionListEntry,
StringRepresentable
{
    CATEGORY_NAME("category_name", "category_name"),
    CATEGORY_COUNT("category_count", "category_count"),
    CATEGORY_RARITY("category_rarity", "category_rarity"),
    CATEGORY_RAWID("category_rawid", "category_rawid"),
    ITEM_NAME("item_name", "item_name"),
    ITEM_COUNT("item_count", "item_count"),
    ITEM_RARITY("item_rarity", "item_rarity"),
    ITEM_RAWID("item_rawid", "item_rawid");

    public static final StringRepresentable.EnumCodec<SortingMethod> CODEC;
    public static final ImmutableList<SortingMethod> VALUES;
    private final String configString;
    private final String translationKey;

    private SortingMethod(String configString, String translationKey) {
        this.configString = configString;
        this.translationKey = "itemscroller.gui.label.sorting_method." + translationKey;
    }

    public String getSerializedName() {
        return this.configString;
    }

    public String getStringValue() {
        return this.configString;
    }

    public String getDisplayName() {
        return StringUtils.getTranslatedOrFallback((String)this.translationKey, (String)this.configString);
    }

    public IConfigOptionListEntry cycle(boolean forward) {
        int id = this.ordinal();
        if (forward) {
            if (++id >= SortingMethod.values().length) {
                id = 0;
            }
        } else if (--id < 0) {
            id = SortingMethod.values().length - 1;
        }
        return SortingMethod.values()[id % SortingMethod.values().length];
    }

    public SortingMethod fromString(String value) {
        return SortingMethod.fromStringStatic(value);
    }

    public static SortingMethod fromStringStatic(String name) {
        for (SortingMethod val : VALUES) {
            if (!val.configString.equalsIgnoreCase(name)) continue;
            return val;
        }
        return CATEGORY_NAME;
    }

    static {
        CODEC = StringRepresentable.fromEnum(SortingMethod::values);
        VALUES = ImmutableList.copyOf((Object[])SortingMethod.values());
    }
}

