/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.villager;

import fi.dy.masa.itemscroller.villager.FavoriteData;
import fi.dy.masa.itemscroller.villager.IMerchantScreenHandler;
import fi.dy.masa.itemscroller.villager.TradeType;
import fi.dy.masa.itemscroller.villager.VillagerDataStorage;
import fi.dy.masa.malilib.util.GuiUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;

public class VillagerUtils {
    public static boolean switchToTradeByVisibleIndex(int visibleIndex) {
        MerchantScreen merchantScreen;
        MerchantMenu handler;
        int realIndex;
        Screen screen = GuiUtils.getCurrentScreen();
        if (screen instanceof MerchantScreen && (realIndex = VillagerUtils.getRealTradeIndexFor(visibleIndex, handler = (MerchantMenu)(merchantScreen = (MerchantScreen)screen).getMenu())) >= 0) {
            handler.setSelectionHint(realIndex);
            handler.tryMoveItems(visibleIndex);
            Minecraft.getInstance().getConnection().send((Packet)new ServerboundSelectTradePacket(realIndex));
            return true;
        }
        return false;
    }

    public static int getRealTradeIndexFor(int visibleIndex, MerchantMenu handler) {
        if (handler instanceof IMerchantScreenHandler) {
            int realIndex;
            MerchantOffer trade;
            MerchantOffers originalList = ((IMerchantScreenHandler)handler).itemscroller$getOriginalList();
            MerchantOffers customList = handler.getOffers();
            if (originalList != null && customList != null && visibleIndex >= 0 && visibleIndex < customList.size() && (trade = (MerchantOffer)customList.get(visibleIndex)) != null && (realIndex = originalList.indexOf((Object)trade)) >= 0 && realIndex < originalList.size()) {
                return realIndex;
            }
        }
        return -1;
    }

    public static MerchantOffers buildCustomTradeList(MerchantOffers originalList) {
        FavoriteData data = VillagerDataStorage.getInstance().getFavoritesForCurrentVillager(originalList);
        IntArrayList favorites = data.favorites;
        if (!favorites.isEmpty()) {
            MerchantOffers list = new MerchantOffers();
            int originalListSize = originalList.size();
            IntListIterator intListIterator = favorites.iterator();
            while (intListIterator.hasNext()) {
                int index = (Integer)intListIterator.next();
                if (index < 0 || index >= originalListSize) continue;
                list.add((Object)((MerchantOffer)originalList.get(index)));
            }
            for (int i = 0; i < originalListSize; ++i) {
                if (favorites.contains(i)) continue;
                list.add((Object)((MerchantOffer)originalList.get(i)));
            }
            return list;
        }
        return originalList;
    }

    public static IntArrayList getGlobalFavoritesFor(MerchantOffers originalTrades, Collection<TradeType> globalFavorites) {
        IntArrayList favorites = new IntArrayList();
        HashMap<TradeType, Integer> trades = new HashMap<TradeType, Integer>();
        int size = originalTrades.size();
        for (int i = 0; i < size; ++i) {
            MerchantOffer trade = (MerchantOffer)originalTrades.get(i);
            trades.put(TradeType.of(trade), i);
        }
        for (TradeType type : globalFavorites) {
            Integer index = (Integer)trades.get(type);
            if (index == null) continue;
            favorites.add(index.intValue());
        }
        return favorites;
    }
}

