/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats.runtime;

import com.zigythebird.playeranim.lib.mochafloats.parser.ast.AccessExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.ArrayAccessExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.BinaryExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.CallExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.ExecutionScopeExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.Expression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.ExpressionVisitor;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.FloatExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.IdentifierExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.StatementExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.StringExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.TernaryConditionalExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.UnaryExpression;
import com.zigythebird.playeranim.lib.mochafloats.runtime.ExecutionContext;
import com.zigythebird.playeranim.lib.mochafloats.runtime.Scope;
import com.zigythebird.playeranim.lib.mochafloats.runtime.binding.JavaFunction;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.ArrayValue;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.Function;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.JavaValue;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.MutableObjectBinding;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.NumberValue;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.ObjectValue;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.StringValue;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.Value;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ExpressionInterpreter<T>
implements ExpressionVisitor<Value>,
ExecutionContext<T> {
    private static final List<Evaluator> BINARY_EVALUATORS = Arrays.asList(ExpressionInterpreter.bool((a, b) -> a.eval() && b.eval()), ExpressionInterpreter.bool((a, b) -> a.eval() || b.eval()), ExpressionInterpreter.compare((a, b) -> a.eval() < b.eval()), ExpressionInterpreter.compare((a, b) -> a.eval() <= b.eval()), ExpressionInterpreter.compare((a, b) -> a.eval() > b.eval()), ExpressionInterpreter.compare((a, b) -> a.eval() >= b.eval()), (evaluator, a, b) -> {
        Value aVal = a.visit(evaluator);
        Value bVal = b.visit(evaluator);
        return NumberValue.of(aVal.getAsNumber() + bVal.getAsNumber());
    }, ExpressionInterpreter.arithmetic((a, b) -> a.eval() - b.eval()), ExpressionInterpreter.arithmetic((a, b) -> a.eval() * b.eval()), ExpressionInterpreter.arithmetic((a, b) -> {
        float dividend = a.eval();
        float divisor = b.eval();
        if (divisor == 0.0f) {
            return 0.0f;
        }
        return dividend / divisor;
    }), (evaluator, a, b) -> {
        Value val = a.visit(evaluator);
        if (!(val instanceof JavaValue)) {
            return NumberValue.zero();
        }
        return b.visit(evaluator.createChild(((JavaValue)val).value()));
    }, (evaluator, a, b) -> {
        Value val = a.visit(evaluator);
        if (val.getAsBoolean()) {
            return val;
        }
        return b.visit(evaluator);
    }, (evaluator, a, b) -> {
        AccessExpression access;
        Value objectValue;
        Value val = b.visit(evaluator);
        if (a instanceof AccessExpression && (objectValue = (access = (AccessExpression)a).object().visit(evaluator)) instanceof MutableObjectBinding) {
            ((MutableObjectBinding)objectValue).set(access.property(), val);
        }
        return val;
    }, (evaluator, a, b) -> {
        Value conditionValue = a.visit(evaluator);
        if (conditionValue.getAsBoolean()) {
            Value predicateVal = b.visit(evaluator);
            if (predicateVal instanceof Function) {
                return Value.of(((Function)predicateVal).evaluate(evaluator));
            }
            return predicateVal;
        }
        return NumberValue.zero();
    }, ExpressionInterpreter.arithmetic((a, b) -> a.eval() == b.eval() ? 1.0f : 0.0f), ExpressionInterpreter.arithmetic((a, b) -> a.eval() != b.eval() ? 1.0f : 0.0f));
    private final T entity;
    private final Scope scope;
    @Nullable
    private Object flag;
    @Nullable
    private Value returnValue;
    private boolean warnOnReflectiveFunctionUsage;

    public ExpressionInterpreter(@Nullable T entity, @NotNull Scope scope) {
        this.entity = entity;
        this.scope = Objects.requireNonNull(scope, "scope");
    }

    private static Evaluator bool(BooleanOperator op) {
        return (evaluator, a, b) -> Value.of(op.operate(() -> a.visit(evaluator).getAsBoolean(), () -> b.visit(evaluator).getAsBoolean()));
    }

    private static Evaluator compare(Comparator comp) {
        return (evaluator, a, b) -> Value.of(comp.compare(() -> a.visit(evaluator).getAsNumber(), () -> b.visit(evaluator).getAsNumber()));
    }

    private static Evaluator arithmetic(ArithmeticOperator op) {
        return (evaluator, a, b) -> NumberValue.of(op.operate(() -> a.visit(evaluator).getAsNumber(), () -> b.visit(evaluator).getAsNumber()));
    }

    public void warnOnReflectiveFunctionUsage(boolean warnOnReflectiveFunctionUsage) {
        this.warnOnReflectiveFunctionUsage = warnOnReflectiveFunctionUsage;
    }

    @Override
    @Nullable
    public Object flag() {
        return this.flag;
    }

    @Override
    public void flag(@Nullable Object flag) {
        this.flag = flag;
    }

    @Override
    public T entity() {
        return this.entity;
    }

    @Override
    @NotNull
    public Value eval(@NotNull Expression expression) {
        return expression.visit(this);
    }

    @NotNull
    public <R> ExpressionInterpreter<R> createChild(@Nullable R entity) {
        return new ExpressionInterpreter<R>(entity, this.scope);
    }

    @NotNull
    public ExpressionInterpreter<T> createChild() {
        return new ExpressionInterpreter<T>(this.entity, this.scope);
    }

    @NotNull
    public Scope bindings() {
        return this.scope;
    }

    @Nullable
    public Value popReturnValue() {
        Value val = this.returnValue;
        this.returnValue = null;
        return val;
    }

    @Override
    @NotNull
    public Value visitArrayAccess(@NotNull ArrayAccessExpression expression) {
        Value array = expression.array().visit(this);
        Value index = expression.index().visit(this);
        if (!(array instanceof ArrayValue)) {
            return Value.nil();
        }
        Value[] values = ((ArrayValue)array).values();
        int validIndex = Math.max(0, (int)index.getAsNumber()) % values.length;
        return values[validIndex];
    }

    @Override
    @NotNull
    public Value visitAccess(@NotNull AccessExpression expression) {
        Value objectValue = expression.object().visit(this);
        if (objectValue instanceof ObjectValue) {
            return ((ObjectValue)objectValue).get(expression.property());
        }
        return NumberValue.zero();
    }

    @Override
    @NotNull
    public Value visitCall(@NotNull CallExpression expression) {
        Value function;
        List<Expression> argumentsExpressions = expression.arguments();
        Function.Argument[] arguments = new Function.Argument[argumentsExpressions.size()];
        for (int i = 0; i < argumentsExpressions.size(); ++i) {
            arguments[i] = new FunctionArgumentImpl(argumentsExpressions.get(i));
        }
        FunctionArguments args = new FunctionArguments(arguments);
        Expression functionExpr = expression.function();
        if (functionExpr instanceof IdentifierExpression) {
            String identifierName = ((IdentifierExpression)functionExpr).name();
            if ("loop".equals(identifierName)) {
                int n = Math.round(args.next().eval().getAsNumber());
                Value expr = args.next().eval();
                if (expr instanceof Function) {
                    Function callable = (Function)expr;
                    for (int i = 0; i < n; ++i) {
                        ExpressionInterpreter<T> evaluatorThisCall = this.createChild();
                        callable.evaluate(evaluatorThisCall);
                        if (evaluatorThisCall.flag() == StatementExpression.Op.BREAK) break;
                    }
                }
                return NumberValue.zero();
            }
            if ("for_each".equals(identifierName)) {
                Expression variableExpr = args.next().expression();
                if (!(variableExpr instanceof AccessExpression)) {
                    return NumberValue.zero();
                }
                AccessExpression variableAccess = (AccessExpression)variableExpr;
                Expression objectExpr = variableAccess.object();
                String propertyName = variableAccess.property();
                Value array = args.next().eval();
                if (!(array instanceof ArrayValue)) {
                    return NumberValue.zero();
                }
                List<Value> arrayIterable = Arrays.asList(((ArrayValue)array).values());
                Value expr = args.next().eval();
                if (expr instanceof Function) {
                    Function callable = (Function)expr;
                    for (Value val : arrayIterable) {
                        Value returnValue;
                        Value evaluatedObjectValue = this.eval(objectExpr);
                        if (evaluatedObjectValue instanceof MutableObjectBinding) {
                            ((MutableObjectBinding)evaluatedObjectValue).set(propertyName, val);
                        }
                        if ((returnValue = callable.evaluate(this)) != StatementExpression.Op.BREAK) continue;
                        break;
                    }
                }
                return NumberValue.zero();
            }
        }
        if (!((function = functionExpr.visit(this)) instanceof Function)) {
            return Value.nil();
        }
        if (this.warnOnReflectiveFunctionUsage && function instanceof JavaFunction) {
            JavaFunction javaFunction = (JavaFunction)function;
            System.err.println("Warning: Reflective function usage detected for method: " + String.valueOf(javaFunction.method()));
        }
        return ((Function)function).evaluate(this, args);
    }

    @Override
    @NotNull
    public Value visitFloat(@NotNull FloatExpression expression) {
        return NumberValue.of(expression.value());
    }

    @Override
    @NotNull
    public Value visitExecutionScope(@NotNull ExecutionScopeExpression executionScope) {
        List<Expression> expressions = executionScope.expressions();
        return (context, arguments) -> {
            for (Expression expression : expressions) {
                context.eval(expression);
                if (context.flag() == null) continue;
                break;
            }
            return NumberValue.zero();
        };
    }

    @Override
    @NotNull
    public Value visitIdentifier(@NotNull IdentifierExpression expression) {
        return this.scope.get(expression.name());
    }

    @Override
    @NotNull
    public Value visitBinary(@NotNull BinaryExpression expression) {
        return BINARY_EVALUATORS.get(expression.op().ordinal()).eval(this, expression.left(), expression.right());
    }

    @Override
    @NotNull
    public Value visitUnary(@NotNull UnaryExpression expression) {
        Value value = expression.expression().visit(this);
        switch (expression.op()) {
            case LOGICAL_NEGATION: {
                return Value.of(!value.getAsBoolean());
            }
            case ARITHMETICAL_NEGATION: {
                return NumberValue.of(-value.getAsNumber());
            }
            case RETURN: {
                this.returnValue = value;
                return NumberValue.zero();
            }
        }
        throw new IllegalStateException("Unknown operation");
    }

    @Override
    @NotNull
    public Value visitStatement(@NotNull StatementExpression expression) {
        switch (expression.op()) {
            case BREAK: {
                this.flag = StatementExpression.Op.BREAK;
                break;
            }
            case CONTINUE: {
                this.flag = StatementExpression.Op.CONTINUE;
            }
        }
        return NumberValue.zero();
    }

    @Override
    @NotNull
    public Value visitString(@NotNull StringExpression expression) {
        return StringValue.of(expression.value());
    }

    @Override
    @NotNull
    public Value visitTernaryConditional(@NotNull TernaryConditionalExpression expression) {
        Value conditionResult = expression.condition().visit(this);
        return conditionResult.getAsBoolean() ? expression.trueExpression().visit(this) : expression.falseExpression().visit(this);
    }

    @Override
    public Value visit(@NotNull Expression expression) {
        throw new UnsupportedOperationException("Unsupported expression type: " + String.valueOf(expression));
    }

    private static interface BooleanOperator {
        public boolean operate(LazyEvaluableBoolean var1, LazyEvaluableBoolean var2);
    }

    private static interface Evaluator {
        @NotNull
        public Value eval(ExpressionInterpreter<?> var1, Expression var2, Expression var3);
    }

    private static interface Comparator {
        public boolean compare(LazyEvaluableFloat var1, LazyEvaluableFloat var2);
    }

    private static interface ArithmeticOperator {
        public float operate(LazyEvaluableFloat var1, LazyEvaluableFloat var2);
    }

    private class FunctionArgumentImpl
    implements Function.Argument {
        private final Expression expression;

        FunctionArgumentImpl(Expression expression) {
            this.expression = expression;
        }

        @Override
        @NotNull
        public Expression expression() {
            return this.expression;
        }

        @Override
        @Nullable
        public Value eval() {
            return this.expression.visit(ExpressionInterpreter.this);
        }
    }

    public static class FunctionArguments
    implements Function.Arguments {
        public static final Function.Arguments EMPTY = new FunctionArguments(new Function.Argument[0]);
        private final Function.Argument[] arguments;
        private int next;

        FunctionArguments(@NotNull @NotNull Function.Argument @NotNull [] arguments) {
            this.arguments = Objects.requireNonNull(arguments, "arguments");
        }

        @Override
        public @NotNull Function.Argument next() {
            if (this.next < this.arguments.length) {
                return this.arguments[this.next++];
            }
            return EmptyFunctionArgument.EMPTY;
        }

        @Override
        public int length() {
            return this.arguments.length;
        }
    }

    static interface LazyEvaluableFloat {
        public float eval();
    }

    static interface LazyEvaluableBoolean {
        public boolean eval();
    }

    private static class EmptyFunctionArgument
    implements Function.Argument {
        static final Function.Argument EMPTY = new EmptyFunctionArgument();

        private EmptyFunctionArgument() {
        }

        @Override
        @Nullable
        public Expression expression() {
            return null;
        }

        @Override
        @Nullable
        public Value eval() {
            return NumberValue.zero();
        }
    }
}

