/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats.runtime;

import com.zigythebird.playeranim.lib.mochafloats.parser.ast.AccessExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.ArrayAccessExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.BinaryExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.CallExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.ExecutionScopeExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.Expression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.ExpressionVisitor;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.FloatExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.IdentifierExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.StatementExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.StringExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.TernaryConditionalExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.UnaryExpression;
import com.zigythebird.playeranim.lib.mochafloats.runtime.ExpressionInterpreter;
import com.zigythebird.playeranim.lib.mochafloats.runtime.Scope;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.Function;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.ObjectProperty;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.ObjectValue;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IsConstantExpression
implements ExpressionVisitor<Boolean> {
    private static final ExpressionVisitor<Boolean> INSTANCE = new IsConstantExpression(null);
    private final ExpressionInterpreter<?> evaluator;
    private final ObjectValue scope;

    private IsConstantExpression(@Nullable Scope scope) {
        this.evaluator = scope == null ? null : new ExpressionInterpreter<Object>(null, scope);
        this.scope = scope;
    }

    public static boolean test(@NotNull Expression expression) {
        return expression.visit(INSTANCE);
    }

    public static boolean test(@NotNull Expression expression, @NotNull Scope scope) {
        return expression.visit(new IsConstantExpression(scope));
    }

    @Override
    @NotNull
    public Boolean visitArrayAccess(@NotNull ArrayAccessExpression expression) {
        return expression.array().visit(this) != false && expression.index().visit(this) != false;
    }

    @Override
    @NotNull
    public Boolean visitFloat(@NotNull FloatExpression expression) {
        return true;
    }

    @Override
    @NotNull
    public Boolean visitString(@NotNull StringExpression expression) {
        return true;
    }

    @Override
    @NotNull
    public Boolean visitIdentifier(@NotNull IdentifierExpression expression) {
        if (this.scope == null) {
            return false;
        }
        ObjectProperty property = this.scope.getProperty(expression.name());
        if (property == null) {
            return false;
        }
        return property.constant();
    }

    @Override
    @NotNull
    public Boolean visitTernaryConditional(@NotNull TernaryConditionalExpression expression) {
        return expression.condition().visit(this) != false && expression.trueExpression().visit(this) != false && expression.falseExpression().visit(this) != false;
    }

    @Override
    @NotNull
    public Boolean visitUnary(@NotNull UnaryExpression expression) {
        return expression.expression().visit(this);
    }

    @Override
    @NotNull
    public Boolean visitExecutionScope(@NotNull ExecutionScopeExpression expression) {
        for (Expression expr : expression.expressions()) {
            if (expr.visit(this).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Boolean visitBinary(@NotNull BinaryExpression expression) {
        return expression.left().visit(this) != false && expression.right().visit(this) != false;
    }

    @Override
    @NotNull
    public Boolean visitAccess(@NotNull AccessExpression expression) {
        Expression objectExpr = expression.object();
        if (!objectExpr.visit(this).booleanValue()) {
            return false;
        }
        if (this.evaluator == null) {
            return false;
        }
        Value objectValue = objectExpr.visit(this.evaluator);
        if (!(objectValue instanceof ObjectValue)) {
            return true;
        }
        ObjectProperty property = ((ObjectValue)objectValue).getProperty(expression.property());
        if (property == null) {
            return false;
        }
        return property.constant();
    }

    @Override
    @NotNull
    public Boolean visitCall(@NotNull CallExpression expression) {
        String name;
        for (Expression argument : expression.arguments()) {
            if (argument.visit(this).booleanValue()) continue;
            return false;
        }
        Expression functionExpr = expression.function();
        if (functionExpr instanceof IdentifierExpression && ((name = ((IdentifierExpression)functionExpr).name()).equalsIgnoreCase("loop") || name.equalsIgnoreCase("for_each"))) {
            return true;
        }
        if (!functionExpr.visit(this).booleanValue()) {
            return false;
        }
        if (this.evaluator == null) {
            return false;
        }
        Value function = functionExpr.visit(this.evaluator);
        if (!(function instanceof Function)) {
            return true;
        }
        return ((Function)function).pure();
    }

    @Override
    @NotNull
    public Boolean visitStatement(@NotNull StatementExpression expression) {
        return true;
    }

    @Override
    @NotNull
    public Boolean visit(@NotNull Expression expression) {
        return false;
    }
}

