/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.animation;

import com.zigythebird.playeranim.animation.AvatarAnimManager;
import com.zigythebird.playeranim.animation.AvatarAnimationData;
import com.zigythebird.playeranimcore.animation.AnimationData;
import com.zigythebird.playeranimcore.animation.AnimationProcessor;
import com.zigythebird.playeranimcore.animation.layered.AnimationStack;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.phys.Vec3;

public class AvatarAnimationProcessor
extends AnimationProcessor {
    private final Avatar avatar;

    public AvatarAnimationProcessor(Avatar avatar) {
        this.avatar = avatar;
    }

    @Override
    public void tickAnimation(AnimationStack stack, AnimationData state) {
        super.tickAnimation(stack, state);
        if (stack instanceof AvatarAnimManager) {
            AvatarAnimManager avatarAnimManager = (AvatarAnimManager)stack;
            avatarAnimManager.finishFirstTick();
        }
    }

    @Override
    public void handleAnimations(float partialTick, boolean fullTick) {
        Vec3 velocity = this.avatar.getDeltaMovement();
        AvatarAnimManager animatableManager = this.avatar.playerAnimLib$getAnimManager();
        int currentTick = this.avatar.tickCount;
        float currentFrameTime = (float)currentTick + partialTick;
        AvatarAnimationData animationData = new AvatarAnimationData(this.avatar, (float)((Math.abs(velocity.x) + Math.abs(velocity.z)) / 2.0), partialTick);
        if (fullTick) {
            animatableManager.tick(((AnimationData)animationData).copy());
        }
        if (!animatableManager.isFirstTick() && currentFrameTime == animatableManager.getLastUpdateTime()) {
            return;
        }
        if (!Minecraft.getInstance().isPaused()) {
            animatableManager.updatedAt(currentFrameTime);
        }
        this.tickAnimation(animatableManager, animationData);
    }

    public Avatar getAvatar() {
        return this.avatar;
    }
}

