/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.api;

import com.zigythebird.playeranim.animation.AvatarAnimManager;
import com.zigythebird.playeranimcore.animation.layered.IAnimation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Avatar;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PlayerAnimationFactory {
    public static final FactoryHolder ANIMATION_DATA_FACTORY = new FactoryHolder();

    @Nullable
    public IAnimation invoke(@NotNull Avatar var1);

    public static class FactoryHolder {
        private static final List<Function<Avatar, DataHolder>> factories = new ArrayList<Function<Avatar, DataHolder>>();

        private FactoryHolder() {
        }

        public void registerFactory(@Nullable Identifier id, int priority, @NotNull PlayerAnimationFactory factory) {
            factories.add(player -> Optional.ofNullable(factory.invoke((Avatar)player)).map(animation -> new DataHolder(id, priority, (IAnimation)animation)).orElse(null));
        }

        @ApiStatus.Internal
        public void prepareAnimations(Avatar player, AvatarAnimManager playerStack, Map<Identifier, IAnimation> animationMap) {
            for (Function<Avatar, DataHolder> factory : factories) {
                DataHolder dataHolder = factory.apply(player);
                if (dataHolder == null) continue;
                playerStack.addAnimLayer(dataHolder.priority(), dataHolder.animation());
                if (dataHolder.id() == null) continue;
                animationMap.put(dataHolder.id(), dataHolder.animation());
            }
        }

        @ApiStatus.Internal
        private record DataHolder(@Nullable Identifier id, int priority, @NotNull IAnimation animation) {
        }
    }
}

