/*
 * MIT License
 *
 * Copyright (c) 2024 GeckoLib
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.zigythebird.playeranim.molang;

import com.zigythebird.playeranim.animation.PlayerAnimationController;
import com.zigythebird.playeranimcore.animation.AnimationController;
import com.zigythebird.playeranimcore.molang.MolangLoader;
import com.zigythebird.playeranimcore.molang.QueryBinding;
import net.minecraft.class_11890;
import net.minecraft.class_11903;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5354;
import net.minecraft.class_5498;
import net.minecraft.class_6025;
import net.minecraft.class_742;
import net.minecraft.class_9460;
import net.minecraft.class_9817;
import net.minecraft.world.entity.*;
import java.util.Arrays;
import java.util.Optional;

public final class MolangQueries {
    public static final String ACTOR_COUNT = "actor_count";
    public static final String BLOCKING = "blocking";
    public static final String BODY_X_ROTATION = "body_x_rotation";
    public static final String BODY_Y_ROTATION = "body_y_rotation";
    public static final String CARDINAL_FACING = "cardinal_facing";
    public static final String CARDINAL_FACING_2D = "cardinal_facing_2d";
    public static final String CARDINAL_PLAYER_FACING = "cardinal_player_facing";
    public static final String DAY = "day";
    public static final String DEATH_TICKS = "death_ticks";
    public static final String DISTANCE_FROM_CAMERA = "distance_from_camera";
    public static final String EQUIPMENT_COUNT = "equipment_count";
    public static final String FRAME_ALPHA = "frame_alpha";
    public static final String GET_ACTOR_INFO_ID = "get_actor_info_id";
    public static final String GROUND_SPEED = "ground_speed";
    public static final String HAS_CAPE = "has_cape";
    public static final String HAS_COLLISION = "has_collision";
    public static final String HAS_GRAVITY = "has_gravity";
    public static final String HAS_HEAD_GEAR = "has_head_gear";
    public static final String HAS_OWNER = "has_owner";
    public static final String HAS_PLAYER_RIDER = "has_player_rider";
    public static final String HAS_RIDER = "has_rider";
    public static final String HEAD_X_ROTATION = "head_x_rotation";
    public static final String HEAD_Y_ROTATION = "head_y_rotation";
    public static final String HEALTH = "health";
    public static final String HURT_TIME = "hurt_time";
    public static final String INVULNERABLE_TICKS = "invulnerable_ticks";
    public static final String IS_ALIVE = "is_alive";
    public static final String IS_ANGRY = "is_angry";
    public static final String IS_BABY = "is_baby";
    public static final String IS_BREATHING = "is_breathing";
    public static final String IS_FIRE_IMMUNE = "is_fire_immune";
    public static final String IS_FIRST_PERSON = "is_first_person";
    public static final String IS_IN_CONTACT_WITH_WATER = "is_in_contact_with_water";
    public static final String IS_IN_LAVA = "is_in_lava";
    public static final String IS_IN_WATER = "is_in_water";
    public static final String IS_IN_WATER_OR_RAIN = "is_in_water_or_rain";
    public static final String IS_INVISIBLE = "is_invisible";
    public static final String IS_LEASHED = "is_leashed";
    public static final String IS_MOVING = "is_moving";
    public static final String IS_ON_FIRE = "is_on_fire";
    public static final String IS_ON_GROUND = "is_on_ground";
    public static final String IS_RIDING = "is_riding";
    public static final String IS_SADDLED = "is_saddled";
    public static final String IS_SILENT = "is_silent";
    public static final String IS_SLEEPING = "is_sleeping";
    public static final String IS_SNEAKING = "is_sneaking";
    public static final String IS_SPRINTING = "is_sprinting";
    public static final String IS_SWIMMING = "is_swimming";
    public static final String IS_USING_ITEM = "is_using_item";
    public static final String IS_WALL_CLIMBING = "is_wall_climbing";
    public static final String LIFE_TIME = "life_time";
    public static final String LIMB_SWING = "limb_swing";
    public static final String LIMB_SWING_AMOUNT = "limb_swing_amount";
    public static final String MAIN_HAND_ITEM_MAX_DURATION = "main_hand_item_max_duration";
    public static final String MAIN_HAND_ITEM_USE_DURATION = "main_hand_item_use_duration";
    public static final String MAX_HEALTH = "max_health";
    public static final String MOON_BRIGHTNESS = "moon_brightness";
    public static final String MOON_PHASE = "moon_phase";
    public static final String MOVEMENT_DIRECTION = "movement_direction";
    public static final String PLAYER_LEVEL = "player_level";
    public static final String RIDER_BODY_X_ROTATION = "rider_body_x_rotation";
    public static final String RIDER_BODY_Y_ROTATION = "rider_body_y_rotation";
    public static final String RIDER_HEAD_X_ROTATION = "rider_head_x_rotation";
    public static final String RIDER_HEAD_Y_ROTATION = "rider_head_y_rotation";
    public static final String SCALE = "scale";
    public static final String SLEEP_ROTATION = "sleep_rotation";
    public static final String TIME_OF_DAY = "time_of_day";
    public static final String TIME_STAMP = "time_stamp";
    public static final String VERTICAL_SPEED = "vertical_speed";
    public static final String YAW_SPEED = "yaw_speed";

    public static void setDefaultQueryValues(QueryBinding<AnimationController> binding) {
        MolangLoader.setDoubleQuery(binding, ACTOR_COUNT, actor -> class_310.method_1551().field_1769.field_61737.field_61735.size());
        MolangLoader.setDoubleQuery(binding, CARDINAL_PLAYER_FACING, actor -> ((PlayerAnimationController) actor).getAvatar().method_5735().ordinal());
        MolangLoader.setDoubleQuery(binding, DAY, actor -> ((PlayerAnimationController) actor).getAvatar().method_73183().method_8510() / 24000d);
        MolangLoader.setDoubleQuery(binding, FRAME_ALPHA, actor -> actor.getAnimationData().getPartialTick());
        MolangLoader.setBoolQuery(binding, HAS_CAPE, actor -> {
            class_11890 avatar = ((PlayerAnimationController) actor).getAvatar();
            if (avatar instanceof class_742 player) {
                return player.method_52814().comp_1627() != null;
            } else if (avatar instanceof class_11903 mannequin) {
                return mannequin.method_52814().comp_1627() != null;
            } else {
                return false;
            }
        });
        MolangLoader.setBoolQuery(binding, IS_FIRST_PERSON, actor -> {
            class_11890 avatar = ((PlayerAnimationController) actor).getAvatar();
            if (avatar instanceof class_742 player && player.method_7340()) {
                return class_310.method_1551().field_1690.method_31044() == class_5498.field_26664;
            } else {
                return false;
            }
        });
        MolangLoader.setDoubleQuery(binding, LIFE_TIME, actor -> actor.isActive() ? actor.getAnimationTime() : 0);
        MolangLoader.setDoubleQuery(binding, MOON_BRIGHTNESS, actor -> ((PlayerAnimationController) actor).getAvatar().method_73183().method_30272());
        MolangLoader.setDoubleQuery(binding, MOON_PHASE, actor -> ((PlayerAnimationController) actor).getAvatar().method_73183().method_30273());
        MolangLoader.setDoubleQuery(binding, PLAYER_LEVEL, actor -> {
            class_11890 avatar = ((PlayerAnimationController) actor).getAvatar();
            if (avatar instanceof class_742 player) {
                return player.field_7520;
            } else {
                return 0.0D;
            }
        });
        MolangLoader.setDoubleQuery(binding, TIME_OF_DAY, actor -> ((PlayerAnimationController) actor).getAvatar().method_73183().method_8532() / 24000d);
        MolangLoader.setDoubleQuery(binding, TIME_STAMP, actor -> ((PlayerAnimationController) actor).getAvatar().method_73183().method_8510());

        setDefaultEntityQueryValues(binding);
        setDefaultLivingEntityQueryValues(binding);
    }

    private static void setDefaultEntityQueryValues(QueryBinding<AnimationController> binding) {
        MolangLoader.setDoubleQuery(binding, BODY_X_ROTATION, actor -> ((PlayerAnimationController) actor).getAvatar().method_5695(actor.getAnimationData().getPartialTick()));
        MolangLoader.setDoubleQuery(binding, BODY_Y_ROTATION, actor -> ((PlayerAnimationController) actor).getAvatar() instanceof class_1309 living ? class_3532.method_16439(actor.getAnimationData().getPartialTick(), living.field_6220, living.field_6283) : ((PlayerAnimationController) actor).getAvatar().method_5705(actor.getAnimationData().getPartialTick()));
        MolangLoader.setDoubleQuery(binding, CARDINAL_FACING, actor -> ((PlayerAnimationController) actor).getAvatar().method_5735().method_10146());
        MolangLoader.setDoubleQuery(binding, CARDINAL_FACING_2D, actor -> {
            int directionId = ((PlayerAnimationController) actor).getAvatar().method_5735().method_10146();

            return directionId < 2 ? 6 : directionId;
        });
        MolangLoader.setDoubleQuery(binding, DISTANCE_FROM_CAMERA, actor -> class_310.method_1551().field_1773.method_19418().method_19326().method_1022(((PlayerAnimationController) actor).getAvatar().method_73189()));
        MolangLoader.setDoubleQuery(binding, GET_ACTOR_INFO_ID, actor -> ((PlayerAnimationController) actor).getAvatar().method_5628());
        MolangLoader.setDoubleQuery(binding, EQUIPMENT_COUNT, actor -> ((PlayerAnimationController) actor).getAvatar() instanceof class_9460 armorable ? Arrays.stream(class_1304.values()).filter(class_1304::method_46643).filter(slot -> !armorable.method_6118(slot).method_7960()).count() : 0);
        MolangLoader.setBoolQuery(binding, HAS_COLLISION, actor -> !((PlayerAnimationController) actor).getAvatar().field_5960);
        MolangLoader.setBoolQuery(binding, HAS_GRAVITY, actor -> !((PlayerAnimationController) actor).getAvatar().method_5740());
        MolangLoader.setBoolQuery(binding, HAS_OWNER, actor -> ((PlayerAnimationController) actor).getAvatar() instanceof class_6025 ownable && ownable.method_66287() != null);
        MolangLoader.setBoolQuery(binding, HAS_PLAYER_RIDER, actor -> ((PlayerAnimationController) actor).getAvatar().method_5703(class_1657.class::isInstance));
        MolangLoader.setBoolQuery(binding, HAS_RIDER, actor -> ((PlayerAnimationController) actor).getAvatar().method_5782());
        MolangLoader.setBoolQuery(binding, IS_ALIVE, actor -> ((PlayerAnimationController) actor).getAvatar().method_5805());
        MolangLoader.setBoolQuery(binding, IS_ANGRY, actor -> ((PlayerAnimationController) actor).getAvatar() instanceof class_5354 neutralMob && neutralMob.method_29511());
        MolangLoader.setBoolQuery(binding, IS_BREATHING, actor -> ((PlayerAnimationController) actor).getAvatar().method_5669() >= ((PlayerAnimationController) actor).getAvatar().method_5748());
        MolangLoader.setBoolQuery(binding, IS_FIRE_IMMUNE, actor -> ((PlayerAnimationController) actor).getAvatar().method_5864().method_19946());
        MolangLoader.setBoolQuery(binding, IS_INVISIBLE, actor -> ((PlayerAnimationController) actor).getAvatar().method_5767());
        MolangLoader.setBoolQuery(binding, IS_IN_CONTACT_WITH_WATER, actor -> ((PlayerAnimationController) actor).getAvatar().method_5721());
        MolangLoader.setBoolQuery(binding, IS_IN_LAVA, actor -> ((PlayerAnimationController) actor).getAvatar().method_5771());
        MolangLoader.setBoolQuery(binding, IS_IN_WATER, actor -> ((PlayerAnimationController) actor).getAvatar().method_5799());
        MolangLoader.setBoolQuery(binding, IS_IN_WATER_OR_RAIN, actor -> ((PlayerAnimationController) actor).getAvatar().method_5721());
        MolangLoader.setBoolQuery(binding, IS_LEASHED, actor -> ((PlayerAnimationController) actor).getAvatar() instanceof class_9817 leashable && leashable.method_60953());
        MolangLoader.setBoolQuery(binding, IS_MOVING, actor -> actor.getAnimationData().isMoving());
        MolangLoader.setBoolQuery(binding, IS_ON_FIRE, actor -> ((PlayerAnimationController) actor).getAvatar().method_5809());
        MolangLoader.setBoolQuery(binding, IS_ON_GROUND, actor -> ((PlayerAnimationController) actor).getAvatar().method_24828());
        MolangLoader.setBoolQuery(binding, IS_RIDING, actor -> ((PlayerAnimationController) actor).getAvatar().method_5765());
        MolangLoader.setBoolQuery(binding, IS_SADDLED, actor -> ((PlayerAnimationController) actor).getAvatar() instanceof class_9460 saddleable && !saddleable.method_6118(class_1304.field_55946).method_7960());
        MolangLoader.setBoolQuery(binding, IS_SILENT, actor -> ((PlayerAnimationController) actor).getAvatar().method_5701());
        MolangLoader.setBoolQuery(binding, IS_SNEAKING, actor -> ((PlayerAnimationController) actor).getAvatar().method_18276());
        MolangLoader.setBoolQuery(binding, IS_SPRINTING, actor -> ((PlayerAnimationController) actor).getAvatar().method_5624());
        MolangLoader.setBoolQuery(binding, IS_SWIMMING, actor -> ((PlayerAnimationController) actor).getAvatar().method_5681());
        MolangLoader.setDoubleQuery(binding, MOVEMENT_DIRECTION, actor -> actor.getAnimationData().isMoving() ? class_2350.method_58251(((PlayerAnimationController) actor).getAvatar().method_18798()).method_10146() : 6);
        MolangLoader.setDoubleQuery(binding, RIDER_BODY_X_ROTATION, actor -> ((PlayerAnimationController) actor).getAvatar().method_5782() ? ((PlayerAnimationController) actor).getAvatar().method_31483() instanceof class_1309 ? 0 : ((PlayerAnimationController) actor).getAvatar().method_31483().method_5695(actor.getAnimationData().getPartialTick()) : 0);
        MolangLoader.setDoubleQuery(binding, RIDER_BODY_Y_ROTATION, actor -> ((PlayerAnimationController) actor).getAvatar().method_5782() ? ((PlayerAnimationController) actor).getAvatar().method_31483() instanceof class_1309 living ? class_3532.method_16439(actor.getAnimationData().getPartialTick(), living.field_6220, living.field_6283) : ((PlayerAnimationController) actor).getAvatar().method_31483().method_5705(actor.getAnimationData().getPartialTick()) : 0);
        MolangLoader.setDoubleQuery(binding, RIDER_HEAD_X_ROTATION, actor -> ((PlayerAnimationController) actor).getAvatar().method_31483() instanceof class_1309 living ? living.method_5695(actor.getAnimationData().getPartialTick()) : 0);
        MolangLoader.setDoubleQuery(binding, RIDER_HEAD_Y_ROTATION, actor -> ((PlayerAnimationController) actor).getAvatar().method_31483() instanceof class_1309 living ? living.method_5705(actor.getAnimationData().getPartialTick()) : 0);
        MolangLoader.setDoubleQuery(binding, VERTICAL_SPEED, actor -> ((PlayerAnimationController) actor).getAvatar().method_18798().field_1351);
        MolangLoader.setDoubleQuery(binding, YAW_SPEED, actor -> ((PlayerAnimationController) actor).getAvatar().method_36454() - ((PlayerAnimationController) actor).getAvatar().field_5982);
    }

    private static void setDefaultLivingEntityQueryValues(QueryBinding<AnimationController> binding) {
        MolangLoader.setBoolQuery(binding, BLOCKING, actor -> ((PlayerAnimationController) actor).getAvatar().method_6039());
        MolangLoader.setDoubleQuery(binding, DEATH_TICKS, actor -> ((PlayerAnimationController) actor).getAvatar().field_6213 == 0 ? 0 : ((PlayerAnimationController) actor).getAvatar().field_6213 + actor.getAnimationData().getPartialTick());
        MolangLoader.setDoubleQuery(binding, GROUND_SPEED, actor -> ((PlayerAnimationController) actor).getAvatar().method_18798().method_37267());
        MolangLoader.setBoolQuery(binding, HAS_HEAD_GEAR, actor -> !((PlayerAnimationController) actor).getAvatar().method_6118(class_1304.field_6169).method_7960());
        MolangLoader.setDoubleQuery(binding, HEAD_X_ROTATION, actor -> ((PlayerAnimationController) actor).getAvatar().method_5695(actor.getAnimationData().getPartialTick()));
        MolangLoader.setDoubleQuery(binding, HEAD_Y_ROTATION, actor -> ((PlayerAnimationController) actor).getAvatar().method_5705(actor.getAnimationData().getPartialTick()));
        MolangLoader.setDoubleQuery(binding, HEALTH, actor -> ((PlayerAnimationController) actor).getAvatar().method_6032());
        MolangLoader.setDoubleQuery(binding, HURT_TIME, actor -> ((PlayerAnimationController) actor).getAvatar().field_6235 == 0 ? 0 : ((PlayerAnimationController) actor).getAvatar().field_6235 - actor.getAnimationData().getPartialTick());
        MolangLoader.setDoubleQuery(binding, INVULNERABLE_TICKS, actor -> ((PlayerAnimationController) actor).getAvatar().field_6008 == 0 ? 0 : ((PlayerAnimationController) actor).getAvatar().field_6008 - actor.getAnimationData().getPartialTick());
        MolangLoader.setBoolQuery(binding, IS_BABY, actor -> ((PlayerAnimationController) actor).getAvatar().method_6109());
        MolangLoader.setBoolQuery(binding, IS_SLEEPING, actor -> ((PlayerAnimationController) actor).getAvatar().method_6113());
        MolangLoader.setBoolQuery(binding, IS_USING_ITEM, actor -> ((PlayerAnimationController) actor).getAvatar().method_6115());
        MolangLoader.setBoolQuery(binding, IS_WALL_CLIMBING, actor -> ((PlayerAnimationController) actor).getAvatar().method_6101());
        MolangLoader.setDoubleQuery(binding, LIMB_SWING, actor -> ((PlayerAnimationController) actor).getAvatar().field_42108.method_48569());
        MolangLoader.setDoubleQuery(binding, LIMB_SWING_AMOUNT, actor -> ((PlayerAnimationController) actor).getAvatar().field_42108.method_48570(actor.getAnimationData().getPartialTick()));
        MolangLoader.setDoubleQuery(binding, MAIN_HAND_ITEM_MAX_DURATION, actor -> ((PlayerAnimationController) actor).getAvatar().method_6047().method_7935(((PlayerAnimationController) actor).getAvatar()));
        MolangLoader.setDoubleQuery(binding, MAIN_HAND_ITEM_USE_DURATION, actor -> ((PlayerAnimationController) actor).getAvatar().method_6058() == class_1268.field_5808 ? ((PlayerAnimationController) actor).getAvatar().method_6048() / 20d + actor.getAnimationData().getPartialTick() : 0);
        MolangLoader.setDoubleQuery(binding, MAX_HEALTH, actor -> ((PlayerAnimationController) actor).getAvatar().method_6063());
        MolangLoader.setDoubleQuery(binding, SCALE, actor -> ((PlayerAnimationController) actor).getAvatar().method_55693());
        MolangLoader.setDoubleQuery(binding, SLEEP_ROTATION, actor -> Optional.ofNullable(((PlayerAnimationController) actor).getAvatar().method_18401()).map(class_2350::method_10144).orElse(0f));
    }
}
