/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimcore.easing;

import com.zigythebird.playeranimcore.animation.keyframe.AnimationPoint;
import com.zigythebird.playeranimcore.math.MathHelper;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import org.jetbrains.annotations.Nullable;
import team.unnamed.mocha.MochaEngine;

@FunctionalInterface
public interface EasingTypeTransformer {
    public Float2FloatFunction buildTransformer(@Nullable Float var1);

    default public float apply(MochaEngine<?> env, AnimationPoint animationPoint) {
        Float easingVariable = null;
        if (animationPoint.easingArgs() != null && !animationPoint.easingArgs().isEmpty()) {
            easingVariable = Float.valueOf(env.eval(animationPoint.easingArgs().getFirst()));
        }
        return this.apply(env, animationPoint, easingVariable, animationPoint.currentTick() / animationPoint.transitionLength());
    }

    default public float apply(MochaEngine<?> env, AnimationPoint animationPoint, @Nullable Float easingValue, float lerpValue) {
        if (lerpValue >= 1.0f) {
            return animationPoint.animationEndValue();
        }
        if (Float.isNaN(lerpValue)) {
            return animationPoint.animationStartValue();
        }
        return this.apply(animationPoint.animationStartValue(), animationPoint.animationEndValue(), easingValue, lerpValue);
    }

    default public float apply(float startValue, float endValue, float lerpValue) {
        return this.apply(startValue, endValue, null, lerpValue);
    }

    default public float apply(float startValue, float endValue, @Nullable Float easingValue, float lerpValue) {
        return MathHelper.lerp(((Float)this.buildTransformer(easingValue).apply((Object)Float.valueOf(lerpValue))).floatValue(), startValue, endValue);
    }
}

