/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.animation;

import com.zigythebird.playeranim.util.RenderUtil;
import com.zigythebird.playeranimcore.animation.AnimationData;
import com.zigythebird.playeranimcore.animation.layered.AnimationStack;
import com.zigythebird.playeranimcore.animation.layered.IAnimation;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

public class AvatarAnimManager
extends AnimationStack {
    private final Avatar avatar;
    private float lastUpdateTime;
    private boolean isFirstTick = true;
    private float tickDelta;

    public AvatarAnimManager(Avatar avatar) {
        this.avatar = avatar;
    }

    public void tickAnimation(AnimationStack playerAnimManager, AnimationData state) {
        playerAnimManager.getLayers().removeIf(pair -> pair.right() == null || ((IAnimation)pair.right()).canRemove());
        for (Pair<Integer, IAnimation> pair2 : playerAnimManager.getLayers()) {
            IAnimation animation = (IAnimation)pair2.right();
            if (!animation.isActive()) continue;
            animation.setupAnim(state.copy());
        }
        this.finishFirstTick();
    }

    public float getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void updatedAt(float updateTime) {
        this.lastUpdateTime = updateTime;
    }

    public boolean isFirstTick() {
        return this.isFirstTick;
    }

    protected void finishFirstTick() {
        this.isFirstTick = false;
    }

    public float getTickDelta() {
        return this.tickDelta;
    }

    @ApiStatus.Internal
    public void setTickDelta(float tickDelta) {
        this.tickDelta = tickDelta;
    }

    public void updatePart(ModelPart part, PlayerAnimBone bone) {
        PartPose initialPose = part.getInitialPose();
        bone = this.get3DTransform(bone);
        RenderUtil.translatePartToBone(part, bone, initialPose);
    }

    public void handleAnimations(float partialTick, boolean fullTick, boolean isFirstPersonPass) {
        Vec3 velocity = this.avatar.getDeltaMovement();
        AvatarAnimManager animatableManager = this.avatar.playerAnimLib$getAnimManager();
        int currentTick = this.avatar.tickCount;
        float currentFrameTime = (float)currentTick + partialTick;
        AnimationData animationData = new AnimationData((float)((Math.abs(velocity.x) + Math.abs(velocity.z)) / 2.0), partialTick, isFirstPersonPass);
        if (fullTick) {
            animatableManager.tick(animationData.copy());
        }
        if (!animatableManager.isFirstTick() && currentFrameTime == animatableManager.getLastUpdateTime()) {
            return;
        }
        if (!Minecraft.getInstance().isPaused()) {
            animatableManager.updatedAt(currentFrameTime);
        }
        this.tickAnimation(animatableManager, animationData);
    }

    public Avatar getAvatar() {
        return this.avatar;
    }
}

