/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimcore.util;

import com.zigythebird.playeranimcore.bones.PivotBone;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import com.zigythebird.playeranimcore.math.ModMatrix4f;
import com.zigythebird.playeranimcore.math.Vec3f;
import java.util.function.Function;

public class MatrixUtil {
    public static void rotateMatrixAroundBone(ModMatrix4f matrix, PlayerAnimBone bone) {
        if (bone.getRotZ() != 0.0f || bone.getRotY() != 0.0f || bone.getRotX() != 0.0f) {
            matrix.rotateZ(bone.getRotZ()).rotateY(bone.getRotY()).rotateX(bone.getRotX());
        }
    }

    public static void scaleMatrixForBone(ModMatrix4f matrix, PlayerAnimBone bone) {
        matrix.scale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void translateToPivotPoint(ModMatrix4f matrix, Vec3f pivot) {
        matrix.translate(pivot.x(), pivot.y(), pivot.z());
    }

    public static void translateAwayFromPivotPoint(ModMatrix4f matrix, Vec3f pivot) {
        matrix.translate(-pivot.x(), -pivot.y(), -pivot.z());
    }

    public static void prepMatrixForBone(ModMatrix4f matrix, PlayerAnimBone bone, Vec3f pivot) {
        MatrixUtil.translateToPivotPoint(matrix, pivot);
        MatrixUtil.rotateMatrixAroundBone(matrix, bone);
        MatrixUtil.scaleMatrixForBone(matrix, bone);
        MatrixUtil.translateAwayFromPivotPoint(matrix, pivot);
    }

    public static void applyParentsToChild(PlayerAnimBone child, Iterable<? extends PlayerAnimBone> parents, Function<String, Vec3f> positions) {
        ModMatrix4f matrix = new ModMatrix4f();
        for (PlayerAnimBone playerAnimBone : parents) {
            Vec3f vec3f;
            if (playerAnimBone instanceof PivotBone) {
                PivotBone pivotBone = (PivotBone)playerAnimBone;
                vec3f = pivotBone.getPivot();
            } else {
                vec3f = positions.apply(playerAnimBone.getName());
            }
            Vec3f pivot = vec3f;
            MatrixUtil.prepMatrixForBone(matrix, playerAnimBone, pivot);
            child.addPos(playerAnimBone.getPosX(), playerAnimBone.getPosY(), playerAnimBone.getPosZ());
        }
        Vec3f defaultPos = positions.apply(child.getName());
        matrix.translate(defaultPos.x(), defaultPos.y(), defaultPos.z());
        MatrixUtil.rotateMatrixAroundBone(matrix, child);
        child.setPosX(-matrix.m30() + defaultPos.x() + child.getPosX());
        child.setPosY(matrix.m31() - defaultPos.y() + child.getPosY());
        child.setPosZ(-matrix.m32() - defaultPos.z() + child.getPosZ());
        Vec3f vec3f = matrix.getEulerRotation();
        child.updateRotation(vec3f.x(), vec3f.y(), vec3f.z());
        child.mulScale(matrix.getColumnScale(0), matrix.getColumnScale(1), matrix.getColumnScale(2));
    }
}

