/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.animation;

import com.zigythebird.playeranim.PlayerAnimLibMod;
import com.zigythebird.playeranimcore.PlayerAnimLib;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.loading.UniversalAnimLoader;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerAnimResources
implements ResourceManagerReloadListener {
    public static final ResourceLocation KEY = PlayerAnimLibMod.id("animation");
    private static final Map<ResourceLocation, Animation> ANIMATIONS = new Object2ObjectOpenHashMap();

    @Nullable
    public static Animation getAnimation(ResourceLocation id) {
        return ANIMATIONS.get(id);
    }

    @NotNull
    public static Optional<Animation> getAnimationOptional(@NotNull ResourceLocation identifier) {
        return Optional.ofNullable(PlayerAnimResources.getAnimation(identifier));
    }

    public static Map<ResourceLocation, Animation> getAnimations() {
        return Collections.unmodifiableMap(ANIMATIONS);
    }

    @NotNull
    public static Map<String, Animation> getModAnimations(@NotNull String modid) {
        HashMap<String, Animation> map = new HashMap<String, Animation>();
        for (Map.Entry<ResourceLocation, Animation> entry : ANIMATIONS.entrySet()) {
            if (!entry.getKey().getNamespace().equals(modid)) continue;
            map.put(entry.getKey().getPath(), entry.getValue());
        }
        return map;
    }

    public static boolean hasAnimation(ResourceLocation id) {
        return ANIMATIONS.containsKey(id);
    }

    public void onResourceManagerReload(ResourceManager manager) {
        ANIMATIONS.clear();
        for (Map.Entry resource : manager.listResources("player_animations", resourceLocation -> resourceLocation.getPath().endsWith(".json")).entrySet()) {
            String namespace = ((ResourceLocation)resource.getKey()).getNamespace();
            try {
                InputStream is = ((Resource)resource.getValue()).open();
                try {
                    for (Map.Entry<String, Animation> entry : UniversalAnimLoader.loadAnimations(is).entrySet()) {
                        ANIMATIONS.put(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)entry.getKey()), entry.getValue());
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                PlayerAnimLib.LOGGER.error("Player Animation Library failed to load animation {} because:", resource.getKey(), (Object)e);
            }
        }
    }

    @NotNull
    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.runAsync(() -> this.onResourceManagerReload(resourceManager), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0));
    }
}

