/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zigythebird.playeranim.accessors.ICapeLayer;
import com.zigythebird.playeranim.animation.PlayerAnimManager;
import com.zigythebird.playeranim.mixin.PlayerModelAccessor;
import com.zigythebird.playeranim.util.RenderUtil;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CapeLayer.class})
public abstract class CapeLayerMixin<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M>
implements ICapeLayer {
    public CapeLayerMixin(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;FFFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/PlayerModel;renderCloak(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V")})
    private void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, AbstractClientPlayer livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        EntityModel entityModel = this.getParentModel();
        if (entityModel instanceof PlayerModelAccessor) {
            PlayerModelAccessor model = (PlayerModelAccessor)entityModel;
            ModelPart part = model.getCloak();
            PlayerAnimManager emote = livingEntity.playerAnimLib$getAnimManager();
            if (emote != null && emote.isActive()) {
                ModelPart torso = ((HumanoidModel)this.getParentModel()).body;
                torso.translateAndRotate(poseStack);
                poseStack.translate(0.0f, 0.0f, 0.125f);
                poseStack.mulPose(Axis.YP.rotation(3.14159f));
                PlayerAnimBone bone = emote.get3DTransform(new PlayerAnimBone("cape"));
                bone.positionX *= -1.0f;
                bone.positionZ *= -1.0f;
                bone.rotX *= -1.0f;
                bone.rotZ *= -1.0f;
                RenderUtil.translatePartToBone(part, bone);
                this.applyBend(part, torso, bone.getBend());
            } else {
                this.resetBend(part);
            }
        }
    }
}

