package com.zigythebird.playeranim.mixin;

import com.zigythebird.playeranim.accessors.IAnimatedPlayer;
import com.zigythebird.playeranim.accessors.ICapeLayer;
import com.zigythebird.playeranim.animation.PlayerAnimManager;
import com.zigythebird.playeranim.util.RenderUtil;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import net.minecraft.class_1309;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import net.minecraft.class_972;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_972.class)
public abstract class CapeLayerMixin<T extends class_1309, M extends class_572<T>> extends class_3887<T, M> implements ICapeLayer {
    public CapeLayerMixin(class_3883<T, M> renderer) {
        super(renderer);
    }

    @Inject(method = "render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;FFFFFF)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/model/PlayerModel;renderCloak(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V"))
    private void render(class_4587 poseStack, class_4597 buffer, int packedLight, class_742 livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (method_17165() instanceof PlayerModelAccessor model) {
            class_630 part = model.getCloak();
            PlayerAnimManager emote = ((IAnimatedPlayer)livingEntity).playerAnimLib$getAnimManager();
            if (emote != null && emote.isActive()) {
                class_630 torso = this.method_17165().field_3391;

                torso.method_22703(poseStack);

                poseStack.method_46416(0.0F, 0.0F, 0.125F);
                poseStack.method_22907(class_7833.field_40716.rotation(3.14159f));

                PlayerAnimBone bone = emote.get3DTransform(new PlayerAnimBone("cape"));

                bone.positionX *= -1;
                bone.positionZ *= -1;
                bone.rotX *= -1;
                bone.rotZ *= -1;

                RenderUtil.translatePartToBone(part, bone);

                this.applyBend(part, torso, bone.getBend());
            }
            else this.resetBend(part);
        }
    }
}
