/*
 * MIT License
 *
 * Copyright (c) 2022 KosmX
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.zigythebird.playeranim.mixin;

import Z;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.zigythebird.playeranim.accessors.IAnimatedPlayer;
import com.zigythebird.playeranim.accessors.IMutableModel;
import com.zigythebird.playeranim.animation.PlayerAnimManager;
import com.zigythebird.playeranim.util.RenderUtil;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonConfiguration;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonMode;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;

@Mixin(value = class_591.class, priority = 2001)//Apply after NotEnoughAnimation's inject
public class PlayerModelMixin<T extends class_1309> extends class_572<T> {
    @Shadow @Final public class_630 rightSleeve;

    @Shadow @Final public class_630 leftSleeve;

    @Shadow @Final public class_630 leftPants;

    @Shadow @Final public class_630 rightPants;

    @Shadow @Final public class_630 jacket;

    @Unique
    private final PlayerAnimBone pal$head = new PlayerAnimBone("head");
    @Unique
    private final PlayerAnimBone pal$torso = new PlayerAnimBone("torso");
    @Unique
    private final PlayerAnimBone pal$rightArm = new PlayerAnimBone("right_arm");
    @Unique
    private final PlayerAnimBone pal$leftArm = new PlayerAnimBone("left_arm");
    @Unique
    private final PlayerAnimBone pal$rightLeg = new PlayerAnimBone("right_leg");
    @Unique
    private final PlayerAnimBone pal$leftLeg = new PlayerAnimBone("left_leg");


    public PlayerModelMixin(class_630 modelPart, Function<class_2960, class_1921> function) {
        super(modelPart, function);
    }

    @Unique
    private void playerAnimLib$setToInitialPose() {
        this.field_3398.method_41923();
        this.field_3391.method_41923();
        this.field_3401.method_41923();
        this.field_27433.method_41923();
        this.field_3392.method_41923();
        this.field_3397.method_41923();

        this.field_3394.method_41923();
        this.jacket.method_41923();
        this.rightSleeve.method_41923();
        this.leftSleeve.method_41923();
        this.rightPants.method_41923();
        this.leftPants.method_41923();
    }

    @Inject(method = "setupAnim(Lnet/minecraft/world/entity/Entity;FFFFF)V", at = @At(value = "HEAD"))
    private void setDefaultBeforeRender(class_1297 entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci){
        playerAnimLib$setToInitialPose(); //to not make everything wrong
    }

    @Inject(method = "setupAnim(Lnet/minecraft/world/entity/Entity;FFFFF)V", at = @At(value = "RETURN"))
    private void setupPlayerAnimation(class_1297 entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (entity instanceof class_742 player && ((IAnimatedPlayer)player).playerAnimLib$getAnimProcessor() != null && ((IAnimatedPlayer)player).playerAnimLib$getAnimManager().isActive()) {
            PlayerAnimManager emote = ((IAnimatedPlayer)player).playerAnimLib$getAnimManager();
            ((IMutableModel)this).playerAnimLib$setAnimation(emote);

            RenderUtil.copyVanillaPart(this.field_3398, pal$head);
            RenderUtil.copyVanillaPart(this.field_3391, pal$torso);
            RenderUtil.copyVanillaPart(this.field_3401, pal$rightArm);
            RenderUtil.copyVanillaPart(this.field_27433, pal$leftArm);
            RenderUtil.copyVanillaPart(this.field_3392, pal$rightLeg);
            RenderUtil.copyVanillaPart(this.field_3397, pal$leftLeg);

            emote.updatePart(this.field_3398, this.field_3394, pal$head);
            emote.updatePart(this.field_3401, this.rightSleeve, pal$rightArm);
            emote.updatePart(this.field_27433, this.leftSleeve, pal$leftArm);
            emote.updatePart(this.field_3392, this.rightPants, pal$rightLeg);
            emote.updatePart(this.field_3397, this.leftPants, pal$leftLeg);
            emote.updatePart(this.field_3391, this.jacket, pal$torso);
        }
        else {
            ((IMutableModel)this).playerAnimLib$setAnimation(null);
        }

        if (FirstPersonMode.isFirstPersonPass() && entity instanceof class_742 player
                && player == class_310.method_1551().field_1719) {
            var config = ((IAnimatedPlayer)player).playerAnimLib$getAnimManager().getFirstPersonConfiguration();
            // Hiding all parts, because they should not be visible in first person
            playerAnimLib$setAllPartsVisible(false);
            // Showing arms based on configuration
            var skipRightArm = !config.isShowRightArm();
            var skipLeftArm = !config.isShowLeftArm();
            this.field_3401.field_38456 = skipRightArm;
            this.field_27433.field_38456 = skipLeftArm;

            // These are children of those ^^^
            // this.rightSleeve.skipDraw = skipRightArm;
            // this.leftSleeve.skipDraw = skipLeftArm;
        } else {
            playerAnimLib$setAllPartsVisible(true);
        }
    }

    @Unique
    private void playerAnimLib$setAllPartsVisible(boolean visible) {
        var skip = !visible;
        this.field_3398.field_38456 = skip;
        this.field_3398.method_32088().forEach(p -> p.field_38456 = skip);
        this.field_3391.field_38456 = skip;
        this.field_3391.method_32088().forEach(p -> p.field_38456 = skip);
        this.field_3397.field_38456 = skip;
        this.field_3397.method_32088().forEach(p -> p.field_38456 = skip);
        this.field_3392.field_38456 = skip;
        this.field_3392.method_32088().forEach(p -> p.field_38456 = skip);
        this.field_3401.field_38456 = skip;
        this.field_3401.method_32088().forEach(p -> p.field_38456 = skip);
        this.field_27433.field_38456 = skip;
        this.field_27433.method_32088().forEach(p -> p.field_38456 = skip);

        this.field_3394.field_3665 = visible;
        this.leftSleeve.field_3665 = visible;
        this.rightSleeve.field_3665 = visible;
        this.leftPants.field_3665 = visible;
        this.rightPants.field_3665 = visible;
        this.jacket.field_3665 = visible;
    }

    @WrapWithCondition(method = "translateToHand", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/model/geom/ModelPart;translateAndRotate(Lcom/mojang/blaze3d/vertex/PoseStack;)V"))
    private boolean translateToHand(class_630 modelPart, class_4587 poseStack) {
        if (((IMutableModel)this).playerAnimLib$getAnimation() != null && ((IMutableModel)this).playerAnimLib$getAnimation().isActive()) {
            poseStack.method_46416(modelPart.field_3657 / 16.0F, modelPart.field_3656 / 16.0F, modelPart.field_3655 / 16.0F);
            if (modelPart.field_3654 != 0.0F || modelPart.field_3675 != 0.0F || modelPart.field_3674 != 0.0F) {
                RenderUtil.rotateZYX(poseStack.method_23760(), modelPart.field_3674, modelPart.field_3675, modelPart.field_3654);
            }
            poseStack.method_22904(0, (modelPart.field_37939 - 1) * 0.609375, (modelPart.field_37940 - 1) * 0.0625);

            return false;
        }
        return true;
    }
}
