/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.animation;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zigythebird.playeranim.PlayerAnimLibMod;
import com.zigythebird.playeranim.animation.PlayerAnimResources;
import com.zigythebird.playeranim.util.RenderUtil;
import com.zigythebird.playeranimcore.animation.AnimationController;
import com.zigythebird.playeranimcore.animation.HumanoidAnimationController;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractFadeModifier;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import com.zigythebird.playeranimcore.math.Vec3f;
import com.zigythebird.playeranimcore.molang.MolangLoader;
import java.util.function.Function;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import team.unnamed.mocha.MochaEngine;

public class PlayerAnimationController
extends HumanoidAnimationController {
    protected final Avatar avatar;

    public PlayerAnimationController(Avatar avatar, AnimationController.AnimationStateHandler animationHandler) {
        this(avatar, animationHandler, MolangLoader::createNewEngine);
    }

    public PlayerAnimationController(Avatar avatar, AnimationController.AnimationStateHandler animationHandler, Function<AnimationController, MochaEngine<AnimationController>> molangRuntime) {
        super(animationHandler, molangRuntime);
        this.avatar = avatar;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public boolean triggerAnimation(Identifier newAnimation, float startAnimFrom) {
        if (PlayerAnimResources.hasAnimation(newAnimation)) {
            this.triggerAnimation(PlayerAnimResources.getAnimation(newAnimation), startAnimFrom);
            return true;
        }
        PlayerAnimLibMod.LOGGER.error("Could not find animation with the name:" + String.valueOf(newAnimation));
        return false;
    }

    public boolean triggerAnimation(Identifier newAnimation) {
        return this.triggerAnimation(newAnimation, 0.0f);
    }

    public boolean replaceAnimationWithFade(@NotNull AbstractFadeModifier fadeModifier, @Nullable Identifier newAnimation, boolean fadeFromNothing) {
        if (PlayerAnimResources.hasAnimation(newAnimation)) {
            this.replaceAnimationWithFade(fadeModifier, PlayerAnimResources.getAnimation(newAnimation), fadeFromNothing);
            return true;
        }
        return false;
    }

    public boolean replaceAnimationWithFade(@NotNull AbstractFadeModifier fadeModifier, @Nullable Identifier newAnimation) {
        return this.replaceAnimationWithFade(fadeModifier, newAnimation, true);
    }

    @Nullable
    public PoseStack getBoneWorldPositionPoseStack(String name, float tickDelta, Vec3 cameraPos) {
        if (!this.activeBones.containsKey(name)) {
            return null;
        }
        PoseStack poseStack = new PoseStack();
        Vec3f pivot = this.getBonePosition(name);
        Vec3 position = this.avatar.getPosition(tickDelta).subtract(cameraPos).add((double)pivot.x(), (double)pivot.y(), (double)pivot.z());
        poseStack.translate(position.x(), position.y(), position.z());
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - Mth.lerp((float)tickDelta, (float)this.avatar.yBodyRotO, (float)this.avatar.yBodyRot)));
        RenderUtil.translateMatrixToBone(poseStack, (PlayerAnimBone)this.activeBones.get(name));
        return poseStack;
    }
}

