/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.mixin;

import com.zigythebird.playeranim.accessors.ICapeLayer;
import com.zigythebird.playeranim.animation.AvatarAnimManager;
import com.zigythebird.playeranim.util.RenderUtil;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.player.PlayerCapeModel;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerCapeModel.class}, priority=2001)
public class PlayerCapeModelMixin
implements ICapeLayer {
    @Shadow
    @Final
    private ModelPart cape;

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;)V"}, at={@At(value="HEAD")})
    private void resetPose(AvatarRenderState renderState, CallbackInfo ci) {
        this.cape.resetPose();
    }

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;)V"}, at={@At(value="TAIL")})
    private void setupAnim(AvatarRenderState avatarRenderState, CallbackInfo ci) {
        AvatarAnimManager emote = avatarRenderState.playerAnimLib$getAnimManager();
        if (emote != null && emote.isActive()) {
            PlayerAnimBone bone = RenderUtil.copyVanillaPart(this.cape, new PlayerAnimBone("cape"));
            bone.rotX -= (float)Math.PI;
            bone.rotZ -= (float)Math.PI;
            bone.rotX *= -1.0f;
            bone.rotY *= -1.0f;
            bone = emote.get3DTransform(bone);
            bone.rotX *= -1.0f;
            bone.rotY *= -1.0f;
            bone.rotX += (float)Math.PI;
            bone.rotZ += (float)Math.PI;
            RenderUtil.translatePartToCape(this.cape, bone, this.cape.getInitialPose());
            this.applyBend(emote, bone.getBend());
        } else {
            this.resetBend();
        }
    }
}

