/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zigythebird.playeranim.animation.PlayerAnimManager;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandLayer.class})
public class ItemInHandLayerMixin {
    @Unique
    private final PlayerAnimBone playerAnimLib$rightItem = new PlayerAnimBone("right_item");
    @Unique
    private final PlayerAnimBone playerAnimLib$leftItem = new PlayerAnimBone("left_item");

    @Inject(method={"renderArmWithItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;Lnet/minecraft/world/entity/HumanoidArm;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionf;)V", ordinal=0)})
    private void changeItemLocation(LivingEntity livingEntity, ItemStack itemStack, ItemDisplayContext displayContext, HumanoidArm arm, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        AbstractClientPlayer player;
        if (livingEntity instanceof AbstractClientPlayer && (player = (AbstractClientPlayer)livingEntity).playerAnimLib$getAnimProcessor() != null && player.playerAnimLib$getAnimManager().isActive()) {
            PlayerAnimManager anim = player.playerAnimLib$getAnimManager();
            if (anim == null) {
                return;
            }
            PlayerAnimBone bone = arm == HumanoidArm.LEFT ? this.playerAnimLib$leftItem : this.playerAnimLib$rightItem;
            bone.setToInitialPose();
            anim.get3DTransform(bone);
            poseStack.translate(bone.getPosX() / 16.0f, bone.getPosY() / 16.0f, bone.getPosZ() / 16.0f);
        }
    }

    @Inject(method={"renderArmWithItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;Lnet/minecraft/world/entity/HumanoidArm;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ItemInHandRenderer;renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V")})
    private void changeItemRotationAndScale(LivingEntity livingEntity, ItemStack itemStack, ItemDisplayContext displayContext, HumanoidArm arm, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        AbstractClientPlayer player;
        if (livingEntity instanceof AbstractClientPlayer && (player = (AbstractClientPlayer)livingEntity).playerAnimLib$getAnimProcessor() != null && player.playerAnimLib$getAnimManager().isActive()) {
            PlayerAnimManager anim = player.playerAnimLib$getAnimManager();
            if (anim == null) {
                return;
            }
            PlayerAnimBone bone = arm == HumanoidArm.LEFT ? this.playerAnimLib$leftItem : this.playerAnimLib$rightItem;
            if (bone.getRotY() != 0.0f) {
                poseStack.mulPose(Axis.ZP.rotation(-bone.getRotY()));
            }
            if (bone.getRotZ() != 0.0f) {
                poseStack.mulPose(Axis.YP.rotation(-bone.getRotZ()));
            }
            if (bone.getRotX() != 0.0f) {
                poseStack.mulPose(Axis.XP.rotation(-bone.getRotX()));
            }
            poseStack.scale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
        }
    }
}

