/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.animation;

import com.zigythebird.playeranim.util.RenderUtil;
import com.zigythebird.playeranimcore.animation.layered.AnimationStack;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.player.AbstractClientPlayer;
import org.jetbrains.annotations.ApiStatus;

public class PlayerAnimManager
extends AnimationStack {
    private final AbstractClientPlayer player;
    private float lastUpdateTime;
    private boolean isFirstTick = true;
    private float tickDelta;

    public PlayerAnimManager(AbstractClientPlayer player) {
        this.player = player;
    }

    public float getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void updatedAt(float updateTime) {
        this.lastUpdateTime = updateTime;
    }

    public boolean isFirstTick() {
        return this.isFirstTick;
    }

    protected void finishFirstTick() {
        this.isFirstTick = false;
    }

    public float getTickDelta() {
        return this.tickDelta;
    }

    @ApiStatus.Internal
    public void setTickDelta(float tickDelta) {
        this.tickDelta = tickDelta;
    }

    public AbstractClientPlayer getPlayer() {
        return this.player;
    }

    public void updatePart(ModelPart part, ModelPart secondLayer, PlayerAnimBone bone) {
        PartPose initialPose = part.getInitialPose();
        bone = this.get3DTransform(bone);
        RenderUtil.translatePartToBone(part, bone, initialPose);
        RenderUtil.translatePartToBone(secondLayer, bone, initialPose);
    }
}

