/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.mojang.blaze3d.vertex.PoseStack;
import com.zigythebird.playeranim.accessors.IMutableModel;
import com.zigythebird.playeranim.animation.PlayerAnimManager;
import com.zigythebird.playeranim.util.RenderUtil;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonConfiguration;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonMode;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class}, priority=2001)
public class PlayerModelMixin<T extends LivingEntity>
extends HumanoidModel<T> {
    @Shadow
    @Final
    public ModelPart rightSleeve;
    @Shadow
    @Final
    public ModelPart leftSleeve;
    @Shadow
    @Final
    public ModelPart leftPants;
    @Shadow
    @Final
    public ModelPart rightPants;
    @Shadow
    @Final
    public ModelPart jacket;
    @Unique
    private final PlayerAnimBone pal$head = new PlayerAnimBone("head");
    @Unique
    private final PlayerAnimBone pal$torso = new PlayerAnimBone("torso");
    @Unique
    private final PlayerAnimBone pal$rightArm = new PlayerAnimBone("right_arm");
    @Unique
    private final PlayerAnimBone pal$leftArm = new PlayerAnimBone("left_arm");
    @Unique
    private final PlayerAnimBone pal$rightLeg = new PlayerAnimBone("right_leg");
    @Unique
    private final PlayerAnimBone pal$leftLeg = new PlayerAnimBone("left_leg");

    public PlayerModelMixin(ModelPart modelPart, Function<ResourceLocation, RenderType> function) {
        super(modelPart, function);
    }

    @Unique
    private void playerAnimLib$setToInitialPose() {
        this.head.resetPose();
        this.body.resetPose();
        this.rightArm.resetPose();
        this.leftArm.resetPose();
        this.rightLeg.resetPose();
        this.leftLeg.resetPose();
        this.hat.resetPose();
        this.jacket.resetPose();
        this.rightSleeve.resetPose();
        this.leftSleeve.resetPose();
        this.rightPants.resetPose();
        this.leftPants.resetPose();
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/Entity;FFFFF)V"}, at={@At(value="HEAD")})
    private void setDefaultBeforeRender(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        this.playerAnimLib$setToInitialPose();
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/Entity;FFFFF)V"}, at={@At(value="RETURN")})
    private void setupPlayerAnimation(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        AbstractClientPlayer player;
        if (entity instanceof AbstractClientPlayer && (player = (AbstractClientPlayer)entity).playerAnimLib$getAnimProcessor() != null && player.playerAnimLib$getAnimManager().isActive()) {
            PlayerAnimManager emote = player.playerAnimLib$getAnimManager();
            ((IMutableModel)((Object)this)).playerAnimLib$setAnimation(emote);
            RenderUtil.copyVanillaPart(this.head, this.pal$head);
            RenderUtil.copyVanillaPart(this.body, this.pal$torso);
            RenderUtil.copyVanillaPart(this.rightArm, this.pal$rightArm);
            RenderUtil.copyVanillaPart(this.leftArm, this.pal$leftArm);
            RenderUtil.copyVanillaPart(this.rightLeg, this.pal$rightLeg);
            RenderUtil.copyVanillaPart(this.leftLeg, this.pal$leftLeg);
            emote.updatePart(this.head, this.hat, this.pal$head);
            emote.updatePart(this.rightArm, this.rightSleeve, this.pal$rightArm);
            emote.updatePart(this.leftArm, this.leftSleeve, this.pal$leftArm);
            emote.updatePart(this.rightLeg, this.rightPants, this.pal$rightLeg);
            emote.updatePart(this.leftLeg, this.leftPants, this.pal$leftLeg);
            emote.updatePart(this.body, this.jacket, this.pal$torso);
        } else {
            ((IMutableModel)((Object)this)).playerAnimLib$setAnimation(null);
        }
        if (FirstPersonMode.isFirstPersonPass() && entity instanceof AbstractClientPlayer && (player = (AbstractClientPlayer)entity) == Minecraft.getInstance().cameraEntity) {
            FirstPersonConfiguration config = player.playerAnimLib$getAnimManager().getFirstPersonConfiguration();
            this.playerAnimLib$setAllPartsVisible(false);
            boolean skipRightArm = !config.isShowRightArm();
            boolean skipLeftArm = !config.isShowLeftArm();
            this.rightArm.skipDraw = skipRightArm;
            this.leftArm.skipDraw = skipLeftArm;
        } else {
            this.playerAnimLib$setAllPartsVisible(true);
        }
    }

    @Unique
    private void playerAnimLib$setAllPartsVisible(boolean visible) {
        boolean skip;
        this.head.skipDraw = skip = !visible;
        this.head.getAllParts().forEach(p -> {
            p.skipDraw = skip;
        });
        this.body.skipDraw = skip;
        this.body.getAllParts().forEach(p -> {
            p.skipDraw = skip;
        });
        this.leftLeg.skipDraw = skip;
        this.leftLeg.getAllParts().forEach(p -> {
            p.skipDraw = skip;
        });
        this.rightLeg.skipDraw = skip;
        this.rightLeg.getAllParts().forEach(p -> {
            p.skipDraw = skip;
        });
        this.rightArm.skipDraw = skip;
        this.rightArm.getAllParts().forEach(p -> {
            p.skipDraw = skip;
        });
        this.leftArm.skipDraw = skip;
        this.leftArm.getAllParts().forEach(p -> {
            p.skipDraw = skip;
        });
        this.hat.visible = visible;
        this.leftSleeve.visible = visible;
        this.rightSleeve.visible = visible;
        this.leftPants.visible = visible;
        this.rightPants.visible = visible;
        this.jacket.visible = visible;
    }

    @WrapWithCondition(method={"translateToHand"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/geom/ModelPart;translateAndRotate(Lcom/mojang/blaze3d/vertex/PoseStack;)V")})
    private boolean translateToHand(ModelPart modelPart, PoseStack poseStack) {
        if (((IMutableModel)((Object)this)).playerAnimLib$getAnimation() != null && ((IMutableModel)((Object)this)).playerAnimLib$getAnimation().isActive()) {
            poseStack.translate(modelPart.x / 16.0f, modelPart.y / 16.0f, modelPart.z / 16.0f);
            if (modelPart.xRot != 0.0f || modelPart.yRot != 0.0f || modelPart.zRot != 0.0f) {
                RenderUtil.rotateZYX(poseStack.last(), modelPart.zRot, modelPart.yRot, modelPart.xRot);
            }
            poseStack.translate(0.0, (double)(modelPart.yScale - 1.0f) * 0.609375, (double)(modelPart.zScale - 1.0f) * 0.0625);
            return false;
        }
        return true;
    }
}

