/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zigythebird.playeranim.animation.PlayerAnimManager;
import com.zigythebird.playeranim.util.RenderUtil;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class}, priority=2000)
public abstract class PlayerRendererMixin {
    @Inject(method={"render(Lnet/minecraft/client/player/AbstractClientPlayer;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")})
    private void modifyRenderState(AbstractClientPlayer entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        PlayerAnimManager animation = entity.playerAnimLib$getAnimManager();
        animation.setTickDelta(partialTicks);
    }

    @Inject(method={"setupRotations(Lnet/minecraft/client/player/AbstractClientPlayer;Lcom/mojang/blaze3d/vertex/PoseStack;FFFF)V"}, at={@At(value="RETURN")})
    private void applyBodyTransforms(AbstractClientPlayer player, PoseStack poseStack, float f, float bodyYaw, float tickDelta, float scale, CallbackInfo ci) {
        PlayerAnimManager animationPlayer = player.playerAnimLib$getAnimManager();
        if (animationPlayer != null && animationPlayer.isActive()) {
            player.playerAnimLib$getAnimProcessor().handleAnimations(animationPlayer.getTickDelta(), false);
            PlayerAnimBone body = animationPlayer.get3DTransform(new PlayerAnimBone("body"));
            poseStack.scale(body.getScaleX(), body.getScaleY(), body.getScaleZ());
            poseStack.translate((double)(-body.getPosX() / 16.0f), (double)(body.getPosY() / 16.0f) + 0.75, (double)(body.getPosZ() / 16.0f));
            body.rotX *= -1.0f;
            body.rotY *= -1.0f;
            RenderUtil.rotateMatrixAroundBone(poseStack, body);
            poseStack.translate(0.0, -0.75, 0.0);
        }
    }
}

