package com.zigythebird.playeranim.animation;

import com.zigythebird.playeranimcore.animation.AnimationData;
import com.zigythebird.playeranimcore.animation.AnimationProcessor;
import com.zigythebird.playeranimcore.animation.layered.AnimationStack;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_742;

public class PlayerAnimationProcessor extends AnimationProcessor {
    private final class_742 player;

    /**
     * Each AnimationProcessor must be bound to a player
     *
     * @param player The player to whom this processor is bound
     */
    public PlayerAnimationProcessor(class_742 player) {
        super();
        this.player = player;
    }

    @Override
    public void tickAnimation(AnimationStack stack, AnimationData state) {
        super.tickAnimation(stack, state);

        if (stack instanceof PlayerAnimManager playerAnimManager) {
            playerAnimManager.finishFirstTick();
        }
    }

    @Override
    public void handleAnimations(float partialTick, boolean fullTick) {
        class_243 velocity = player.method_18798();

        PlayerAnimManager animatableManager = player.playerAnimLib$getAnimManager();
        int currentTick = player.field_6012;

        float currentFrameTime = currentTick + partialTick;

        AnimationData animationData = new PlayerAnimationData(player, (float) ((Math.abs(velocity.field_1352) + Math.abs(velocity.field_1350)) / 2f), partialTick);

        if (fullTick) animatableManager.tick(animationData.copy());

        if (!animatableManager.isFirstTick() && currentFrameTime == animatableManager.getLastUpdateTime())
            return;

        if (!class_310.method_1551().method_1493()) {
            animatableManager.updatedAt(currentFrameTime);
        }

        this.tickAnimation(animatableManager, animationData);
    }

    public class_742 getPlayer() {
        return this.player;
    }
}
