package com.zigythebird.playeranim.animation;

import com.zigythebird.playeranim.accessors.IAnimatedAvatar;
import com.zigythebird.playeranimcore.animation.AnimationData;
import com.zigythebird.playeranimcore.animation.AnimationProcessor;
import com.zigythebird.playeranimcore.animation.layered.AnimationStack;
import net.minecraft.class_11890;
import net.minecraft.class_243;
import net.minecraft.class_310;

public class AvatarAnimationProcessor extends AnimationProcessor {
    private final class_11890 avatar;

    /**
     * Each AnimationProcessor must be bound to a avatar
     *
     * @param avatar The avatar to whom this processor is bound
     */
    public AvatarAnimationProcessor(class_11890 avatar) {
        super();
        this.avatar = avatar;
    }

    @Override
    public void tickAnimation(AnimationStack stack, AnimationData state) {
        super.tickAnimation(stack, state);

        if (stack instanceof AvatarAnimManager avatarAnimManager) {
            avatarAnimManager.finishFirstTick();
        }
    }

    @Override
    public void handleAnimations(float partialTick, boolean fullTick) {
        class_243 velocity = avatar.method_18798();

        AvatarAnimManager animatableManager = ((IAnimatedAvatar)avatar).playerAnimLib$getAnimManager();
        int currentTick = avatar.field_6012;

        float currentFrameTime = currentTick + partialTick;

        AnimationData animationData = new AvatarAnimationData(avatar, (float) ((Math.abs(velocity.field_1352) + Math.abs(velocity.field_1350)) / 2f), partialTick);

        if (fullTick) animatableManager.tick(animationData.copy());

        if (!animatableManager.isFirstTick() && currentFrameTime == animatableManager.getLastUpdateTime())
            return;

        if (!class_310.method_1551().method_1493()) {
            animatableManager.updatedAt(currentFrameTime);
        }

        this.tickAnimation(animatableManager, animationData);
    }

    public class_11890 getAvatar() {
        return this.avatar;
    }
}
