/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.animation;

import com.zigythebird.playeranim.animation.PlayerAnimResources;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.RawAnimation;
import net.minecraft.resources.ResourceLocation;

public class PlayerRawAnimationBuilder {
    private final RawAnimation rawAnimation = RawAnimation.begin();

    public static PlayerRawAnimationBuilder begin() {
        return new PlayerRawAnimationBuilder();
    }

    public PlayerRawAnimationBuilder thenPlay(ResourceLocation animation) {
        return this.then(animation, Animation.LoopType.DEFAULT);
    }

    public PlayerRawAnimationBuilder thenLoop(ResourceLocation animation) {
        return this.then(animation, Animation.LoopType.LOOP);
    }

    public PlayerRawAnimationBuilder thenWait(int ticks) {
        this.rawAnimation.thenWait(ticks);
        return this;
    }

    public PlayerRawAnimationBuilder thenPlayAndHold(ResourceLocation animation) {
        return this.then(animation, Animation.LoopType.HOLD_ON_LAST_FRAME);
    }

    public PlayerRawAnimationBuilder thenPlayXTimes(ResourceLocation animation, int playCount) {
        for (int i = 0; i < playCount; ++i) {
            this.then(animation, i == playCount - 1 ? Animation.LoopType.DEFAULT : Animation.LoopType.PLAY_ONCE);
        }
        return this;
    }

    public PlayerRawAnimationBuilder then(ResourceLocation animation, Animation.LoopType loopType) {
        Animation instance = PlayerAnimResources.getAnimation(animation);
        if (instance == null) {
            throw new IllegalArgumentException("Could not find animation with name: " + String.valueOf(animation));
        }
        this.rawAnimation.then(instance, loopType);
        return this;
    }

    public RawAnimation build() {
        return this.rawAnimation;
    }
}

