/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.animation;

import com.zigythebird.playeranim.animation.PlayerAnimManager;
import com.zigythebird.playeranim.animation.PlayerAnimationData;
import com.zigythebird.playeranimcore.animation.AnimationData;
import com.zigythebird.playeranimcore.animation.AnimationProcessor;
import com.zigythebird.playeranimcore.animation.layered.AnimationStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.phys.Vec3;

public class PlayerAnimationProcessor
extends AnimationProcessor {
    private final AbstractClientPlayer player;

    public PlayerAnimationProcessor(AbstractClientPlayer player) {
        this.player = player;
    }

    @Override
    public void tickAnimation(AnimationStack stack, AnimationData state) {
        super.tickAnimation(stack, state);
        if (stack instanceof PlayerAnimManager) {
            PlayerAnimManager playerAnimManager = (PlayerAnimManager)stack;
            playerAnimManager.finishFirstTick();
        }
    }

    @Override
    public void handleAnimations(float partialTick, boolean fullTick) {
        Vec3 velocity = this.player.getDeltaMovement();
        PlayerAnimManager animatableManager = this.player.playerAnimLib$getAnimManager();
        int currentTick = this.player.tickCount;
        float currentFrameTime = (float)currentTick + partialTick;
        PlayerAnimationData animationData = new PlayerAnimationData(this.player, (float)((Math.abs(velocity.x) + Math.abs(velocity.z)) / 2.0), partialTick);
        if (fullTick) {
            animatableManager.tick(((AnimationData)animationData).copy());
        }
        if (!animatableManager.isFirstTick() && currentFrameTime == animatableManager.getLastUpdateTime()) {
            return;
        }
        if (!Minecraft.getInstance().isPaused()) {
            animatableManager.updatedAt(currentFrameTime);
        }
        this.tickAnimation(animatableManager, animationData);
    }

    public AbstractClientPlayer getPlayer() {
        return this.player;
    }
}

