/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zigythebird.playeranim.accessors.IPlayerAnimationState;
import com.zigythebird.playeranim.animation.PlayerAnimManager;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.world.entity.HumanoidArm;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandLayer.class})
public class ItemInHandLayerMixin {
    @Unique
    private final PlayerAnimBone playerAnimLib$rightItem = new PlayerAnimBone("right_item");
    @Unique
    private final PlayerAnimBone playerAnimLib$leftItem = new PlayerAnimBone("left_item");

    @Inject(method={"renderArmWithItem"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionfc;)V", ordinal=0)})
    private void changeItemLocation(ArmedEntityRenderState renderState, ItemStackRenderState itemStackRenderState, HumanoidArm arm, PoseStack matrices, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        IPlayerAnimationState state;
        if (renderState instanceof IPlayerAnimationState && (state = (IPlayerAnimationState)renderState).playerAnimLib$getAnimManager() != null && state.playerAnimLib$getAnimManager().isActive()) {
            PlayerAnimManager anim = state.playerAnimLib$getAnimManager();
            if (anim == null) {
                return;
            }
            PlayerAnimBone bone = arm == HumanoidArm.LEFT ? this.playerAnimLib$leftItem : this.playerAnimLib$rightItem;
            bone.setToInitialPose();
            anim.get3DTransform(bone);
            matrices.translate(bone.getPosX() / 16.0f, bone.getPosY() / 16.0f, bone.getPosZ() / 16.0f);
        }
    }

    @Inject(method={"renderArmWithItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/item/ItemStackRenderState;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V")})
    private void changeItemRotationAndScale(ArmedEntityRenderState renderState, ItemStackRenderState itemStackRenderState, HumanoidArm arm, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, CallbackInfo ci) {
        IPlayerAnimationState state;
        if (renderState instanceof IPlayerAnimationState && (state = (IPlayerAnimationState)renderState).playerAnimLib$getAnimManager() != null && state.playerAnimLib$getAnimManager().isActive()) {
            PlayerAnimManager anim = state.playerAnimLib$getAnimManager();
            if (anim == null) {
                return;
            }
            PlayerAnimBone bone = arm == HumanoidArm.LEFT ? this.playerAnimLib$leftItem : this.playerAnimLib$rightItem;
            if (bone.getRotY() != 0.0f) {
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotation(-bone.getRotY()));
            }
            if (bone.getRotZ() != 0.0f) {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotation(-bone.getRotZ()));
            }
            if (bone.getRotX() != 0.0f) {
                poseStack.mulPose((Quaternionfc)Axis.XP.rotation(-bone.getRotX()));
            }
            poseStack.scale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
        }
    }
}

