/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.animation;

import com.zigythebird.playeranim.animation.PlayerAnimResources;
import com.zigythebird.playeranim.util.RenderUtil;
import com.zigythebird.playeranimcore.animation.AnimationController;
import com.zigythebird.playeranimcore.animation.AnimationData;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractFadeModifier;
import com.zigythebird.playeranimcore.bones.AdvancedPlayerAnimBone;
import com.zigythebird.playeranimcore.bones.PivotBone;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import com.zigythebird.playeranimcore.math.Vec3f;
import com.zigythebird.playeranimcore.molang.MolangLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import team.unnamed.mocha.MochaEngine;

public class PlayerAnimationController
extends AnimationController {
    public static final Map<String, Vec3f> BONE_POSITIONS = Map.of("right_arm", new Vec3f(5.0f, 22.0f, 0.0f), "left_arm", new Vec3f(-5.0f, 22.0f, 0.0f), "left_leg", new Vec3f(-2.0f, 12.0f, 0.0f), "right_leg", new Vec3f(2.0f, 12.0f, 0.0f), "torso", new Vec3f(0.0f, 24.0f, 0.0f), "head", new Vec3f(0.0f, 24.0f, 0.0f), "body", new Vec3f(0.0f, 12.0f, 0.0f), "cape", new Vec3f(0.0f, 24.0f, 2.0f), "elytra", new Vec3f(0.0f, 24.0f, 2.0f));
    protected List<String> top_bones;
    protected final class_742 player;
    private float torsoBend;
    private float torsoBendYPosMultiplier;
    private float torsoBendZPosMultiplier;
    private int torsoBendSign;

    public PlayerAnimationController(class_742 player, AnimationController.AnimationStateHandler animationHandler) {
        this(player, animationHandler, MolangLoader::createNewEngine);
    }

    public PlayerAnimationController(class_742 player, AnimationController.AnimationStateHandler animationHandler, Function<AnimationController, MochaEngine<AnimationController>> molangRuntime) {
        super(animationHandler, molangRuntime);
        this.player = player;
    }

    public class_742 getPlayer() {
        return this.player;
    }

    public boolean triggerAnimation(class_2960 newAnimation, float startAnimFrom) {
        if (PlayerAnimResources.hasAnimation(newAnimation)) {
            this.triggerAnimation(PlayerAnimResources.getAnimation(newAnimation), startAnimFrom);
            return true;
        }
        return false;
    }

    public boolean triggerAnimation(class_2960 newAnimation) {
        return this.triggerAnimation(newAnimation, 0.0f);
    }

    public boolean replaceAnimationWithFade(@NotNull AbstractFadeModifier fadeModifier, @Nullable class_2960 newAnimation, boolean fadeFromNothing) {
        if (PlayerAnimResources.hasAnimation(newAnimation)) {
            this.replaceAnimationWithFade(fadeModifier, PlayerAnimResources.getAnimation(newAnimation), fadeFromNothing);
            return true;
        }
        return false;
    }

    public boolean replaceAnimationWithFade(@NotNull AbstractFadeModifier fadeModifier, @Nullable class_2960 newAnimation) {
        return this.replaceAnimationWithFade(fadeModifier, newAnimation, true);
    }

    @Nullable
    public class_4587 getBoneWorldPositionPoseStack(String name, float tickDelta, class_243 cameraPos) {
        if (!this.activeBones.containsKey(name)) {
            return null;
        }
        class_4587 poseStack = new class_4587();
        Vec3f pivot = this.getBonePosition(name);
        class_243 position = this.player.method_30950(tickDelta).method_1020(cameraPos).method_1031((double)pivot.x(), (double)pivot.y(), (double)pivot.z());
        poseStack.method_22904(position.method_10216(), position.method_10214(), position.method_10215());
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f - class_3532.method_16439((float)tickDelta, (float)this.player.field_6220, (float)this.player.field_6283)));
        RenderUtil.translateMatrixToBone(poseStack, (PlayerAnimBone)this.activeBones.get(name));
        return poseStack;
    }

    @Override
    public void registerBones() {
        this.top_bones = new ArrayList<String>();
        this.registerPlayerAnimBone("body");
        this.registerTopPlayerAnimBone("right_arm");
        this.registerTopPlayerAnimBone("left_arm");
        this.registerPlayerAnimBone("right_leg");
        this.registerPlayerAnimBone("left_leg");
        this.registerTopPlayerAnimBone("head");
        this.registerPlayerAnimBone("torso");
        this.registerPlayerAnimBone("right_item");
        this.registerPlayerAnimBone("left_item");
        this.registerTopPlayerAnimBone("cape");
        this.registerPlayerAnimBone("elytra");
    }

    public void registerTopPlayerAnimBone(String name) {
        this.top_bones.add(name);
        this.registerPlayerAnimBone(name);
    }

    @Override
    public void process(AnimationData state) {
        super.process(state);
        this.torsoBend = ((AdvancedPlayerAnimBone)this.bones.get("torso")).getBend();
        float absBend = class_3532.method_15379((float)this.torsoBend);
        if ((double)absBend > 0.001 && this.currentAnimation != null && this.currentAnimation.animation().data().getNullable("applyBendToOtherBones") == Boolean.TRUE) {
            this.torsoBendSign = class_3532.method_17822((double)this.torsoBend);
            this.torsoBendYPosMultiplier = -(1.0f - class_3532.method_15362((float)absBend));
            this.torsoBendZPosMultiplier = 1.0f - class_3532.method_15374((float)absBend);
        } else {
            this.torsoBendSign = 0;
        }
    }

    @Override
    public PlayerAnimBone get3DTransformRaw(@NotNull PlayerAnimBone bone) {
        bone = super.get3DTransformRaw(bone);
        String name = bone.getName();
        if (this.torsoBendSign != 0 && this.top_bones.contains(name)) {
            float offset = this.getBonePosition(name).y() - 18.0f;
            bone.rotX += this.torsoBend;
            bone.positionZ += (offset * this.torsoBendZPosMultiplier - offset) * (float)this.torsoBendSign;
            bone.positionY += offset * this.torsoBendYPosMultiplier;
        }
        return bone;
    }

    @Override
    public Vec3f getBonePosition(String name) {
        if (BONE_POSITIONS.containsKey(name)) {
            return BONE_POSITIONS.get(name);
        }
        if (this.pivotBones.containsKey(name)) {
            return ((PivotBone)this.pivotBones.get(name)).getPivot();
        }
        return Vec3f.ZERO;
    }
}

