/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.zigythebird.playeranim.PlayerAnimLibMod;
import com.zigythebird.playeranim.animation.PlayerAnimResources;
import com.zigythebird.playeranim.api.PlayerAnimationAccess;
import com.zigythebird.playeranim.commands.AnimationArgumentProvider;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.AnimationController;
import com.zigythebird.playeranimcore.animation.RawAnimation;
import com.zigythebird.playeranimcore.network.AnimationBinary;
import com.zigythebird.playeranimcore.network.LegacyAnimationBinary;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7157;
import net.minecraft.class_742;

public class PlayerAnimCommands {
    public static <T> void register(CommandDispatcher<T> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"testPlayerAnimation").then(class_2170.method_9244((String)"animationID", (ArgumentType)class_2232.method_9441()).suggests(new AnimationArgumentProvider()).executes(PlayerAnimCommands::execute)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"testLegacyAnimationBinary").then(class_2170.method_9244((String)"animationID", (ArgumentType)class_2232.method_9441()).suggests(new AnimationArgumentProvider()).then(class_2170.method_9244((String)"version", (ArgumentType)IntegerArgumentType.integer((int)1, (int)LegacyAnimationBinary.getCurrentVersion())).executes(PlayerAnimCommands::executeLegacy))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"testAnimationBinary").then(class_2170.method_9244((String)"animationID", (ArgumentType)class_2232.method_9441()).suggests(new AnimationArgumentProvider()).then(class_2170.method_9244((String)"version", (ArgumentType)IntegerArgumentType.integer((int)1, (int)4)).executes(PlayerAnimCommands::executeBinary))));
    }

    private static int execute(CommandContext<class_2168> context) {
        class_2960 animation = class_2232.method_9443(context, (String)"animationID");
        return PlayerAnimCommands.playAnimation(PlayerAnimResources.getAnimation(animation));
    }

    private static int executeLegacy(CommandContext<class_2168> context) {
        Animation animation = Objects.requireNonNull(PlayerAnimResources.getAnimation(class_2232.method_9443(context, (String)"animationID")));
        int version = IntegerArgumentType.getInteger(context, (String)"version");
        ByteBuffer byteBuffer = ByteBuffer.allocate(LegacyAnimationBinary.calculateSize(animation, version));
        LegacyAnimationBinary.write(animation, byteBuffer, version);
        byteBuffer.flip();
        try {
            return PlayerAnimCommands.playAnimation(LegacyAnimationBinary.read(byteBuffer, version));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int executeBinary(CommandContext<class_2168> context) {
        Animation animation = Objects.requireNonNull(PlayerAnimResources.getAnimation(class_2232.method_9443(context, (String)"animationID")));
        int version = IntegerArgumentType.getInteger(context, (String)"version");
        ByteBuf byteBuf = Unpooled.buffer();
        AnimationBinary.write(byteBuf, version, animation);
        return PlayerAnimCommands.playAnimation(AnimationBinary.read(byteBuf, version));
    }

    private static int playAnimation(Animation animation) {
        AnimationController controller = (AnimationController)PlayerAnimationAccess.getPlayerAnimationLayer((class_742)Objects.requireNonNull(class_310.method_1551().field_1724), PlayerAnimLibMod.ANIMATION_LAYER_ID);
        if (controller == null) {
            return 0;
        }
        controller.triggerAnimation(RawAnimation.begin().thenPlay(animation));
        return 1;
    }
}

