/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimcore.easing;

import com.zigythebird.playeranimcore.animation.keyframe.AnimationPoint;
import com.zigythebird.playeranimcore.easing.EasingType;
import com.zigythebird.playeranimcore.easing.EasingTypeTransformer;
import com.zigythebird.playeranimcore.math.MathHelper;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import team.unnamed.mocha.MochaEngine;
import team.unnamed.mocha.parser.ast.Expression;

public class CatmullRomEasing
implements EasingTypeTransformer {
    public static float getPointOnSpline(float delta, float p0, float p1, float p2, float p3) {
        return 0.5f * (2.0f * p1 + (p2 - p0) * delta + (2.0f * p0 - 5.0f * p1 + 4.0f * p2 - p3) * delta * delta + (3.0f * p1 - p0 - 3.0f * p2 + p3) * delta * delta * delta);
    }

    @Override
    public Float2FloatFunction buildTransformer(Float value) {
        return EasingType.easeIn(EasingType::linear);
    }

    @Override
    public float apply(MochaEngine<?> env, AnimationPoint animationPoint, @Nullable Float easingValue, float lerpValue) {
        if (animationPoint.currentTick() >= animationPoint.transitionLength()) {
            return animationPoint.animationEndValue();
        }
        List<List<Expression>> easingArgs = animationPoint.easingArgs();
        if (easingArgs.size() < 2) {
            return MathHelper.lerp(((Float)this.buildTransformer(easingValue).apply((Object)Float.valueOf(lerpValue))).floatValue(), animationPoint.animationStartValue(), animationPoint.animationEndValue());
        }
        return CatmullRomEasing.getPointOnSpline(lerpValue, env.eval(easingArgs.get(0)), animationPoint.animationStartValue(), animationPoint.animationEndValue(), env.eval(easingArgs.get(1)));
    }
}

