package com.zigythebird.playeranim.animation;

import com.zigythebird.playeranim.accessors.IAnimatedAvatar;
import com.zigythebird.playeranim.util.RenderUtil;
import com.zigythebird.playeranimcore.animation.AnimationData;
import com.zigythebird.playeranimcore.animation.layered.AnimationStack;
import com.zigythebird.playeranimcore.animation.layered.IAnimation;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.class_11890;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_5603;
import net.minecraft.class_630;
import org.jetbrains.annotations.ApiStatus;

/**
 * The animation data collection for a given player instance
 * <p>
 * Generally speaking, a single working-instance of a player will have a single instance of {@code PlayerAnimManager} associated with it
 */
public class AvatarAnimManager extends AnimationStack {
	private final class_11890 avatar;

	private float lastUpdateTime;
	private boolean isFirstTick = true;
	private float tickDelta;

	public AvatarAnimManager(class_11890 avatar) {
		this.avatar = avatar;
	}

    /**
	 * Tick and apply transformations to the model based on the current state of the {@link com.zigythebird.playeranimcore.animation.layered.AnimationContainer}
	 *
	 * @param playerAnimManager The PlayerAnimManager instance being used for this animation processor
	 * @param state	            An {@link AnimationData} instance applied to this render frame
	 */
	public void tickAnimation(AnimationStack playerAnimManager, AnimationData state) {
		playerAnimManager.getLayers().removeIf(pair -> pair.right() == null || pair.right().canRemove());
		for (Pair<Integer, IAnimation> pair : playerAnimManager.getLayers()) {
			IAnimation animation = pair.right();

			if (animation.isActive())
				animation.setupAnim(state.copy());
		}
		finishFirstTick();
	}

	public float getLastUpdateTime() {
		return this.lastUpdateTime;
	}

	public void updatedAt(float updateTime) {
		this.lastUpdateTime = updateTime;
	}

	public boolean isFirstTick() {
		return this.isFirstTick;
	}

	protected void finishFirstTick() {
		this.isFirstTick = false;
	}

	public float getTickDelta() {
		return this.tickDelta;
	}

	/**
	 * If you touch this, you're a horrible person.
	 */
	@ApiStatus.Internal
	public void setTickDelta(float tickDelta) {
		this.tickDelta = tickDelta;
	}

	public void updatePart(class_630 part, PlayerAnimBone bone) {
		class_5603 initialPose = part.method_41921();
		bone = this.get3DTransform(bone);
		RenderUtil.translatePartToBone(part, bone, initialPose);
	}

	public void handleAnimations(float partialTick, boolean fullTick) {
		class_243 velocity = avatar.method_18798();

		AvatarAnimManager animatableManager = ((IAnimatedAvatar)avatar).playerAnimLib$getAnimManager();
		int currentTick = avatar.field_6012;

		float currentFrameTime = currentTick + partialTick;

		AnimationData animationData = new AnimationData((float) ((Math.abs(velocity.field_1352) + Math.abs(velocity.field_1350)) / 2f), partialTick);

		if (fullTick) animatableManager.tick(animationData.copy());

		if (!animatableManager.isFirstTick() && currentFrameTime == animatableManager.getLastUpdateTime())
			return;

		if (!class_310.method_1551().method_1493()) {
			animatableManager.updatedAt(currentFrameTime);
		}

		this.tickAnimation(animatableManager, animationData);
	}

	public class_11890 getAvatar() {
		return avatar;
	}
}
