/*
 * MIT License
 *
 * Copyright (c) 2022 KosmX
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.zigythebird.playeranim.mixin;

import com.zigythebird.playeranim.accessors.IAvatarAnimationState;
import com.zigythebird.playeranim.util.RenderUtil;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonMode;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import net.minecraft.class_10042;
import net.minecraft.class_10055;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_4587;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_922;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_922.class)
public class LivingEntityRendererMixin<S extends class_10042, M extends class_583<? super S>> {
    @Shadow protected M model;

    @Inject(method = "submit(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V", at = @At("TAIL"))
    private void render(S livingEntityRenderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState, CallbackInfo ci) {
        if (FirstPersonMode.isFirstPersonPass() && livingEntityRenderState instanceof IAvatarAnimationState state && state.playerAnimLib$isCameraEntity()) {
            playerAnimLib$setAllPartsVisible(true);
        }
    }
    
    @Inject(method = "submit(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;scale(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;)V"))
    private void doTranslations(S livingEntityRenderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState, CallbackInfo ci) {
        if (livingEntityRenderState instanceof class_10055 playerRenderState) {
            var animationPlayer = ((IAvatarAnimationState)playerRenderState).playerAnimLib$getAnimManager();
            if (animationPlayer != null && animationPlayer.isActive()) {
                ((IAvatarAnimationState)playerRenderState).playerAnimLib$getAnimManager().handleAnimations(animationPlayer.getTickDelta(), false);
                poseStack.method_22905(-1.0F, -1.0F, 1.0F);

                //These are additive properties
                PlayerAnimBone body = animationPlayer.get3DTransform(new PlayerAnimBone("body"));

                poseStack.method_22904(-body.getPosX()/16, body.getPosY()/16 + 0.75, body.getPosZ()/16);
                body.rotX *= -1;
                body.rotY *= -1;
                RenderUtil.rotateMatrixAroundBone(poseStack, body);
                poseStack.method_22905(body.getScaleX(), body.getScaleY(), body.getScaleZ());

                poseStack.method_22904(0, -0.75, 0);

                poseStack.method_22905(-1.0F, -1.0F, 1.0F);
            }
        }
    }

    @Unique
    private void playerAnimLib$setAllPartsVisible(boolean visible) {
        class_591 model = (class_591)this.model;

        model.field_3398.field_3665 = visible;
        model.field_3391.field_3665 = visible;
        model.field_3397.field_3665 = visible;
        model.field_3392.field_3665 = visible;
        model.field_3401.field_3665 = visible;
        model.field_27433.field_3665 = visible;
    }
}
