/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zigythebird.playeranim.accessors.IPlayerAnimationState;
import com.zigythebird.playeranim.animation.PlayerAnimManager;
import com.zigythebird.playeranim.util.RenderUtil;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonMode;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public class LivingEntityRendererMixin<S extends LivingEntityRenderState, M extends EntityModel<? super S>> {
    @Shadow
    protected M field_4737;

    @Inject(method={"render(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="TAIL")})
    private void render(S entityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        IPlayerAnimationState state;
        if (FirstPersonMode.isFirstPersonPass() && entityRenderState instanceof IPlayerAnimationState && (state = (IPlayerAnimationState)entityRenderState).playerAnimLib$isCameraEntity()) {
            this.playerAnimLib$setAllPartsVisible(true);
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;scale(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;)V")})
    private void doTranslations(S livingEntityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        PlayerRenderState playerRenderState;
        PlayerAnimManager animationPlayer;
        if (livingEntityRenderState instanceof PlayerRenderState && (animationPlayer = (playerRenderState = (PlayerRenderState)livingEntityRenderState).playerAnimLib$getAnimManager()) != null && animationPlayer.isActive()) {
            playerRenderState.playerAnimLib$getAnimProcessor().handleAnimations(animationPlayer.getTickDelta(), false);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            PlayerAnimBone body = animationPlayer.get3DTransform(new PlayerAnimBone("body"));
            poseStack.translate((double)(-body.getPosX() / 16.0f), (double)(body.getPosY() / 16.0f) + 0.75, (double)(body.getPosZ() / 16.0f));
            body.rotX *= -1.0f;
            body.rotY *= -1.0f;
            RenderUtil.rotateMatrixAroundBone(poseStack, body);
            poseStack.scale(body.getScaleX(), body.getScaleY(), body.getScaleZ());
            poseStack.translate(0.0, -0.75, 0.0);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
        }
    }

    @Unique
    private void playerAnimLib$setAllPartsVisible(boolean visible) {
        PlayerModel model = (PlayerModel)this.field_4737;
        model.head.visible = visible;
        model.body.visible = visible;
        model.leftLeg.visible = visible;
        model.rightLeg.visible = visible;
        model.rightArm.visible = visible;
        model.leftArm.visible = visible;
    }
}

