/*
 * MIT License
 *
 * Copyright (c) 2022 KosmX
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.zigythebird.playeranim.mixin;

import com.zigythebird.playeranim.accessors.IPlayerAnimationState;
import com.zigythebird.playeranim.animation.PlayerAnimManager;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import net.minecraft.class_10426;
import net.minecraft.class_10444;
import net.minecraft.class_1306;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_989;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_989.class)
public class ItemInHandLayerMixin {
    @Unique
    private final PlayerAnimBone playerAnimLib$rightItem = new PlayerAnimBone("right_item");
    @Unique
    private final PlayerAnimBone playerAnimLib$leftItem = new PlayerAnimBone("left_item");

    @Inject(method = "renderArmWithItem", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionfc;)V", ordinal = 0))
    private void changeItemLocation(class_10426 renderState, class_10444 itemStackRenderState, class_1306 arm, class_4587 matrices, class_4597 multiBufferSource, int i, CallbackInfo ci) {
        if (renderState instanceof IPlayerAnimationState state && state.playerAnimLib$getAnimManager() != null && state.playerAnimLib$getAnimManager().isActive()) {
            PlayerAnimManager anim = state.playerAnimLib$getAnimManager();
            if (anim == null) return;
            PlayerAnimBone bone;

            if (arm == class_1306.field_6182) bone = playerAnimLib$leftItem;
            else bone = playerAnimLib$rightItem;

            bone.setToInitialPose();
            anim.get3DTransform(bone);

            matrices.method_46416(bone.getPosX()/16, bone.getPosY()/16, bone.getPosZ()/16);
        }
    }

    @Inject(method = "renderArmWithItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/item/ItemStackRenderState;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V"))
    private void changeItemRotationAndScale(class_10426 renderState, class_10444 itemStackRenderState, class_1306 arm, class_4587 poseStack, class_4597 bufferSource, int packedLight, CallbackInfo ci) {
        if (renderState instanceof IPlayerAnimationState state && state.playerAnimLib$getAnimManager() != null && state.playerAnimLib$getAnimManager().isActive()) {
            PlayerAnimManager anim = state.playerAnimLib$getAnimManager();
            if (anim == null) return;
            PlayerAnimBone bone;

            if (arm == class_1306.field_6182) bone = playerAnimLib$leftItem;
            else bone = playerAnimLib$rightItem;

            if (bone.getRotY() != 0)
                poseStack.method_22907(class_7833.field_40718.rotation(-bone.getRotY()));

            if (bone.getRotZ() != 0)
                poseStack.method_22907(class_7833.field_40716.rotation(-bone.getRotZ()));

            if (bone.getRotX() != 0)
                poseStack.method_22907(class_7833.field_40714.rotation(-bone.getRotX()));

            poseStack.method_22905(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
        }
    }
}
